/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.version.format;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeSet;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsString;
import net.thevpc.nuts.NutsTerminalMode;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsTexts;
import net.thevpc.nuts.NutsVersion;
import net.thevpc.nuts.NutsVersionFormat;
import net.thevpc.nuts.runtime.standalone.format.DefaultFormatBase;
import net.thevpc.nuts.spi.NutsSupportLevelContext;

public class DefaultNutsVersionFormat
extends DefaultFormatBase<NutsVersionFormat>
implements NutsVersionFormat {
    private final Map<String, String> extraProperties = new LinkedHashMap<String, String>();
    private boolean all;
    private NutsVersion version;

    public DefaultNutsVersionFormat(NutsSession session) {
        super(session, "version");
    }

    public boolean configureFirst(NutsCommandLine cmdLine) {
        this.checkSession();
        NutsArgument a = cmdLine.peek();
        if (a == null) {
            return false;
        }
        boolean enabled = a.isActive();
        switch (a.getKey().getString()) {
            case "-a": 
            case "--all": {
                boolean val = cmdLine.nextBoolean(new String[0]).getBooleanValue();
                if (enabled) {
                    this.all = val;
                }
                return true;
            }
            case "--add": {
                NutsArgument aa = cmdLine.nextString(new String[0]);
                NutsArgument r = NutsArgument.of((String)aa.getValue().getString(), (NutsSession)this.getSession());
                if (enabled) {
                    this.all = true;
                    this.extraProperties.put(r.getKey().getString(), r.getValue().getString());
                }
                return true;
            }
        }
        return this.getSession().configureFirst(cmdLine);
    }

    public NutsVersionFormat addProperty(String key, String value) {
        if (value == null) {
            this.extraProperties.remove(key);
        } else {
            this.extraProperties.put(key, value);
        }
        return this;
    }

    public NutsVersionFormat addProperties(Map<String, String> p) {
        if (p != null) {
            for (Map.Entry<String, String> entry : p.entrySet()) {
                this.addProperty(entry.getKey(), entry.getValue());
            }
        }
        return this;
    }

    public NutsVersion getVersion() {
        return this.version;
    }

    public NutsVersionFormat setVersion(NutsVersion version) {
        this.version = version;
        return this;
    }

    public boolean isWorkspaceVersion() {
        return this.version == null;
    }

    @Override
    public void print(NutsPrintStream out) {
        this.checkSession();
        if (!this.isNtf()) {
            out = out.setMode(NutsTerminalMode.FILTERED);
        }
        if (this.getSession().isPlainOut()) {
            if (this.isWorkspaceVersion()) {
                out.printf("%s/%s", new Object[]{this.getSession().getWorkspace().getApiVersion(), this.getSession().getWorkspace().getRuntimeId().getVersion()});
            } else {
                out.printf("%s", new Object[]{NutsTexts.of((NutsSession)this.getSession()).ofStyled(this.getVersion().toString(), NutsTextStyle.version())});
            }
        } else if (this.isWorkspaceVersion()) {
            out.printf(this.buildProps());
        } else {
            out.print((NutsString)NutsTexts.of((NutsSession)this.getSession()).ofStyled(this.getVersion().toString(), NutsTextStyle.version()));
        }
    }

    public Map<String, String> buildProps() {
        LinkedHashMap<String, String> props = new LinkedHashMap<String, String>();
        TreeSet<Object> extraKeys = new TreeSet();
        if (this.extraProperties != null) {
            extraKeys = new TreeSet<String>(this.extraProperties.keySet());
        }
        NutsSession ws = this.getSession();
        props.put("nuts-api-version", ws.getWorkspace().getApiVersion().toString());
        props.put("nuts-runtime-version", ws.getWorkspace().getRuntimeId().getVersion().toString());
        if (this.all) {
            props.put("java-version", System.getProperty("java.version"));
            props.put("os-version", ws.env().getOs().getVersion().toString());
        }
        for (String string : extraKeys) {
            props.put(string, this.extraProperties.get(string));
        }
        return props;
    }

    public int getSupportLevel(NutsSupportLevelContext context) {
        return 10;
    }
}

