/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.version.filter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsFilter;
import net.thevpc.nuts.NutsFilterOp;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsVersion;
import net.thevpc.nuts.NutsVersionFilter;
import net.thevpc.nuts.runtime.standalone.id.filter.NutsExprIdFilter;
import net.thevpc.nuts.runtime.standalone.util.Simplifiable;
import net.thevpc.nuts.runtime.standalone.util.filters.CoreFilterUtils;
import net.thevpc.nuts.runtime.standalone.version.filter.AbstractVersionFilter;

public class NutsVersionFilterNone
extends AbstractVersionFilter
implements NutsVersionFilter,
Simplifiable<NutsVersionFilter>,
NutsExprIdFilter {
    private NutsVersionFilter[] all;

    public NutsVersionFilterNone(NutsSession session, NutsVersionFilter ... all) {
        super(session, NutsFilterOp.NOT);
        ArrayList<NutsVersionFilter> valid = new ArrayList<NutsVersionFilter>();
        if (all != null) {
            for (NutsVersionFilter filter : all) {
                if (filter == null) continue;
                valid.add(filter);
            }
        }
        this.all = valid.toArray(new NutsVersionFilter[0]);
    }

    public boolean acceptVersion(NutsVersion id, NutsSession session) {
        if (this.all.length == 0) {
            return true;
        }
        for (NutsVersionFilter filter : this.all) {
            if (!filter.acceptVersion(id, session)) continue;
            return false;
        }
        return true;
    }

    @Override
    public NutsVersionFilter simplify() {
        return CoreFilterUtils.simplifyFilterNone(this.getSession(), NutsVersionFilter.class, this, (NutsFilter[])this.all);
    }

    @Override
    public String toExpr() {
        StringBuilder sb = new StringBuilder();
        if (this.all.length == 0) {
            return "true";
        }
        if (this.all.length > 1) {
            sb.append("(");
        }
        for (NutsVersionFilter id : this.all) {
            String expr;
            if (sb.length() > 0) {
                sb.append(" && ");
            }
            if (id instanceof NutsExprIdFilter) {
                NutsExprIdFilter b = (NutsExprIdFilter)id;
                expr = b.toExpr();
                if (NutsBlankable.isBlank((String)expr)) {
                    return null;
                }
            } else {
                return null;
            }
            sb.append("(").append(expr).append("')");
        }
        if (this.all.length > 0) {
            sb.append(")");
        }
        return sb.toString();
    }

    public int hashCode() {
        int hash = 5;
        hash = 37 * hash + Arrays.deepHashCode(this.all);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NutsVersionFilterNone other = (NutsVersionFilterNone)obj;
        return Arrays.deepEquals(this.all, other.all);
    }

    public String toString() {
        return "Not(" + String.join((CharSequence)" Or ", Arrays.asList(this.all).stream().map(x -> "(" + x.toString() + ")").collect(Collectors.toList())) + ")";
    }

    @Override
    public NutsFilter[] getSubFilters() {
        return this.all;
    }
}

