/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.version.filter;

import java.io.IOException;
import java.io.Serializable;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.thevpc.nuts.NutsFilterOp;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsParseException;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsVersion;
import net.thevpc.nuts.NutsVersionFilter;
import net.thevpc.nuts.NutsVersionFilters;
import net.thevpc.nuts.NutsVersionInterval;
import net.thevpc.nuts.runtime.standalone.id.filter.NutsExprIdFilter;
import net.thevpc.nuts.runtime.standalone.util.CoreStringUtils;
import net.thevpc.nuts.runtime.standalone.util.Simplifiable;
import net.thevpc.nuts.runtime.standalone.util.filters.CoreFilterUtils;
import net.thevpc.nuts.runtime.standalone.version.DefaultNutsVersion;
import net.thevpc.nuts.runtime.standalone.version.DefaultNutsVersionInterval;
import net.thevpc.nuts.runtime.standalone.version.filter.AbstractVersionFilter;

public class DefaultNutsVersionFilter
extends AbstractVersionFilter
implements NutsVersionFilter,
Simplifiable<NutsVersionFilter>,
NutsExprIdFilter,
Serializable {
    private static final long serialVersionUID = 1L;
    private final List<NutsVersionInterval> intervals = new ArrayList<NutsVersionInterval>();

    public DefaultNutsVersionFilter(NutsSession session) {
        super(session, NutsFilterOp.CUSTOM);
    }

    public static NutsVersionFilter parse(String version, NutsSession session) {
        if (DefaultNutsVersion.isBlankVersion(version) || "*".equals(version)) {
            return (NutsVersionFilter)NutsVersionFilters.of((NutsSession)session).always();
        }
        ParseHelper pp = new ParseHelper(session);
        return pp.parse(version);
    }

    public boolean acceptVersion(NutsVersion version, NutsSession session) {
        if (this.intervals.isEmpty()) {
            return true;
        }
        for (NutsVersionInterval value : this.intervals) {
            if (!value.acceptVersion(version)) continue;
            return true;
        }
        return false;
    }

    public NutsVersionInterval[] getIntervals() {
        return this.intervals.toArray(new NutsVersionInterval[0]);
    }

    public void add(NutsVersionInterval interval) {
        this.intervals.add(interval);
    }

    @Override
    public String toExpr() {
        return "id.version.matches('" + CoreStringUtils.escapeQuoteStrings(this.toString()) + "')";
    }

    @Override
    public NutsVersionFilter simplify() {
        ArrayList<NutsVersionInterval> intervals2 = new ArrayList<NutsVersionInterval>();
        boolean updates = false;
        for (NutsVersionInterval interval : this.intervals) {
            NutsVersionInterval _interval = CoreFilterUtils.simplify(interval);
            if (_interval != null) {
                if (_interval.getLowerBound() == null && _interval.getUpperBound() == null) {
                    return null;
                }
                if (!_interval.equals(interval)) {
                    updates = true;
                }
                intervals2.add(interval);
                continue;
            }
            updates = true;
        }
        if (intervals2.isEmpty()) {
            return null;
        }
        if (!updates) {
            return this;
        }
        DefaultNutsVersionFilter d = new DefaultNutsVersionFilter(this.getSession());
        d.intervals.addAll(intervals2);
        return d;
    }

    public int hashCode() {
        int hash = 3;
        hash = 71 * hash + Objects.hashCode(this.intervals);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultNutsVersionFilter other = (DefaultNutsVersionFilter)obj;
        return Objects.equals(this.intervals, other.intervals);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (NutsVersionInterval interval : this.intervals) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(interval.toString());
        }
        return sb.toString();
    }

    private static class ParseHelper {
        final int START = 0;
        final int NEXT = 1;
        final int NEXT_COMMA = 2;
        final int EXPECT_V1 = 3;
        final int EXPECT_V_COMMA = 4;
        final int EXPECT_V2 = 5;
        final int EXPECT_CLOSE = 6;
        int t;
        int state = 1;
        int open = -1;
        int close = -1;
        String v1 = null;
        String v2 = null;
        DefaultNutsVersionFilter dd;
        NutsSession session;

        public ParseHelper(NutsSession session) {
            this.session = session;
            this.dd = new DefaultNutsVersionFilter(session);
        }

        void reset() {
            this.open = -1;
            this.close = -1;
            this.v1 = null;
            this.v2 = null;
        }

        void addNextValue(String sval) {
            if (sval.endsWith("*")) {
                String min = sval.substring(0, sval.length() - 1);
                if (min.equals("")) {
                    this.dd.add(new DefaultNutsVersionInterval(false, false, min, null));
                } else {
                    String max = NutsVersion.of((String)min, (NutsSession)this.session).inc(-1).getValue();
                    this.dd.add(new DefaultNutsVersionInterval(true, false, min, max));
                }
            } else {
                this.dd.add(new DefaultNutsVersionInterval(true, true, sval, sval));
            }
        }

        void addNextInterval() {
            boolean inclusiveLowerBoundary = this.open == 91 && this.v1 != null;
            boolean inclusiveUpperBoundary = this.close == 93 && this.v2 != null;
            this.dd.add(new DefaultNutsVersionInterval(inclusiveLowerBoundary, inclusiveUpperBoundary, this.v1, this.v2));
            this.reset();
        }

        NutsVersionFilter parse(String version) {
            StreamTokenizer st = new StreamTokenizer(new StringReader(version));
            st.resetSyntax();
            st.whitespaceChars(0, 32);
            block36: for (int i = 33; i < 256; ++i) {
                switch ((char)i) {
                    case '(': 
                    case ')': 
                    case ',': 
                    case '[': 
                    case ']': {
                        continue block36;
                    }
                    default: {
                        st.wordChars(i, i);
                    }
                }
            }
            try {
                block37: while ((this.t = st.nextToken()) != -1) {
                    switch (this.state) {
                        case 0: 
                        case 1: {
                            switch (this.t) {
                                case -3: {
                                    this.addNextValue(st.sval);
                                    this.state = 2;
                                    continue block37;
                                }
                                case 40: 
                                case 91: 
                                case 93: {
                                    this.open = this.t;
                                    this.state = 3;
                                    continue block37;
                                }
                            }
                            throw new NutsParseException(this.session, NutsMessage.cstyle((String)"unexpected  %s", (Object[])new Object[]{Character.valueOf((char)this.t)}));
                        }
                        case 2: {
                            switch (this.t) {
                                case 44: {
                                    this.state = 1;
                                    continue block37;
                                }
                            }
                            throw new NutsParseException(this.session, NutsMessage.cstyle((String)"expected ',' found %s", (Object[])new Object[]{Character.valueOf((char)this.t)}));
                        }
                        case 3: {
                            switch (this.t) {
                                case -3: {
                                    this.v1 = st.sval;
                                    this.state = 4;
                                    continue block37;
                                }
                                case 44: {
                                    this.state = 5;
                                    continue block37;
                                }
                            }
                            throw new NutsParseException(this.session, NutsMessage.cstyle((String)"unexpected %s", (Object[])new Object[]{Character.valueOf((char)this.t)}));
                        }
                        case 4: {
                            switch (this.t) {
                                case 44: {
                                    this.state = 5;
                                    continue block37;
                                }
                                case 93: {
                                    this.close = this.t;
                                    this.v2 = this.v1;
                                    this.addNextInterval();
                                    this.state = 2;
                                    continue block37;
                                }
                                case 41: 
                                case 91: {
                                    this.close = this.t;
                                    this.v2 = this.v1;
                                    this.addNextInterval();
                                    this.state = 2;
                                    continue block37;
                                }
                            }
                            throw new NutsParseException(this.session, NutsMessage.cstyle((String)"unexpected %s", (Object[])new Object[]{Character.valueOf((char)this.t)}));
                        }
                        case 5: {
                            switch (this.t) {
                                case -3: {
                                    this.v2 = st.sval;
                                    this.state = 6;
                                    continue block37;
                                }
                                case 41: 
                                case 91: 
                                case 93: {
                                    this.close = this.t;
                                    this.addNextInterval();
                                    this.state = 2;
                                    continue block37;
                                }
                            }
                            throw new NutsParseException(this.session, NutsMessage.cstyle((String)"unexpected %s", (Object[])new Object[]{Character.valueOf((char)this.t)}));
                        }
                        case 6: {
                            switch (this.t) {
                                case 41: 
                                case 91: 
                                case 93: {
                                    this.close = this.t;
                                    this.addNextInterval();
                                    this.state = 2;
                                    continue block37;
                                }
                            }
                            throw new NutsParseException(this.session, NutsMessage.cstyle((String)"unexpected %s", (Object[])new Object[]{Character.valueOf((char)this.t)}));
                        }
                    }
                    throw new NutsParseException(this.session, NutsMessage.cstyle((String)"unsupported state %s", (Object[])new Object[]{this.state}));
                }
                if (this.state != 2 && this.state != 0) {
                    throw new NutsParseException(this.session, NutsMessage.cstyle((String)"invalid state %s", (Object[])new Object[]{this.state}));
                }
            }
            catch (IOException ex) {
                throw new NutsIllegalArgumentException(this.session, NutsMessage.cstyle((String)"parse version failed: %s", (Object[])new Object[]{version}), (Throwable)ex);
            }
            return this.dd;
        }
    }
}

