/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.version;

import java.util.regex.Pattern;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsParseException;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.NutsVersion;
import net.thevpc.nuts.NutsVersionParser;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.standalone.version.DefaultNutsVersion;
import net.thevpc.nuts.spi.NutsSupportLevelContext;

public class DefaultNutsVersionParser
implements NutsVersionParser {
    private static final Pattern PATTERN = Pattern.compile("[A-Za-z0-9._*,()\\[\\] ${}+-]+");
    private NutsSession session;
    private boolean lenient = false;
    private boolean acceptBlank = true;
    private boolean acceptIntervals = true;

    public DefaultNutsVersionParser(NutsSession session) {
        this.session = session;
    }

    public NutsWorkspace getWs() {
        return this.session.getWorkspace();
    }

    public boolean isLenient() {
        return this.lenient;
    }

    public DefaultNutsVersionParser setLenient(boolean lenient) {
        this.lenient = lenient;
        return this;
    }

    public boolean isAcceptBlank() {
        return this.acceptBlank;
    }

    public NutsVersionParser setAcceptBlank(boolean acceptBlank) {
        this.acceptBlank = acceptBlank;
        return this;
    }

    public boolean isAcceptIntervals() {
        return this.acceptIntervals;
    }

    public NutsVersionParser setAcceptIntervals(boolean acceptIntervals) {
        this.acceptIntervals = acceptIntervals;
        return this;
    }

    public NutsVersion parse(String version) {
        if (NutsBlankable.isBlank((String)version)) {
            if (this.isAcceptBlank()) {
                return new DefaultNutsVersion("", this.session);
            }
            throw new NutsParseException(this.session, NutsMessage.plain((String)"blank version"));
        }
        String version2 = NutsUtilStrings.trim((String)version);
        if (PATTERN.matcher(version2).matches()) {
            DefaultNutsVersion v = new DefaultNutsVersion(version2, this.session);
            if (!this.isAcceptIntervals() && v.isFilter()) {
                throw new NutsParseException(this.session, NutsMessage.cstyle((String)"invalid version format : %s", (Object[])new Object[]{version}));
            }
            return v;
        }
        throw new NutsParseException(this.session, NutsMessage.cstyle((String)"invalid version format : %s", (Object[])new Object[]{version}));
    }

    public int getSupportLevel(NutsSupportLevelContext context) {
        return 10;
    }
}

