/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.version;

import java.io.Serializable;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.NutsVersion;
import net.thevpc.nuts.NutsVersionInterval;

public class DefaultNutsVersionInterval
implements NutsVersionInterval,
Serializable {
    private static final long serialVersionUID = 1L;
    private final boolean includeLowerBound;
    private final boolean includeUpperBound;
    private final String lowerBound;
    private final String upperBound;

    public DefaultNutsVersionInterval(boolean inclusiveLowerBoundary, boolean inclusiveUpperBoundary, String min, String max) {
        this.includeLowerBound = inclusiveLowerBoundary;
        this.includeUpperBound = inclusiveUpperBoundary;
        this.lowerBound = NutsUtilStrings.trimToNull((String)min);
        this.upperBound = NutsUtilStrings.trimToNull((String)max);
    }

    public boolean acceptVersion(NutsVersion version) {
        int t;
        if (!(NutsBlankable.isBlank((String)this.lowerBound) || this.lowerBound.equals("LATEST") || this.lowerBound.equals("RELEASE"))) {
            t = version.compareTo(this.lowerBound);
            if (this.includeLowerBound && t < 0 || !this.includeLowerBound && t <= 0) {
                return false;
            }
        }
        if (!(NutsBlankable.isBlank((String)this.upperBound) || this.upperBound.equals("LATEST") || this.upperBound.equals("RELEASE"))) {
            t = version.compareTo(this.upperBound);
            return !(this.includeUpperBound && t > 0 || !this.includeUpperBound && t >= 0);
        }
        return true;
    }

    public boolean isFixedValue() {
        return this.includeLowerBound && this.includeUpperBound && NutsUtilStrings.trim((String)this.lowerBound).equals(NutsUtilStrings.trim((String)this.upperBound)) && !"LATEST".equals(this.lowerBound) && !"RELEASE".equals(this.lowerBound);
    }

    public boolean isIncludeLowerBound() {
        return this.includeLowerBound;
    }

    public boolean isIncludeUpperBound() {
        return this.includeUpperBound;
    }

    public String getLowerBound() {
        return this.lowerBound;
    }

    public String getUpperBound() {
        return this.upperBound;
    }

    public String toString() {
        if (this.lowerBound != null && this.lowerBound.equals(this.upperBound) && this.includeLowerBound && this.includeUpperBound) {
            return "[" + this.lowerBound + "]";
        }
        return (this.includeLowerBound ? "[" : "]") + (this.lowerBound == null ? "" : this.lowerBound) + "," + (this.upperBound == null ? "" : this.upperBound) + (this.includeUpperBound ? "]" : "[");
    }
}

