/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.version;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsFormat;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.NutsVersion;
import net.thevpc.nuts.NutsVersionFilter;
import net.thevpc.nuts.NutsVersionFormat;
import net.thevpc.nuts.NutsVersionInterval;
import net.thevpc.nuts.runtime.standalone.util.CoreNumberUtils;
import net.thevpc.nuts.runtime.standalone.util.CoreStringUtils;
import net.thevpc.nuts.runtime.standalone.version.filter.DefaultNutsVersionFilter;

public class DefaultNutsVersion
implements NutsVersion {
    private static final long serialVersionUID = 1L;
    private final transient NutsSession session;
    protected String expression;
    private VersionParts parts;

    public DefaultNutsVersion(String expression, NutsSession session) {
        this.expression = NutsUtilStrings.trim((String)expression);
        this.session = session;
    }

    public static boolean versionMatches(String version, String pattern) {
        if (DefaultNutsVersion.isBlankVersion(pattern)) {
            return true;
        }
        return pattern.equals(version);
    }

    public static String incVersion(String oldVersion, int level, long count) {
        return DefaultNutsVersion.incVersion(oldVersion, level, BigInteger.valueOf(count));
    }

    public static String incVersion(String oldVersion, int level, BigInteger count) {
        VersionParts parts;
        int digitCount;
        if (count == null) {
            count = BigInteger.ZERO;
        }
        if ((digitCount = (parts = DefaultNutsVersion.splitVersionParts2(oldVersion)).getDigitCount()) == 0) {
            parts.addDigit(BigInteger.ZERO, ".");
            digitCount = parts.getDigitCount();
        }
        if (level < 0) {
            for (level = digitCount + level; level < 0; ++level) {
                parts.addDigit(BigInteger.ZERO, ".");
            }
            VersionPart digit = parts.getDigit(level);
            digit.string = String.valueOf(new BigInteger(digit.string).add(count));
            return parts.toString();
        }
        for (int i = digitCount; i < level; ++i) {
            parts.addDigit(BigInteger.ZERO, ".");
        }
        VersionPart digit = parts.getDigit(level);
        digit.string = String.valueOf(new BigInteger(digit.string).add(count));
        return parts.toString();
    }

    public static int compareVersions(String v1, String v2) {
        if ((v1 = NutsUtilStrings.trim((String)v1)).equals(v2 = NutsUtilStrings.trim((String)v2))) {
            return 0;
        }
        if ("LATEST".equals(v1)) {
            return 1;
        }
        if ("LATEST".equals(v2)) {
            return -1;
        }
        if ("RELEASE".equals(v1)) {
            return 1;
        }
        if ("RELEASE".equals(v2)) {
            return -1;
        }
        VersionParts v1arr = DefaultNutsVersion.splitVersionParts2(v1);
        VersionParts v2arr = DefaultNutsVersion.splitVersionParts2(v2);
        return v1arr.compareTo(v2arr);
    }

    private static VersionParts splitVersionParts2(String v1) {
        v1 = NutsUtilStrings.trim((String)v1);
        ArrayList<VersionPart> parts = new ArrayList<VersionPart>();
        StringBuilder last = null;
        VersionPartType partType = null;
        for (char c : v1.toCharArray()) {
            if (Character.isDigit(c)) {
                if (last == null) {
                    last = new StringBuilder();
                    last.append(c);
                    partType = VersionPartType.NUMBER;
                    continue;
                }
                if (partType == VersionPartType.NUMBER) {
                    last.append(c);
                    continue;
                }
                parts.add(new VersionPart(last.toString(), partType));
                CoreStringUtils.clear(last);
                partType = VersionPartType.NUMBER;
                last.append(c);
                continue;
            }
            if (c == '.' || c == '-') {
                if (last == null) {
                    parts.add(new VersionPart(String.valueOf(c), VersionPartType.SEPARATOR));
                    partType = VersionPartType.SEPARATOR;
                    continue;
                }
                if (partType == VersionPartType.NUMBER) {
                    parts.add(new VersionPart(last.toString(), partType));
                    last = null;
                    partType = VersionPartType.SEPARATOR;
                    continue;
                }
                parts.add(new VersionPart(last.toString(), partType));
                last = null;
                partType = VersionPartType.SEPARATOR;
                continue;
            }
            if (last == null) {
                partType = VersionPartType.QAL;
                last = new StringBuilder();
                last.append(c);
                continue;
            }
            if (partType == VersionPartType.QAL) {
                last.append(c);
                continue;
            }
            parts.add(new VersionPart(last.toString(), partType));
            partType = VersionPartType.QAL;
            CoreStringUtils.clear(last);
            last.append(c);
        }
        if (last != null && last.length() > 0) {
            parts.add(new VersionPart(last.toString(), partType));
        }
        return new VersionParts(parts);
    }

    public static Integer getKnownQualifierIndex(String v1) {
        switch (v1.toLowerCase()) {
            case "a": 
            case "alpha": {
                return 1;
            }
            case "b": 
            case "beta": {
                return 2;
            }
            case "m": 
            case "milestone": {
                return 3;
            }
            case "rc": 
            case "cr": {
                return 4;
            }
            case "snapshot": {
                return 5;
            }
            case "": 
            case "ga": 
            case "final": {
                return 6;
            }
            case "sp": {
                return 7;
            }
        }
        return null;
    }

    public static boolean isBlankVersion(String pattern) {
        if (NutsBlankable.isBlank((String)pattern)) {
            return true;
        }
        return "LATEST".equals(pattern) || "RELEASE".equals(pattern);
    }

    public static boolean isStaticVersionPattern(String pattern) {
        if (DefaultNutsVersion.isBlankVersion(pattern)) {
            return false;
        }
        return !pattern.contains("[") && !pattern.contains("]") && !pattern.contains(",") && !pattern.contains("*");
    }

    public boolean isNull() {
        return this.expression == null;
    }

    public boolean isBlank() {
        return this.expression == null || this.expression.trim().isEmpty();
    }

    public String getValue() {
        return this.expression;
    }

    public int compareTo(String other) {
        return DefaultNutsVersion.compareVersions(this.expression, other);
    }

    public int compareTo(NutsVersion other) {
        return this.compareTo(other == null ? null : other.getValue());
    }

    public NutsVersionFilter filter() {
        return DefaultNutsVersionFilter.parse(this.expression, this.session);
    }

    public NutsVersion compatNewer() {
        String v = this.toExplicitSingleValueOrNullString();
        if (v == null) {
            return this;
        }
        return new DefaultNutsVersion("[" + this.expression + ",[", this.session);
    }

    public NutsVersion compatOlder() {
        String v = this.toExplicitSingleValueOrNullString();
        if (v == null) {
            return this;
        }
        return new DefaultNutsVersion("]," + v + "]", this.session);
    }

    public NutsVersionInterval[] intervals() {
        NutsVersionFilter s = this.filter();
        if (s instanceof DefaultNutsVersionFilter) {
            return ((DefaultNutsVersionFilter)s).getIntervals();
        }
        return new NutsVersionInterval[0];
    }

    public boolean isSingleValue() {
        NutsVersionInterval[] nutsVersionIntervals = this.intervals();
        return nutsVersionIntervals.length != 0 && nutsVersionIntervals.length <= 1 && nutsVersionIntervals[0].isFixedValue();
    }

    public boolean isFilter() {
        for (char c : this.expression.toCharArray()) {
            switch (c) {
                case '(': 
                case ')': 
                case '*': 
                case ',': 
                case '[': 
                case ']': {
                    return true;
                }
            }
        }
        return false;
    }

    public NutsVersion inc() {
        return this.inc(-1);
    }

    public NutsVersion inc(int position) {
        return this.inc(position, 1L);
    }

    public NutsVersion inc(int position, long amount) {
        return new DefaultNutsVersion(DefaultNutsVersion.incVersion(this.getValue(), position, amount), this.session);
    }

    public NutsVersion inc(int position, BigInteger amount) {
        return new DefaultNutsVersion(DefaultNutsVersion.incVersion(this.getValue(), position, amount), this.session);
    }

    public int size() {
        VersionParts parts = this.getParts();
        return parts.size();
    }

    public int numberSize() {
        return this.getParts().getDigitCount();
    }

    public String get(int level) {
        VersionParts parts = this.getParts();
        int size = parts.size();
        if (level >= 0) {
            return parts.get((int)level).string;
        }
        int x = size + level;
        return parts.get((int)x).string;
    }

    public BigInteger getNumber(int level) {
        VersionParts parts = this.getParts();
        int size = parts.getDigitCount();
        if (level >= 0) {
            return new BigInteger(parts.getDigit((int)level).string);
        }
        int x = size + level;
        return new BigInteger(parts.getDigit((int)x).string);
    }

    public BigInteger getNumber(int level, BigInteger defaultValue) {
        VersionParts parts = this.getParts();
        int size = parts.getDigitCount();
        if (level >= 0) {
            if (level < size) {
                return new BigInteger(parts.getDigit((int)level).string);
            }
        } else {
            int x = size + level;
            if (x < size) {
                return new BigInteger(parts.getDigit((int)x).string);
            }
        }
        return defaultValue;
    }

    public int getInt(int index, int defaultValue) {
        return this.getNumber(index, BigInteger.valueOf(defaultValue)).intValue();
    }

    public long getLong(int index, long defaultValue) {
        return this.getNumber(index, BigInteger.valueOf(defaultValue)).longValue();
    }

    public NutsFormat formatter() {
        return NutsVersionFormat.of((NutsSession)this.session).setVersion((NutsVersion)this);
    }

    private String toExplicitSingleValueOrNullString() {
        if (!this.isBlank() && !this.isFilter()) {
            return this.expression;
        }
        return null;
    }

    private String toSingleValueOrNullString() {
        NutsVersionInterval[] nutsVersionIntervals = this.intervals();
        if (nutsVersionIntervals.length == 1 && nutsVersionIntervals[0].isFixedValue()) {
            return nutsVersionIntervals[0].getLowerBound();
        }
        return null;
    }

    private VersionParts getParts() {
        if (this.parts == null) {
            this.parts = DefaultNutsVersion.splitVersionParts2(this.getValue());
        }
        return this.parts;
    }

    public int hashCode() {
        return this.expression != null ? this.expression.hashCode() : 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultNutsVersion version = (DefaultNutsVersion)o;
        return this.expression != null ? this.expression.equals(version.expression) : version.expression == null;
    }

    public String toString() {
        return this.expression == null ? "" : this.expression;
    }

    private static class VersionParts {
        List<VersionPart> all;

        public VersionParts(List<VersionPart> all) {
            this.all = all;
        }

        public VersionPart get(int index) {
            return this.all.get(index);
        }

        public int size() {
            return this.all.size();
        }

        public int getDigitCount() {
            int c = 0;
            for (VersionPart s : this.all) {
                if (s.type != VersionPartType.NUMBER) continue;
                ++c;
            }
            return c;
        }

        public VersionPart getDigit(int index) {
            int c = 0;
            for (VersionPart s : this.all) {
                if (s.type != VersionPartType.NUMBER) continue;
                if (c == index) {
                    return s;
                }
                ++c;
            }
            return null;
        }

        public void insertDigit(long val, String sep) {
            if (this.all.size() == 0) {
                this.all.add(new VersionPart(String.valueOf(val), VersionPartType.NUMBER));
            } else if (this.all.get((int)0).type == VersionPartType.NUMBER) {
                if (sep == null) {
                    sep = ".";
                }
                if (!sep.equals(".") && !sep.equals("-")) {
                    throw new IllegalArgumentException("illegal separator");
                }
                this.all.add(0, new VersionPart(sep, VersionPartType.SEPARATOR));
                this.all.add(0, new VersionPart(String.valueOf(val), VersionPartType.NUMBER));
            } else {
                this.all.add(0, new VersionPart(String.valueOf(val), VersionPartType.NUMBER));
            }
        }

        public void addDigit(BigInteger val, String sep) {
            if (this.all.size() == 0) {
                this.all.add(new VersionPart(String.valueOf(val), VersionPartType.NUMBER));
            } else if (this.all.get((int)(this.all.size() - 1)).type == VersionPartType.NUMBER) {
                if (sep == null) {
                    sep = ".";
                }
                if (!sep.equals(".") && !sep.equals("-")) {
                    throw new IllegalArgumentException("illegal separator");
                }
                this.all.add(new VersionPart(sep, VersionPartType.SEPARATOR));
                this.all.add(new VersionPart(String.valueOf(val), VersionPartType.NUMBER));
            } else {
                this.all.add(new VersionPart(String.valueOf(val), VersionPartType.NUMBER));
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (VersionPart versionPart : this.all) {
                sb.append(versionPart.string);
            }
            return sb.toString();
        }

        public int compareTo(VersionParts v2) {
            VersionParts v1 = this;
            int i = 0;
            for (int j = 0; i < v1.size() || j < v2.size(); ++i, ++j) {
                VersionPart a;
                if (i < v1.size() && j < v2.size()) {
                    VersionPart b;
                    a = v1.get(i);
                    int r = a.compareTo(b = v2.get(i));
                    if (r == 0) continue;
                    return r;
                }
                if (i < v1.size()) {
                    a = v1.get(i);
                    if (a.type == VersionPartType.NUMBER || a.type == VersionPartType.SEPARATOR) {
                        return 1;
                    }
                    return -1;
                }
                VersionPart b = v2.get(i);
                if (b.type == VersionPartType.NUMBER || b.type == VersionPartType.SEPARATOR) {
                    return -1;
                }
                return 1;
            }
            return 0;
        }
    }

    private static class VersionPart {
        String string;
        VersionPartType type;

        public VersionPart(String string, VersionPartType type) {
            this.string = string;
            this.type = type;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.string, this.type});
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            VersionPart that = (VersionPart)o;
            return this.string.equalsIgnoreCase(that.string) && this.type == that.type;
        }

        public String toString() {
            String name = this.type.name().toLowerCase();
            return name + "(" + this.string + ")";
        }

        public int compareTo(VersionPart v2) {
            VersionPart v1 = this;
            if (v1.equals(v2)) {
                return 0;
            }
            if (v1.type == VersionPartType.SEPARATOR && v2.type == VersionPartType.SEPARATOR) {
                if (v1.string.equals("-")) {
                    return -1;
                }
                return 1;
            }
            if (v1.type == VersionPartType.SEPARATOR) {
                return -1;
            }
            if (v2.type == VersionPartType.SEPARATOR) {
                return 1;
            }
            if (v1.type == VersionPartType.NUMBER && v2.type == VersionPartType.NUMBER) {
                return CoreNumberUtils.convertToBigInteger(v1.string, null).compareTo(CoreNumberUtils.convertToBigInteger(v2.string, null));
            }
            if (v1.type == VersionPartType.NUMBER) {
                return 1;
            }
            if (v2.type == VersionPartType.NUMBER) {
                return -1;
            }
            Integer q1 = DefaultNutsVersion.getKnownQualifierIndex(v1.string);
            Integer q2 = DefaultNutsVersion.getKnownQualifierIndex(v2.string);
            if (q1 != null && q2 != null) {
                return q1.compareTo(q2);
            }
            if (q1 != null) {
                return -1;
            }
            if (q2 != null) {
                return 1;
            }
            return v1.string.compareToIgnoreCase(v2.string);
        }
    }

    static enum VersionPartType {
        NUMBER,
        QAL,
        SEPARATOR;

    }
}

