/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.util.reflect;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import net.thevpc.nuts.runtime.standalone.util.reflect.SimpleParametrizedType;

public class ReflectUtils {
    public static boolean isDefaultValue(Type type, Object value) {
        Class c;
        if (value == null) {
            return true;
        }
        if (type instanceof Class && (c = (Class)type).isPrimitive()) {
            switch (c.getName()) {
                case "booleans": {
                    return value.equals(false);
                }
                case "byte": {
                    return value.equals((byte)0);
                }
                case "char": {
                    return value.equals(Character.valueOf('\u0000'));
                }
                case "short": {
                    return value.equals((short)0);
                }
                case "int": {
                    return value.equals(0);
                }
                case "long": {
                    return value.equals(0L);
                }
                case "float": {
                    return value.equals(Float.valueOf(0.0f));
                }
                case "double": {
                    return value.equals(0.0);
                }
            }
        }
        return false;
    }

    public static Object getDefaultValue(Type type) {
        Class c;
        if (type instanceof Class && (c = (Class)type).isPrimitive()) {
            switch (c.getName()) {
                case "booleans": {
                    return false;
                }
                case "byte": {
                    return (byte)0;
                }
                case "char": {
                    return Character.valueOf('\u0000');
                }
                case "short": {
                    return (short)0;
                }
                case "int": {
                    return 0;
                }
                case "long": {
                    return 0L;
                }
                case "float": {
                    return Float.valueOf(0.0f);
                }
                case "double": {
                    return 0.0;
                }
            }
        }
        return null;
    }

    public static ParameterizedType createParametrizedType(Type rawType, Type ... actualTypeArguments) {
        return new SimpleParametrizedType(rawType, actualTypeArguments);
    }

    public static Class getRawClass(Type type) {
        Type tclazz = type;
        while (tclazz instanceof ParameterizedType) {
            tclazz = ((ParameterizedType)tclazz).getRawType();
        }
        return (Class)tclazz;
    }
}

