/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.util.reflect;

import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsEnum;
import net.thevpc.nuts.NutsParseEnumException;
import net.thevpc.nuts.NutsSession;

public enum ReflectPropertyAccessStrategy implements NutsEnum
{
    FIELD,
    METHOD,
    BOTH;

    private final String id = this.name().toLowerCase().replace('_', '-');

    public static ReflectPropertyAccessStrategy parseLenient(String value) {
        return ReflectPropertyAccessStrategy.parseLenient(value, null);
    }

    public static ReflectPropertyAccessStrategy parseLenient(String value, ReflectPropertyAccessStrategy emptyOrErrorValue) {
        return ReflectPropertyAccessStrategy.parseLenient(value, emptyOrErrorValue, emptyOrErrorValue);
    }

    public static ReflectPropertyAccessStrategy parseLenient(String value, ReflectPropertyAccessStrategy emptyValue, ReflectPropertyAccessStrategy errorValue) {
        if ((value = value == null ? "" : value.toUpperCase().trim().replace('-', '_')).isEmpty()) {
            return emptyValue;
        }
        try {
            return ReflectPropertyAccessStrategy.valueOf(value.toUpperCase());
        }
        catch (Exception notFound) {
            return errorValue;
        }
    }

    public static ReflectPropertyAccessStrategy parse(String value, NutsSession session) {
        return ReflectPropertyAccessStrategy.parse(value, null, session);
    }

    public static ReflectPropertyAccessStrategy parse(String value, ReflectPropertyAccessStrategy emptyValue, NutsSession session) {
        ReflectPropertyAccessStrategy v = ReflectPropertyAccessStrategy.parseLenient(value, emptyValue, null);
        if (v == null && !NutsBlankable.isBlank((String)value)) {
            throw new NutsParseEnumException(session, value, ReflectPropertyAccessStrategy.class);
        }
        return v;
    }

    public String id() {
        return this.id;
    }
}

