/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.util.reflect;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.thevpc.nuts.spi.NutsUseDefault;

public class NutsUseDefaultUtils {
    static Map<MethodId, MethodInfo> methods = new HashMap<MethodId, MethodInfo>();

    public static boolean isUseDefault(Class cls, String methodName, Class ... argTypes) {
        MethodId id = new MethodId(cls, methodName, argTypes);
        MethodInfo m = methods.computeIfAbsent(id, x -> new MethodInfo((MethodId)x));
        if (m.useDefault == null) {
            Method a = null;
            try {
                a = cls.getMethod(id.methodName, argTypes);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException(e);
            }
            m.useDefault = a.getAnnotation(NutsUseDefault.class) != null;
        }
        return m.useDefault;
    }

    private static class MethodId {
        private Class cls;
        private String methodName;
        private Class[] argType;

        public MethodId(Class cls, String methodName, Class[] argType) {
            this.cls = cls;
            this.methodName = methodName;
            this.argType = argType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MethodId that = (MethodId)o;
            return Objects.equals(this.cls, that.cls) && Objects.equals(this.methodName, that.methodName) && Arrays.equals(this.argType, that.argType);
        }

        public int hashCode() {
            int result = Objects.hash(this.cls, this.methodName);
            result = 31 * result + Arrays.hashCode(this.argType);
            return result;
        }
    }

    private static class MethodInfo {
        MethodId id;
        Boolean useDefault;

        public MethodInfo(MethodId id) {
            this.id = id;
        }

        public Boolean getUseDefault() {
            return this.useDefault;
        }

        public MethodInfo setUseDefault(Boolean useDefault) {
            this.useDefault = useDefault;
            return this;
        }
    }
}

