/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.util.reflect;

import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Objects;
import net.thevpc.nuts.runtime.standalone.util.reflect.ReflectProperty;
import net.thevpc.nuts.runtime.standalone.util.reflect.ReflectPropertyDefaultValueStrategy;
import net.thevpc.nuts.runtime.standalone.util.reflect.ReflectType;
import net.thevpc.nuts.runtime.standalone.util.reflect.ReflectUtils;

public abstract class AbstractReflectProperty
implements ReflectProperty {
    private String name;
    private Object cleanInstanceValue;
    private Type propertyType;
    private ReflectType type;
    private ReflectPropertyDefaultValueStrategy defaultValueStrategy;

    protected final void init(String name, ReflectType type, Object cleanInstance, Type propertyType, ReflectPropertyDefaultValueStrategy defaultValueStrategy) {
        this.name = name;
        this.cleanInstanceValue = cleanInstance == null ? ReflectUtils.getDefaultValue(propertyType) : this.read(cleanInstance);
        this.type = type;
        this.defaultValueStrategy = defaultValueStrategy;
        this.propertyType = propertyType;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ReflectType getType() {
        return this.type;
    }

    @Override
    public Type getPropertyType() {
        return this.propertyType;
    }

    @Override
    public ReflectPropertyDefaultValueStrategy getDefaultValueStrategy() {
        return this.defaultValueStrategy;
    }

    @Override
    public boolean isDefaultValue(Object value, ReflectPropertyDefaultValueStrategy strategy) {
        if (strategy == null) {
            strategy = this.getDefaultValueStrategy();
        }
        switch (strategy) {
            case NO_DEFAULT: {
                return false;
            }
            case PROPERTY_DEFAULT: {
                if (value == null) {
                    return true;
                }
                if (this.cleanInstanceValue != null && this.cleanInstanceValue.getClass().isArray()) {
                    if (Array.getLength(this.cleanInstanceValue) == 0) {
                        return value.getClass().isArray() && Array.getLength(value) == 0;
                    }
                    if (value.getClass().isArray()) {
                        Class<?> e = this.cleanInstanceValue.getClass().getComponentType();
                        Class<?> f = value.getClass().getComponentType();
                        if (e.isPrimitive()) {
                            if (f.isPrimitive() && e.equals(f)) {
                                switch (e.getName()) {
                                    case "boolean": {
                                        return Arrays.equals((boolean[])this.cleanInstanceValue, (boolean[])value);
                                    }
                                    case "byte": {
                                        return Arrays.equals((byte[])this.cleanInstanceValue, (byte[])value);
                                    }
                                    case "char": {
                                        return Arrays.equals((char[])this.cleanInstanceValue, (char[])value);
                                    }
                                    case "short": {
                                        return Arrays.equals((short[])this.cleanInstanceValue, (short[])value);
                                    }
                                    case "int": {
                                        return Arrays.equals((int[])this.cleanInstanceValue, (int[])value);
                                    }
                                    case "long": {
                                        return Arrays.equals((long[])this.cleanInstanceValue, (long[])value);
                                    }
                                    case "float": {
                                        return Arrays.equals((float[])this.cleanInstanceValue, (float[])value);
                                    }
                                    case "double": {
                                        return Arrays.equals((double[])this.cleanInstanceValue, (double[])value);
                                    }
                                }
                            }
                            return false;
                        }
                        return Arrays.deepEquals((Object[])this.cleanInstanceValue, (Object[])value);
                    }
                    return Objects.deepEquals(this.cleanInstanceValue, value);
                }
                return Objects.deepEquals(this.cleanInstanceValue, value);
            }
            case TYPE_DEFAULT: {
                return ReflectUtils.isDefaultValue(this.getPropertyType(), value);
            }
        }
        return Objects.equals(this.cleanInstanceValue, value);
    }

    @Override
    public boolean isDefaultValue(Object o) {
        return this.isDefaultValue(o, null);
    }
}

