/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.util.iter;

import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import net.thevpc.nuts.NutsDescribables;
import net.thevpc.nuts.NutsElement;
import net.thevpc.nuts.NutsElements;
import net.thevpc.nuts.NutsIterator;
import net.thevpc.nuts.runtime.standalone.util.iter.NutsIteratorBase;

public class SupplierIterator2<T>
extends NutsIteratorBase<T> {
    private final Supplier<Iterator<T>> from;
    private NutsIterator<T> iterator;
    private Function<NutsElements, NutsElement> name;

    public SupplierIterator2(Supplier<Iterator<T>> from, Function<NutsElements, NutsElement> name) {
        this.from = from;
        this.name = name;
    }

    public NutsElement describe(NutsElements elems) {
        return elems.ofObject().set("type", "Supplier").set("template", NutsDescribables.resolveOr(this.from, (NutsElements)elems, () -> {
            NutsElement t = this.name.apply(elems);
            return elems.ofObject().set("type", "compiled").addAll(t == null ? null : t.asSafeObject(true)).build();
        })).build();
    }

    public boolean hasNext() {
        if (this.iterator == null) {
            Iterator<T> it = this.from.get();
            NutsIterator<T> nutsIterator = this.iterator = it == null ? null : NutsIterator.of(it, this.name);
            if (this.iterator == null) {
                return false;
            }
        }
        return this.iterator.hasNext();
    }

    public T next() {
        return (T)this.iterator.next();
    }

    public void remove() {
        if (this.iterator != null) {
            this.iterator.remove();
        }
    }

    public String toString() {
        if (this.name == null) {
            return "supplier(" + this.from + ")";
        }
        return String.valueOf(this.name);
    }
}

