/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.util.iter;

import java.util.function.Supplier;
import net.thevpc.nuts.NutsDescribables;
import net.thevpc.nuts.NutsElement;
import net.thevpc.nuts.NutsElements;
import net.thevpc.nuts.NutsIterator;
import net.thevpc.nuts.NutsObjectElement;
import net.thevpc.nuts.runtime.standalone.util.iter.NutsIteratorBase;

public class SupplierIterator<T>
extends NutsIteratorBase<T> {
    private final Supplier<NutsIterator<T>> from;
    private NutsIterator<T> iterator;
    private NutsObjectElement name;

    public SupplierIterator(Supplier<NutsIterator<T>> from, NutsObjectElement name) {
        this.from = from;
        this.name = name;
    }

    public NutsElement describe(NutsElements elems) {
        return elems.ofObject().set("type", "Supplier").set("template", NutsDescribables.resolveOr(this.from, (NutsElements)elems, () -> elems.ofObject().set("type", "compiled").addAll(this.name).build())).build();
    }

    public boolean hasNext() {
        if (this.iterator == null) {
            this.iterator = this.from.get();
            if (this.iterator == null) {
                return false;
            }
        }
        return this.iterator.hasNext();
    }

    public T next() {
        return (T)this.iterator.next();
    }

    public void remove() {
        if (this.iterator != null) {
            this.iterator.remove();
        }
    }

    public String toString() {
        if (this.name == null) {
            return "supplier(" + this.from + ")";
        }
        return String.valueOf(this.name);
    }
}

