/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.util.iter;

import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import net.thevpc.nuts.NutsComparator;
import net.thevpc.nuts.NutsDescribables;
import net.thevpc.nuts.NutsElement;
import net.thevpc.nuts.NutsElements;
import net.thevpc.nuts.NutsIterator;
import net.thevpc.nuts.runtime.standalone.util.iter.IteratorUtils;
import net.thevpc.nuts.runtime.standalone.util.iter.NutsIteratorBase;

class SortIterator<T>
extends NutsIteratorBase<T> {
    private final boolean removeDuplicates;
    private final NutsIterator<T> it;
    private final NutsComparator<T> c;
    Iterator<T> base;

    public SortIterator(NutsIterator<T> it, NutsComparator<T> c, boolean removeDuplicates) {
        this.removeDuplicates = removeDuplicates;
        this.it = it;
        this.c = c;
        this.base = null;
    }

    public NutsElement describe(NutsElements elems) {
        return NutsDescribables.resolveOrDestruct(this.base, (NutsElements)elems).asSafeObject(true).builder().set("sort", (NutsElement)elems.ofObject().set("comparator", NutsDescribables.resolveOrDestruct(this.c, (NutsElements)elems)).set("distinct", this.removeDuplicates).build()).build();
    }

    public Iterator<T> getBase() {
        if (this.base == null) {
            if (this.removeDuplicates) {
                this.base = IteratorUtils.toTreeSet(this.it, this.c).iterator();
            } else {
                List<T> a = IteratorUtils.toList(this.it);
                a.sort((Comparator<T>)this.c);
                this.base = a.iterator();
            }
        }
        return this.base;
    }

    public boolean hasNext() {
        return this.getBase().hasNext();
    }

    public T next() {
        return this.getBase().next();
    }

    public String toString() {
        if (this.removeDuplicates) {
            return "SortDistinct(" + this.it + ")";
        }
        return "SortDuplicates(" + this.it + ")";
    }
}

