/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.util.iter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Queue;
import java.util.stream.Collectors;
import net.thevpc.nuts.NutsDescribables;
import net.thevpc.nuts.NutsElement;
import net.thevpc.nuts.NutsElements;
import net.thevpc.nuts.NutsIterator;
import net.thevpc.nuts.runtime.standalone.util.iter.IteratorUtils;
import net.thevpc.nuts.runtime.standalone.util.iter.NutsIteratorBase;

public class QueueIterator<T>
extends NutsIteratorBase<T> {
    private Queue<NutsIterator<? extends T>> children = new LinkedList<NutsIterator<? extends T>>();
    private int size;

    public NutsElement describe(NutsElements elems) {
        return elems.ofObject().set("type", "Queue").set("items", (NutsElement)elems.ofArray().addAll((Collection)new ArrayList<NutsIterator<T>>(this.children).stream().map(x -> NutsDescribables.resolveOrDestruct((Object)x, (NutsElements)elems)).collect(Collectors.toList())).build()).build();
    }

    public void addNonNull(NutsIterator<? extends T> child) {
        if (child != null) {
            this.add(child);
        }
    }

    public void addNonEmpty(NutsIterator<? extends T> child) {
        if ((child = IteratorUtils.nullifyIfEmpty(child)) != null) {
            this.add(child);
        }
    }

    public void add(NutsIterator<? extends T> child) {
        if (child == null) {
            throw new NullPointerException();
        }
        this.children.add(child);
        ++this.size;
    }

    public boolean hasNext() {
        while (!this.children.isEmpty()) {
            if (this.children.peek().hasNext()) {
                return true;
            }
            this.children.poll();
            --this.size;
        }
        return false;
    }

    public T next() {
        return (T)this.children.peek().next();
    }

    public int size() {
        return this.size;
    }

    public void remove() {
        this.children.peek().remove();
    }

    public NutsIterator<T>[] getChildren() {
        return this.children.toArray(new NutsIterator[0]);
    }

    public String toString() {
        return "QueueIterator(" + this.children + ')';
    }
}

