/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.util.iter;

import java.util.Iterator;
import net.thevpc.nuts.NutsDescribables;
import net.thevpc.nuts.NutsElement;
import net.thevpc.nuts.NutsElements;
import net.thevpc.nuts.runtime.standalone.util.iter.NutsIteratorBase;

public class PushBackIterator<T>
extends NutsIteratorBase<T> {
    private Iterator<T> base;
    private Boolean lastHasNext;
    private boolean lastValConsumed;
    private T lastVal;

    public PushBackIterator(Iterator<T> base) {
        this.base = base;
    }

    public NutsElement describe(NutsElements elems) {
        return NutsDescribables.resolveOrDestruct(this.base, (NutsElements)elems).asSafeObject(true).builder().set("pushBack", true).build();
    }

    public boolean isEmpty() {
        if (this.hasNext()) {
            this.pushBack();
            return false;
        }
        return true;
    }

    public boolean hasNext() {
        if (this.lastHasNext != null) {
            return this.lastHasNext;
        }
        if (this.base.hasNext()) {
            this.lastValConsumed = false;
            this.lastHasNext = true;
            this.lastVal = this.base.next();
        } else {
            this.lastHasNext = false;
            this.lastValConsumed = false;
            this.lastHasNext = false;
        }
        return this.lastHasNext;
    }

    public T next() {
        this.lastHasNext = null;
        this.lastValConsumed = true;
        return this.lastVal;
    }

    public void remove() {
        if (this.lastHasNext == null) {
            throw new UnsupportedOperationException("unsupported");
        }
        this.base.remove();
    }

    public void pushBack() {
        if (this.lastHasNext != null && this.lastValConsumed) {
            throw new UnsupportedOperationException("unsupported");
        }
        this.lastHasNext = true;
    }
}

