/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.util.iter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import net.thevpc.nuts.NutsComparator;
import net.thevpc.nuts.NutsIterator;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.runtime.standalone.util.iter.CoalesceIterator;
import net.thevpc.nuts.runtime.standalone.util.iter.CollectorIterator;
import net.thevpc.nuts.runtime.standalone.util.iter.ConvertedNonNullIterator;
import net.thevpc.nuts.runtime.standalone.util.iter.DistinctPredicate;
import net.thevpc.nuts.runtime.standalone.util.iter.DistinctWithConverterPredicate;
import net.thevpc.nuts.runtime.standalone.util.iter.ErrorHandlerIterator;
import net.thevpc.nuts.runtime.standalone.util.iter.FilteredIterator;
import net.thevpc.nuts.runtime.standalone.util.iter.IteratorBuilder;
import net.thevpc.nuts.runtime.standalone.util.iter.IteratorErrorHandlerType;
import net.thevpc.nuts.runtime.standalone.util.iter.PushBackIterator;
import net.thevpc.nuts.runtime.standalone.util.iter.QueueIterator;
import net.thevpc.nuts.runtime.standalone.util.iter.SortIterator;

public class IteratorUtils {
    public static <T> NutsIterator<T> safe(IteratorErrorHandlerType type, NutsIterator<T> t, NutsSession session) {
        return new ErrorHandlerIterator<T>(type, t, session);
    }

    public static <T> NutsIterator<T> safeIgnore(NutsIterator<T> t, NutsSession session) {
        return new ErrorHandlerIterator<T>(IteratorErrorHandlerType.IGNORE, t, session);
    }

    public static <T> NutsIterator<T> safePospone(NutsIterator<T> t, NutsSession session) {
        return new ErrorHandlerIterator<T>(IteratorErrorHandlerType.POSTPONE, t, session);
    }

    public static <T> boolean isNullOrEmpty(Iterator<T> t) {
        return t == null || t == IteratorBuilder.EMPTY_ITERATOR;
    }

    public static <T> NutsIterator<T> nonNull(NutsIterator<T> t) {
        if (t == null) {
            return IteratorBuilder.emptyIterator();
        }
        return t;
    }

    public static <T> NutsIterator<T> concat(List<NutsIterator<? extends T>> all) {
        if (all == null || all.isEmpty()) {
            return IteratorBuilder.emptyIterator();
        }
        QueueIterator<T> t = new QueueIterator<T>();
        for (NutsIterator<T> nutsIterator : all) {
            if (IteratorUtils.isNullOrEmpty(nutsIterator)) continue;
            if (nutsIterator instanceof QueueIterator) {
                QueueIterator tt = (QueueIterator)nutsIterator;
                for (NutsIterator it1 : tt.getChildren()) {
                    t.add(it1);
                }
                continue;
            }
            t.add(nutsIterator);
        }
        int tsize = t.size();
        if (tsize == 0) {
            return IteratorBuilder.emptyIterator();
        }
        if (tsize == 1) {
            return t.getChildren()[0];
        }
        return t;
    }

    public static <T> NutsIterator<T> coalesce2(List<NutsIterator<T>> all) {
        return IteratorUtils.coalesce(all);
    }

    public static <T> NutsIterator<T> coalesce(NutsIterator<? extends T> ... all) {
        return IteratorUtils.coalesce(Arrays.asList(all));
    }

    public static <T> NutsIterator<T> concat(NutsIterator<? extends T> ... all) {
        return IteratorUtils.concat(Arrays.asList(all));
    }

    public static <T> NutsIterator<T> concatLists(List<NutsIterator<? extends T>> ... all) {
        ArrayList<NutsIterator<T>> r = new ArrayList<NutsIterator<T>>();
        if (all != null) {
            for (List<NutsIterator<T>> list : all) {
                if (list == null) continue;
                for (NutsIterator<? extends T> nutsIterator : list) {
                    if (nutsIterator == null) continue;
                    r.add(nutsIterator);
                }
            }
        }
        return IteratorUtils.concat(r);
    }

    public static <T> NutsIterator<T> coalesce(List<NutsIterator<? extends T>> all) {
        if (all == null || all.isEmpty()) {
            return IteratorBuilder.emptyIterator();
        }
        CoalesceIterator<T> t = new CoalesceIterator<T>();
        for (NutsIterator<T> nutsIterator : all) {
            if (IteratorUtils.isNullOrEmpty(nutsIterator)) continue;
            t.add(nutsIterator);
        }
        int tsize = t.size();
        if (tsize == 0) {
            return IteratorBuilder.emptyIterator();
        }
        if (tsize == 1) {
            return t.getChildren()[0];
        }
        return t;
    }

    public static <F, T> NutsIterator<T> convertNonNull(NutsIterator<F> from, Function<F, T> converter, String name) {
        if (IteratorUtils.isNullOrEmpty(from)) {
            return IteratorBuilder.emptyIterator();
        }
        return new ConvertedNonNullIterator<F, T>(from, converter, name);
    }

    public static <T> List<T> toList(Iterator<T> it) {
        if (IteratorUtils.isNullOrEmpty(it)) {
            return Collections.emptyList();
        }
        ArrayList<T> a = new ArrayList<T>();
        while (it.hasNext()) {
            a.add(it.next());
        }
        return a;
    }

    public static <T> Set<T> toSet(NutsIterator<T> it) {
        if (IteratorUtils.isNullOrEmpty(it)) {
            return Collections.emptySet();
        }
        LinkedHashSet<Object> a = new LinkedHashSet<Object>();
        while (it.hasNext()) {
            a.add(it.next());
        }
        return a;
    }

    public static <T> Set<T> toTreeSet(NutsIterator<T> it, NutsComparator<T> c) {
        if (IteratorUtils.isNullOrEmpty(it)) {
            return Collections.emptySet();
        }
        TreeSet<T> a = new TreeSet<T>(c);
        while (it.hasNext()) {
            a.add(it.next());
        }
        return a;
    }

    public static <T> NutsIterator<T> sort(NutsIterator<T> it, NutsComparator<T> c, boolean removeDuplicates) {
        if (IteratorUtils.isNullOrEmpty(it)) {
            return IteratorBuilder.emptyIterator();
        }
        return new SortIterator<T>(it, c, removeDuplicates);
    }

    public static <T> NutsIterator<T> distinct(NutsIterator<T> it) {
        if (IteratorUtils.isNullOrEmpty(it)) {
            return IteratorBuilder.emptyIterator();
        }
        DistinctPredicate filter = new DistinctPredicate();
        return new FilteredIterator<T>(it, filter);
    }

    public static <F, T> NutsIterator<F> distinct(NutsIterator<F> it, Function<F, T> converter) {
        if (IteratorUtils.isNullOrEmpty(it)) {
            return IteratorBuilder.emptyIterator();
        }
        if (converter == null) {
            DistinctPredicate filter = new DistinctPredicate();
            return new FilteredIterator<F>(it, filter);
        }
        DistinctWithConverterPredicate<F, T> filter = new DistinctWithConverterPredicate<F, T>(converter);
        return new FilteredIterator<F>(it, filter);
    }

    public static <T> CollectorIterator<T> collector(Iterator<T> it) {
        if (it == null) {
            return new CollectorIterator(null, IteratorBuilder.emptyIterator());
        }
        return new CollectorIterator<T>(null, it);
    }

    public static <T> NutsIterator<T> nullifyIfEmpty(NutsIterator<T> other) {
        if (other == null) {
            return null;
        }
        if (other instanceof PushBackIterator) {
            PushBackIterator b = (PushBackIterator)other;
            if (!b.isEmpty()) {
                return b;
            }
            return null;
        }
        PushBackIterator<T> b = new PushBackIterator<T>(other);
        if (!b.isEmpty()) {
            return b;
        }
        return null;
    }
}

