/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.util.iter;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.thevpc.nuts.NutsComparator;
import net.thevpc.nuts.NutsElement;
import net.thevpc.nuts.NutsElements;
import net.thevpc.nuts.NutsFunction;
import net.thevpc.nuts.NutsIterator;
import net.thevpc.nuts.NutsObjectElement;
import net.thevpc.nuts.NutsPredicate;
import net.thevpc.nuts.NutsPredicates;
import net.thevpc.nuts.NutsRunnable;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.runtime.standalone.util.collections.CoreCollectionUtils;
import net.thevpc.nuts.runtime.standalone.util.iter.ConvertedIterator;
import net.thevpc.nuts.runtime.standalone.util.iter.EmptyIterator;
import net.thevpc.nuts.runtime.standalone.util.iter.ErrorHandlerIterator;
import net.thevpc.nuts.runtime.standalone.util.iter.FilteredIterator;
import net.thevpc.nuts.runtime.standalone.util.iter.FlatMapIterator;
import net.thevpc.nuts.runtime.standalone.util.iter.IteratorErrorHandlerType;
import net.thevpc.nuts.runtime.standalone.util.iter.IteratorUtils;
import net.thevpc.nuts.runtime.standalone.util.iter.NutsIteratorAdapter;
import net.thevpc.nuts.runtime.standalone.util.iter.OnFinishIterator;
import net.thevpc.nuts.runtime.standalone.util.iter.OnStartIterator;
import net.thevpc.nuts.runtime.standalone.util.iter.SupplierIterator2;

public class IteratorBuilder<T> {
    public static final NutsPredicate NON_NULL = NutsPredicates.isNull().negate();
    public static final NutsPredicate NON_BLANK = NutsPredicates.blank().negate();
    static final EmptyIterator EMPTY_ITERATOR = new EmptyIterator();
    private final NutsIterator<T> it;
    private final NutsSession session;

    private IteratorBuilder(NutsIterator<T> it, NutsSession session) {
        if (it == null) {
            it = IteratorBuilder.emptyIterator();
        }
        this.it = it;
        this.session = session;
    }

    public static <T> IteratorBuilder<T> ofCoalesce(List<NutsIterator<? extends T>> t, NutsSession session) {
        return new IteratorBuilder<T>(IteratorUtils.coalesce(t), session);
    }

    public static <T> IteratorBuilder<T> ofConcat(List<NutsIterator<? extends T>> t, NutsSession session) {
        return new IteratorBuilder<T>(IteratorUtils.concat(t), session);
    }

    public static <T> IteratorBuilder<T> of(NutsIterator<T> t, NutsSession session) {
        return new IteratorBuilder<T>(t, session);
    }

    public static <T> IteratorBuilder<T> ofRunnable(NutsRunnable t, NutsSession session) {
        return IteratorBuilder.of(IteratorBuilder.emptyIterator(), session).onStart(t);
    }

    public static <T> IteratorBuilder<T> ofRunnable(Runnable t, NutsElement n, NutsSession session) {
        return IteratorBuilder.ofRunnable(NutsRunnable.of((Runnable)t, (NutsElement)n), session);
    }

    public static <T> IteratorBuilder<T> ofRunnable(Runnable t, String n, NutsSession session) {
        return IteratorBuilder.ofRunnable(NutsRunnable.of((Runnable)t, (String)n), session);
    }

    public static <T> IteratorBuilder<T> ofSupplier(Supplier<Iterator<T>> from, Function<NutsElements, NutsElement> name, NutsSession session) {
        return IteratorBuilder.of(new SupplierIterator2<T>(from, name), session);
    }

    public static <T> IteratorBuilder<T> ofArrayValues(T[] t, NutsElement n, NutsSession session) {
        return IteratorBuilder.ofArrayValues(t, (NutsElements e) -> n, session);
    }

    public static <T> IteratorBuilder<T> ofArrayValues(T[] t, String n, NutsSession session) {
        return IteratorBuilder.ofArrayValues(t, (NutsElements e) -> e.ofString(n), session);
    }

    public static <T> IteratorBuilder<T> ofArrayValues(T[] t, Function<NutsElements, NutsElement> n, NutsSession session) {
        return IteratorBuilder.of(t == null ? IteratorBuilder.emptyIterator() : new NutsIteratorAdapter<T>(Arrays.asList(t).iterator(), n), session);
    }

    public static <T> NutsIterator<T> emptyIterator() {
        return EMPTY_ITERATOR;
    }

    public static <T> IteratorBuilder<T> emptyBuilder(NutsSession session) {
        return IteratorBuilder.of(EMPTY_ITERATOR, session);
    }

    public static <T> IteratorBuilder<T> ofFlatMap(NutsIterator<? extends Collection<T>> from, NutsSession session) {
        if (from == null) {
            return IteratorBuilder.emptyBuilder(session);
        }
        return IteratorBuilder.of(new FlatMapIterator((Iterator<Collection>)from, Collection::iterator), session);
    }

    public IteratorBuilder<T> filter(Predicate<? super T> t, Function<NutsElements, NutsElement> e) {
        if (t == null) {
            return this;
        }
        return IteratorBuilder.of(new FilteredIterator<T>(this.it, NutsPredicate.of(t, e)), this.session);
    }

    public IteratorBuilder<T> filter(NutsPredicate<? super T> t) {
        if (t == null) {
            return this;
        }
        return new IteratorBuilder<T>(new FilteredIterator<T>(this.it, t), this.session);
    }

    public IteratorBuilder<T> concat(IteratorBuilder<T> t) {
        return this.concat(t.it);
    }

    public IteratorBuilder<T> concat(NutsIterator<T> t) {
        if (t == null) {
            return this;
        }
        return new IteratorBuilder(IteratorUtils.concat(Arrays.asList(this.it, t)), this.session);
    }

    public <V> IteratorBuilder<V> map(NutsFunction<? super T, ? extends V> t) {
        return new IteratorBuilder<T>(new ConvertedIterator<T, V>(this.it, t), this.session);
    }

    public <V> IteratorBuilder<V> flatMap(NutsFunction<? super T, ? extends Iterator<? extends V>> fun) {
        return IteratorBuilder.of(new FlatMapIterator(this.it, fun), this.session);
    }

    public <V> IteratorBuilder<V> mapMulti(NutsFunction<T, List<V>> mapper) {
        return new IteratorBuilder<T>(new FlatMapIterator((Iterator<Object>)this.it, t -> ((List)mapper.apply(t)).iterator()), this.session);
    }

    public <V> IteratorBuilder<T> sort(NutsComparator<T> t, boolean removeDuplicates) {
        return new IteratorBuilder<T>(IteratorUtils.sort(this.it, t, removeDuplicates), this.session);
    }

    public <V> IteratorBuilder<T> distinct() {
        return this.distinct(null);
    }

    public <V> IteratorBuilder<T> distinct(NutsFunction<T, V> t) {
        if (t == null) {
            return new IteratorBuilder<T>(IteratorUtils.distinct(this.it), this.session);
        }
        return new IteratorBuilder<T>(IteratorUtils.distinct(this.it, t), this.session);
    }

    public <V> IteratorBuilder<T> named(String n) {
        if (n != null) {
            return new IteratorBuilder<T>(new NutsIteratorAdapter<T>(this.it, e -> e.ofString(n)), this.session);
        }
        return this;
    }

    public <V> IteratorBuilder<T> named(NutsObjectElement nfo) {
        if (nfo != null) {
            return new IteratorBuilder<T>(new NutsIteratorAdapter<T>(this.it, e -> nfo), this.session);
        }
        return this;
    }

    public IteratorBuilder<T> safe(IteratorErrorHandlerType type) {
        return new IteratorBuilder<T>(new ErrorHandlerIterator<T>(type, this.it, this.session), this.session);
    }

    public IteratorBuilder<T> safeIgnore() {
        return this.safe(IteratorErrorHandlerType.IGNORE);
    }

    public IteratorBuilder<T> safePostpone() {
        return this.safe(IteratorErrorHandlerType.POSTPONE);
    }

    public IteratorBuilder<T> notNull() {
        return this.filter(NON_NULL);
    }

    public IteratorBuilder<String> notBlank() {
        return this.filter(NON_BLANK);
    }

    public NutsIterator<T> iterator() {
        return this.it;
    }

    public List<T> list() {
        return CoreCollectionUtils.toList(this.it);
    }

    public NutsIterator<T> build() {
        return this.it;
    }

    public List<T> toList() {
        return IteratorUtils.toList(this.it);
    }

    public IteratorBuilder<T> onFinish(NutsRunnable r) {
        if (r == null) {
            return this;
        }
        return IteratorBuilder.of(new OnFinishIterator<T>(this.it, (Runnable)r), this.session);
    }

    public IteratorBuilder<T> onStart(NutsRunnable r) {
        if (r == null) {
            return this;
        }
        return IteratorBuilder.of(new OnStartIterator<T>(this.it, (Runnable)r), this.session);
    }
}

