/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.util.iter;

import java.util.Iterator;
import java.util.logging.Level;
import net.thevpc.nuts.NutsDescribables;
import net.thevpc.nuts.NutsElement;
import net.thevpc.nuts.NutsElements;
import net.thevpc.nuts.NutsIndexerNotAccessibleException;
import net.thevpc.nuts.NutsLogVerb;
import net.thevpc.nuts.NutsLoggerOp;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.runtime.standalone.util.iter.NutsIteratorBase;

public class IndexFirstIterator<T>
extends NutsIteratorBase<T> {
    private Iterator<T> index;
    private Iterator<T> other;
    private long readFromIndex;
    private T nextItem;
    private boolean hasNextItem;
    private NutsSession session;

    public IndexFirstIterator(Iterator<T> index, Iterator<T> other, NutsSession session) {
        this.index = index;
        this.other = other;
        this.session = session;
    }

    public NutsElement describe(NutsElements elems) {
        return elems.ofObject().set("type", "IndexFirst").set("index", NutsDescribables.resolveOrDestruct(this.index, (NutsElements)elems)).set("nonIndex", NutsDescribables.resolveOrDestruct(this.other, (NutsElements)elems)).build();
    }

    public boolean hasNext() {
        if (this.index != null) {
            if (this.readFromIndex == 0L) {
                try {
                    boolean v = this.index.hasNext();
                    if (v) {
                        this.hasNextItem = true;
                        this.nextItem = this.index.next();
                        ++this.readFromIndex;
                    }
                    return v;
                }
                catch (NutsIndexerNotAccessibleException ex) {
                    this.index = null;
                }
            } else {
                try {
                    if (this.index.hasNext()) {
                        return true;
                    }
                    this.index = null;
                }
                catch (NutsIndexerNotAccessibleException ex) {
                    NutsLoggerOp.of(IndexFirstIterator.class, (NutsSession)this.session).verb(NutsLogVerb.WARNING).level(Level.FINEST).log(NutsMessage.cstyle((String)"error evaluating Iterator 'hasNext()' : %s", (Object[])new Object[]{ex}));
                    this.other = null;
                    return false;
                }
            }
        }
        if (this.other != null) {
            return this.other.hasNext();
        }
        return false;
    }

    public T next() {
        if (this.hasNextItem) {
            this.hasNextItem = false;
            T t = this.nextItem;
            this.nextItem = null;
            return t;
        }
        if (this.index != null) {
            return this.index.next();
        }
        return this.other.next();
    }

    public void remove() {
        if (this.index != null) {
            this.index.remove();
        } else if (this.other != null) {
            this.other.remove();
        }
    }

    public String toString() {
        return "IndexFirstIterator(" + this.other + ")";
    }
}

