/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.util.iter;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import net.thevpc.nuts.NutsDescribables;
import net.thevpc.nuts.NutsElement;
import net.thevpc.nuts.NutsElements;
import net.thevpc.nuts.runtime.standalone.util.iter.NutsIteratorBase;

public class FlatMapIterator<TT, RR>
extends NutsIteratorBase<RR> {
    private final Iterator<TT> from;
    private final Function<? super TT, ? extends Iterator<? extends RR>> converter;
    Iterator<? extends RR> current;

    public FlatMapIterator(Iterator<TT> from, Function<? super TT, ? extends Iterator<? extends RR>> converter) {
        this.from = from;
        this.converter = converter;
        this.current = null;
    }

    public NutsElement describe(NutsElements elems) {
        return elems.ofObject().set("type", "FlatMap").set("base", NutsDescribables.resolveOrDestruct(this.from, (NutsElements)elems)).set("mapper", NutsDescribables.resolveOrDestruct(this.converter, (NutsElements)elems)).build();
    }

    public boolean hasNext() {
        while (true) {
            if (this.current == null) {
                if (this.from.hasNext()) {
                    TT p = this.from.next();
                    if (p == null) {
                        this.current = Collections.emptyIterator();
                    } else {
                        this.current = this.converter.apply(p);
                        if (this.current == null) {
                            this.current = Collections.emptyIterator();
                        }
                    }
                } else {
                    return false;
                }
            }
            if (this.current.hasNext()) {
                return true;
            }
            this.current = null;
        }
    }

    public RR next() {
        return this.current.next();
    }

    public String toString() {
        return "FlattenIterator(" + this.from + ")";
    }
}

