/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.util.iter;

import java.util.Iterator;
import java.util.function.Predicate;
import net.thevpc.nuts.NutsDescribables;
import net.thevpc.nuts.NutsElement;
import net.thevpc.nuts.NutsElements;
import net.thevpc.nuts.runtime.standalone.util.iter.IteratorBuilder;
import net.thevpc.nuts.runtime.standalone.util.iter.NutsIteratorBase;

public class FilteredIterator<T>
extends NutsIteratorBase<T> {
    private final Iterator<T> base;
    private final Predicate<? super T> filter;
    private T last;

    public FilteredIterator(Iterator<T> base, Predicate<? super T> filter) {
        this.base = base == null ? IteratorBuilder.emptyIterator() : base;
        NutsDescribables.cast(filter);
        this.filter = filter;
    }

    public NutsElement describe(NutsElements elems) {
        return elems.ofObject().set("type", "Filter").set("base", NutsDescribables.resolveOrDestruct(this.base, (NutsElements)elems)).set("accept", NutsDescribables.resolveOrToString(this.filter, (NutsElements)elems)).build();
    }

    public boolean hasNext() {
        while (this.base.hasNext()) {
            this.last = this.base.next();
            if (!this.filter.test(this.last)) continue;
            return true;
        }
        return false;
    }

    public T next() {
        return this.last;
    }

    public void remove() {
        this.base.remove();
    }

    public String toString() {
        return this.filter.toString() + "(" + this.base + ')';
    }
}

