/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.util.iter;

import java.util.Iterator;
import java.util.logging.Level;
import net.thevpc.nuts.NutsDescribables;
import net.thevpc.nuts.NutsElement;
import net.thevpc.nuts.NutsElements;
import net.thevpc.nuts.NutsLogVerb;
import net.thevpc.nuts.NutsLoggerOp;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.runtime.standalone.util.iter.IndexFirstIterator;
import net.thevpc.nuts.runtime.standalone.util.iter.IteratorErrorHandlerType;
import net.thevpc.nuts.runtime.standalone.util.iter.NutsIteratorBase;

public class ErrorHandlerIterator<T>
extends NutsIteratorBase<T> {
    private IteratorErrorHandlerType type;
    private Iterator<T> base;
    private RuntimeException ex;
    private NutsSession session;

    public ErrorHandlerIterator(IteratorErrorHandlerType type, Iterator<T> base, NutsSession session) {
        this.base = base;
        this.type = type;
        this.session = session;
    }

    public NutsElement describe(NutsElements elems) {
        return NutsDescribables.resolveOrDestruct(this.base, (NutsElements)elems).asSafeObject(true).builder().set("onError", this.type.toString().toLowerCase()).build();
    }

    public boolean hasNext() {
        try {
            boolean v = this.base.hasNext();
            this.ex = null;
            return v;
        }
        catch (RuntimeException ex) {
            NutsLoggerOp.of(IndexFirstIterator.class, (NutsSession)this.session).verb(NutsLogVerb.WARNING).level(Level.FINEST).log(NutsMessage.cstyle((String)"error evaluating Iterator 'hasNext()' : %s", (Object[])new Object[]{ex}));
            switch (this.type) {
                case IGNORE: {
                    return false;
                }
                case POSTPONE: {
                    this.ex = ex;
                    return true;
                }
                case THROW: {
                    throw ex;
                }
            }
            throw new UnsupportedOperationException();
        }
    }

    public T next() {
        if (this.ex != null) {
            throw this.ex;
        }
        return this.base.next();
    }

    public void remove() {
        if (this.ex != null) {
            throw this.ex;
        }
        this.base.remove();
    }

    public String toString() {
        switch (this.type) {
            case THROW: {
                return "ThrowOnError(" + this.base + ")";
            }
            case POSTPONE: {
                return "PostponeError(" + this.base + ")";
            }
            case IGNORE: {
                return "IgnoreError(" + this.base + ")";
            }
        }
        return "ErrorHandlerIterator(type=" + (Object)((Object)this.type) + ", base=" + this.base + ')';
    }
}

