/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.util.iter;

import java.util.Iterator;
import java.util.function.Function;
import net.thevpc.nuts.NutsDescribables;
import net.thevpc.nuts.NutsElement;
import net.thevpc.nuts.NutsElements;
import net.thevpc.nuts.runtime.standalone.util.iter.NutsIteratorBase;

public class ConvertedNonNullIterator<F, T>
extends NutsIteratorBase<T> {
    private final Iterator<F> base;
    private final Function<F, T> converter;
    private final String convertName;
    private T lastVal;

    public ConvertedNonNullIterator(Iterator<F> base, Function<F, T> converter, String convertName) {
        this.base = base;
        this.converter = converter;
        if (convertName == null) {
            convertName = this.converter.toString();
        }
        this.convertName = convertName;
    }

    public NutsElement describe(NutsElements elems) {
        return elems.ofObject().set("type", "Map").set("accept", "isNotNull").set("mapper", (NutsElement)NutsDescribables.resolveOrDestruct(this.converter, (NutsElements)elems).asSafeObject(true).builder().set("name", this.convertName).build()).build();
    }

    public boolean hasNext() {
        while (this.base.hasNext()) {
            F i = this.base.next();
            if (i == null) continue;
            this.lastVal = this.converter.apply(i);
            if (this.lastVal == null) continue;
            break;
        }
        return this.lastVal != null;
    }

    public T next() {
        return this.lastVal;
    }

    public void remove() {
        throw new IllegalArgumentException("unsupported remove");
    }

    public String toString() {
        return "ConvertedNonNullIterator(" + this.base + "," + this.convertName + ")";
    }
}

