/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.util.iter;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.thevpc.nuts.NutsDescribables;
import net.thevpc.nuts.NutsElement;
import net.thevpc.nuts.NutsElements;
import net.thevpc.nuts.runtime.standalone.util.iter.NutsIteratorBase;

public class CollectorIterator<T>
extends NutsIteratorBase<T> {
    private String name;
    private Iterator<T> base;
    private List<T> collected = new ArrayList<T>();

    public CollectorIterator(String name, Iterator<T> base) {
        this.name = name;
        this.base = base;
    }

    public NutsElement describe(NutsElements elems) {
        return elems.ofObject().set("type", "Collector").set("name", this.name).set("base", NutsDescribables.resolveOrDestruct(this.base, (NutsElements)elems)).build();
    }

    public boolean hasNext() {
        return this.base.hasNext();
    }

    public T next() {
        T x = this.base.next();
        this.collected.add(x);
        return x;
    }

    public List<T> getCollected() {
        return this.collected;
    }

    public String toString() {
        if (this.name == null) {
            return "collector(" + this.base + ")";
        }
        return String.valueOf(this.name);
    }
}

