/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.util.filters;

import net.thevpc.nuts.NutsFilter;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsTypedFilters;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.standalone.util.filters.AbstractFilterParser2;

public abstract class NutsTypedFiltersParser<T extends NutsFilter>
extends AbstractFilterParser2<T> {
    protected NutsWorkspace ws;
    protected NutsSession session;

    public NutsTypedFiltersParser(String str, NutsSession session) {
        super(str == null ? "" : str);
        this.session = session;
        this.ws = session.getWorkspace();
        this.addBoolOps();
    }

    public NutsSession getSession() {
        return this.session;
    }

    @Override
    protected T nextDefault() {
        return (T)this.getTManager().always();
    }

    protected abstract NutsTypedFilters<T> getTManager();

    @Override
    protected T buildPreOp(String op, T a) {
        if (a == null) {
            return (T)this.getTManager().never();
        }
        return (T)a.neg();
    }

    @Override
    protected T buildBinOp(String op, T a, T r) {
        if (r == null) {
            throw new IllegalArgumentException("expected second operand");
        }
        switch (op) {
            case "&": 
            case "&&": {
                return (T)a.and(r);
            }
            case "|": 
            case "||": {
                return (T)a.or(r);
            }
        }
        throw new IllegalArgumentException("unexpected bin op " + op);
    }

    @Override
    protected T wordToPredicate(String word) {
        switch (word.toLowerCase()) {
            case "any": 
            case "always": {
                return (T)this.getTManager().always();
            }
            case "none": 
            case "never": {
                return (T)this.getTManager().never();
            }
        }
        throw new IllegalArgumentException("unsupported predicate name " + word);
    }
}

