/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.util.filters;

import java.util.ArrayList;
import java.util.List;
import net.thevpc.nuts.NutsFilter;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsTypedFilters;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.standalone.util.filters.DefaultNutsFilterModel;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceExt;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceUtils;

public abstract class InternalNutsTypedFilters<T extends NutsFilter>
implements NutsTypedFilters<T> {
    protected final DefaultNutsFilterModel model;
    protected final NutsWorkspace ws;
    private Class<T> type;
    private NutsSession session;

    public InternalNutsTypedFilters(NutsSession session, Class<T> type) {
        this.session = session;
        this.model = NutsWorkspaceExt.of((NutsWorkspace)session.getWorkspace()).getModel().filtersModel;
        this.ws = this.model.getWorkspace();
        this.type = type;
    }

    public NutsSession getSession() {
        return this.session;
    }

    protected void checkSession() {
        NutsWorkspaceUtils.checkSession(this.ws, this.session);
    }

    public T nonnull(NutsFilter filter) {
        if (filter == null) {
            return (T)this.always();
        }
        return (T)filter.to(this.type);
    }

    protected List<T> convertList(NutsFilter ... others) {
        this.checkSession();
        ArrayList<NutsFilter> all = new ArrayList<NutsFilter>();
        for (NutsFilter other : others) {
            NutsFilter a = this.from(other);
            if (a == null) continue;
            all.add(a);
        }
        return all;
    }
}

