/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.util.filters;

import net.thevpc.nuts.NutsFilter;
import net.thevpc.nuts.NutsFilters;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.standalone.util.filters.DefaultNutsFilterModel;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceExt;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceUtils;
import net.thevpc.nuts.spi.NutsSupportLevelContext;

public class DefaultNutsFilters
implements NutsFilters {
    public DefaultNutsFilterModel model;
    public NutsSession session;

    public DefaultNutsFilters(NutsSession session) {
        this.model = NutsWorkspaceExt.of((NutsWorkspace)session.getWorkspace()).getModel().filtersModel;
        this.session = session;
    }

    public DefaultNutsFilterModel getModel() {
        return this.model;
    }

    public <T extends NutsFilter> T nonnull(Class<T> type, NutsFilter filter) {
        this.checkSession();
        return this.model.nonnull(type, filter, this.session);
    }

    private void checkSession() {
        NutsWorkspaceUtils.checkSession(this.model.getWorkspace(), this.session);
    }

    public <T extends NutsFilter> T always(Class<T> type) {
        this.checkSession();
        return this.model.always(type, this.session);
    }

    public <T extends NutsFilter> T never(Class<T> type) {
        this.checkSession();
        return this.model.never(type, this.session);
    }

    public <T extends NutsFilter> T all(Class<T> type, NutsFilter ... others) {
        this.checkSession();
        return this.model.all(type, others, this.session);
    }

    public <T extends NutsFilter> T all(NutsFilter ... others) {
        this.checkSession();
        return this.model.all(others, this.session);
    }

    public <T extends NutsFilter> T any(Class<T> type, NutsFilter ... others) {
        this.checkSession();
        return this.model.any(type, others, this.session);
    }

    public <T extends NutsFilter> T not(NutsFilter other) {
        this.checkSession();
        return this.model.not(other, this.session);
    }

    public <T extends NutsFilter> T not(Class<T> type, NutsFilter other) {
        this.checkSession();
        return this.model.not(type, other, this.session);
    }

    public <T extends NutsFilter> T any(NutsFilter ... others) {
        this.checkSession();
        return this.model.any(others, this.session);
    }

    public <T extends NutsFilter> T none(Class<T> type, NutsFilter ... others) {
        this.checkSession();
        return this.model.none(type, others, this.session);
    }

    public <T extends NutsFilter> T none(NutsFilter ... others) {
        this.checkSession();
        return this.model.none(others, this.session);
    }

    public <T extends NutsFilter> T to(Class<T> toFilterInterface, NutsFilter filter) {
        this.checkSession();
        return this.model.to(toFilterInterface, filter, this.session);
    }

    public <T extends NutsFilter> T as(Class<T> toFilterInterface, NutsFilter filter) {
        this.checkSession();
        return this.model.as(toFilterInterface, filter, this.session);
    }

    public Class<? extends NutsFilter> detectType(NutsFilter nutsFilter) {
        this.checkSession();
        return this.model.detectType(nutsFilter, this.session);
    }

    public int getSupportLevel(NutsSupportLevelContext context) {
        return 10;
    }
}

