/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.util.filters;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.thevpc.nuts.NutsArchFamily;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsDependency;
import net.thevpc.nuts.NutsDependencyFilter;
import net.thevpc.nuts.NutsDescriptor;
import net.thevpc.nuts.NutsDescriptorFilter;
import net.thevpc.nuts.NutsDescriptorFilters;
import net.thevpc.nuts.NutsDesktopEnvironmentFamily;
import net.thevpc.nuts.NutsEnvCondition;
import net.thevpc.nuts.NutsExtensionInformation;
import net.thevpc.nuts.NutsFilter;
import net.thevpc.nuts.NutsFilterOp;
import net.thevpc.nuts.NutsFilters;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIdFilter;
import net.thevpc.nuts.NutsIdFilters;
import net.thevpc.nuts.NutsIdLocation;
import net.thevpc.nuts.NutsIdParser;
import net.thevpc.nuts.NutsOsFamily;
import net.thevpc.nuts.NutsPlatformFamily;
import net.thevpc.nuts.NutsPlatformLocation;
import net.thevpc.nuts.NutsPredicate;
import net.thevpc.nuts.NutsPredicates;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.NutsWorkspaceEnvManager;
import net.thevpc.nuts.runtime.standalone.descriptor.DefaultNutsEnvCondition;
import net.thevpc.nuts.runtime.standalone.util.Simplifiable;

public class CoreFilterUtils {
    private static int andInts(Boolean a, Boolean b) {
        if (a == null && b == null) {
            return 0;
        }
        if (a == null) {
            return b != false ? 1 : -1;
        }
        if (b == null) {
            return a != false ? 1 : -1;
        }
        if (a.equals(b)) {
            return a != false ? 1 : -1;
        }
        return 2;
    }

    private static int orInts(Boolean a, Boolean b) {
        if (a == null && b == null) {
            return 0;
        }
        if (a == null) {
            return b != false ? 1 : -1;
        }
        if (b == null) {
            return a != false ? 1 : -1;
        }
        if (a.equals(b)) {
            return a != false ? 1 : -1;
        }
        return 0;
    }

    public static <T extends NutsFilter> T[] getTopLevelFilters(NutsFilter idFilter, Class<T> clazz, NutsSession ws) {
        return (NutsFilter[])Arrays.stream(CoreFilterUtils.getTopLevelFilters(idFilter)).map(x -> NutsFilters.of((NutsSession)ws).as(clazz, x)).toArray(value -> (NutsFilter[])Array.newInstance(clazz, value));
    }

    public static NutsFilter[] getTopLevelFilters(NutsFilter idFilter) {
        if (idFilter == null) {
            return new NutsFilter[0];
        }
        if (idFilter.getFilterOp() == NutsFilterOp.AND) {
            return idFilter.getSubFilters();
        }
        return new NutsFilter[]{idFilter};
    }

    public static NutsIdFilter idFilterOf(Map<String, String> map, NutsIdFilter idFilter, NutsDescriptorFilter descriptorFilter, NutsSession ws) {
        return ((NutsIdFilter)NutsIdFilters.of((NutsSession)ws).nonnull((NutsFilter)idFilter)).and((NutsIdFilter)CoreFilterUtils.createNutsDescriptorFilter(map, ws).and(descriptorFilter).to(NutsIdFilter.class));
    }

    public static NutsDescriptorFilter createNutsDescriptorFilter(String arch, String os, String osDist, String platform, String desktopEnv, NutsSession session) {
        NutsDescriptorFilters d = NutsDescriptorFilters.of((NutsSession)session);
        return d.byArch(new String[]{arch}).and(d.byOs(new String[]{os})).and(d.byOsDist(new String[]{osDist})).and(d.byPlatform(new String[]{platform})).and(d.byDesktopEnvironment(new String[]{desktopEnv}));
    }

    public static NutsDescriptorFilter createNutsDescriptorFilter(Map<String, String> faceMap, NutsSession ws) {
        return CoreFilterUtils.createNutsDescriptorFilter(faceMap == null ? null : faceMap.get("arch"), faceMap == null ? null : faceMap.get("os"), faceMap == null ? null : faceMap.get("osdist"), faceMap == null ? null : faceMap.get("platform"), faceMap == null ? null : faceMap.get("desktop"), ws);
    }

    public static <T> NutsPredicate<NutsId> createFilter(NutsIdFilter t, NutsSession session) {
        if (t == null) {
            return null;
        }
        return new NutsIdFilterToPredicate(t, session);
    }

    public static List<NutsExtensionInformation> filterNutsExtensionInfoByLatestVersion(List<NutsExtensionInformation> base) {
        LinkedHashMap<String, NutsExtensionInformation> valid = new LinkedHashMap<String, NutsExtensionInformation>();
        for (NutsExtensionInformation n : base) {
            NutsExtensionInformation old = (NutsExtensionInformation)valid.get(n.getId().getShortName());
            if (old != null && old.getId().getVersion().compareTo(n.getId().getVersion()) >= 0) continue;
            valid.put(n.getId().getShortName(), n);
        }
        return new ArrayList<NutsExtensionInformation>(valid.values());
    }

    public static List<NutsId> filterNutsIdByLatestVersion(List<NutsId> base) {
        LinkedHashMap<String, NutsId> valid = new LinkedHashMap<String, NutsId>();
        for (NutsId n : base) {
            NutsId old = (NutsId)valid.get(n.getShortName());
            if (old != null && old.getVersion().compareTo(n.getVersion()) >= 0) continue;
            valid.put(n.getShortName(), n);
        }
        return new ArrayList<NutsId>(valid.values());
    }

    public static boolean matchesPackaging(String packaging, NutsDescriptor desc, NutsSession session) {
        if (NutsBlankable.isBlank((String)packaging)) {
            return true;
        }
        if (NutsBlankable.isBlank((String)desc.getPackaging())) {
            return true;
        }
        NutsIdParser parser = NutsIdParser.of((NutsSession)session);
        NutsId _v = parser.parse(packaging);
        NutsId _v2 = parser.parse(desc.getPackaging());
        if (_v == null || _v2 == null) {
            return _v == _v2;
        }
        return _v.equalsShortId(_v2) && _v.getVersion().filter().acceptVersion(_v2.getVersion(), session);
    }

    public static boolean acceptCondition(NutsEnvCondition envCond, boolean currentVMOnLy, NutsSession session) {
        if (envCond == null || envCond.isBlank()) {
            return true;
        }
        NutsWorkspaceEnvManager env = session.env();
        if (!CoreFilterUtils.matchesArch(env.getArch().toString(), envCond.getArch(), session)) {
            return false;
        }
        if (!CoreFilterUtils.matchesOs(env.getOs().toString(), envCond.getOs(), session)) {
            return false;
        }
        if (!CoreFilterUtils.matchesOsDist(env.getOsDist().toString(), envCond.getOsDist(), session)) {
            return false;
        }
        if (currentVMOnLy ? !CoreFilterUtils.matchesPlatform(env.getPlatform().toString(), envCond.getPlatform(), session) : !CoreFilterUtils.matchesPlatform(env.platforms().findPlatforms(), envCond.getPlatform(), session)) {
            return false;
        }
        return CoreFilterUtils.matchesDesktopEnvironment(env.getDesktopEnvironments(), envCond.getDesktopEnvironment(), session);
    }

    public static boolean matchesArch(String current, String[] allConds, NutsSession session) {
        if (NutsBlankable.isBlank((String)current)) {
            return true;
        }
        NutsIdParser parser = NutsIdParser.of((NutsSession)session);
        NutsId currentId = parser.parse(current);
        if (allConds != null && allConds.length > 0) {
            for (String cond : allConds) {
                if (NutsBlankable.isBlank((String)cond)) {
                    return true;
                }
                NutsId idCond = parser.setLenient(false).parse(cond);
                NutsArchFamily w = NutsArchFamily.parseLenient((String)idCond.getArtifactId(), null, null);
                if (w != null) {
                    idCond = idCond.builder().setArtifactId(w.id()).build();
                }
                if (!idCond.equalsShortId(currentId) || !idCond.getVersion().filter().acceptVersion(currentId.getVersion(), session)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public static boolean matchesOs(String os, String[] allConds, NutsSession session) {
        if (NutsBlankable.isBlank((String)os)) {
            return true;
        }
        NutsIdParser parser = NutsIdParser.of((NutsSession)session);
        NutsId currentId = parser.parse(os);
        if (allConds != null && allConds.length > 0) {
            int n = 0;
            String[] stringArray = allConds;
            int n2 = stringArray.length;
            if (n < n2) {
                String cond = stringArray[n];
                if (NutsBlankable.isBlank((String)cond)) {
                    return true;
                }
                NutsId condId = parser.setLenient(false).parse(cond);
                NutsOsFamily w = NutsOsFamily.parseLenient((String)condId.getArtifactId(), null, null);
                if (w != null) {
                    condId = condId.builder().setArtifactId(w.id()).build();
                }
                return condId.compatNewer().filter().acceptId(currentId, session);
            }
            return false;
        }
        return true;
    }

    public static boolean matchesOsDist(String current, String[] allConds, NutsSession session) {
        if (NutsBlankable.isBlank((String)current)) {
            return true;
        }
        NutsIdParser parser = NutsIdParser.of((NutsSession)session);
        NutsId currentId = parser.parse(current);
        if (allConds != null && allConds.length > 0) {
            int n = 0;
            String[] stringArray = allConds;
            int n2 = stringArray.length;
            if (n < n2) {
                String cond = stringArray[n];
                if (NutsBlankable.isBlank((String)cond)) {
                    return true;
                }
                NutsId y = parser.setLenient(false).parse(cond);
                return y.compatNewer().filter().acceptId(currentId, session);
            }
            return false;
        }
        return true;
    }

    public static boolean matchesPlatform(NutsPlatformLocation[] platforms, String[] allCond, NutsSession session) {
        for (NutsPlatformLocation platform : platforms) {
            NutsId id = platform.getId();
            if (id == null || !CoreFilterUtils.matchesPlatform(id.toString(), allCond, session)) continue;
            return true;
        }
        return false;
    }

    public static boolean matchesPlatform(String current, String[] allConds, NutsSession session) {
        if (NutsBlankable.isBlank((String)current)) {
            return true;
        }
        NutsIdParser parser = NutsIdParser.of((NutsSession)session);
        NutsId currentId = parser.parse(current);
        if (allConds != null && allConds.length > 0) {
            int n = 0;
            String[] stringArray = allConds;
            int n2 = stringArray.length;
            if (n < n2) {
                String cond = stringArray[n];
                if (NutsBlankable.isBlank((String)cond)) {
                    return true;
                }
                NutsId idCond = parser.setLenient(false).parse(cond);
                NutsPlatformFamily w = NutsPlatformFamily.parseLenient((String)idCond.getArtifactId(), null, null);
                if (w != null) {
                    idCond = idCond.builder().setArtifactId(w.id()).build();
                }
                return idCond.compatNewer().filter().acceptId(currentId, session);
            }
            return false;
        }
        return true;
    }

    public static boolean matchesDesktopEnvironment(NutsId[] platforms, String[] allConds, NutsSession session) {
        for (NutsId platform : platforms) {
            if (!CoreFilterUtils.matchesDesktopEnvironment(platform.toString(), allConds, session)) continue;
            return true;
        }
        return false;
    }

    public static boolean matchesDesktopEnvironment(String current, String[] allConds, NutsSession session) {
        if (NutsBlankable.isBlank((String)current)) {
            return true;
        }
        NutsIdParser parser = NutsIdParser.of((NutsSession)session);
        NutsId currentId = parser.parse(current);
        if (allConds != null && allConds.length > 0) {
            int n = 0;
            String[] stringArray = allConds;
            int n2 = stringArray.length;
            if (n < n2) {
                String cond = stringArray[n];
                if (NutsBlankable.isBlank((String)cond)) {
                    return true;
                }
                NutsId idCond = parser.setLenient(false).parse(cond);
                NutsDesktopEnvironmentFamily w = NutsDesktopEnvironmentFamily.parseLenient((String)idCond.getArtifactId(), null, null);
                if (w != null) {
                    idCond = idCond.builder().setArtifactId(w.id()).build();
                }
                return idCond.compatNewer().filter().acceptId(currentId, session);
            }
            return false;
        }
        return true;
    }

    public static boolean matchesEnv(String arch, String os, String dist, String platform, String de, NutsEnvCondition desc, NutsSession session) {
        if (!CoreFilterUtils.matchesArch(arch, desc.getArch(), session)) {
            return false;
        }
        if (!CoreFilterUtils.matchesOs(os, desc.getOs(), session)) {
            return false;
        }
        if (!CoreFilterUtils.matchesOsDist(dist, desc.getOsDist(), session)) {
            return false;
        }
        if (!CoreFilterUtils.matchesPlatform(platform, desc.getPlatform(), session)) {
            return false;
        }
        return CoreFilterUtils.matchesDesktopEnvironment(de, desc.getDesktopEnvironment(), session);
    }

    public static NutsDependency[] filterDependencies(NutsId from, NutsDependency[] d0, NutsDependencyFilter dependencyFilter, NutsSession session) {
        if (dependencyFilter == null) {
            return d0;
        }
        ArrayList<NutsDependency> r = new ArrayList<NutsDependency>(d0.length);
        for (NutsDependency nutsDependency : d0) {
            if (!dependencyFilter.acceptDependency(from, nutsDependency, session)) continue;
            r.add(nutsDependency);
        }
        return r.toArray(new NutsDependency[0]);
    }

    public static boolean matchesSimpleNameStaticVersion(NutsId id, NutsId pattern) {
        if (pattern == null) {
            return id == null;
        }
        if (id == null) {
            return false;
        }
        if (pattern.getVersion().isBlank()) {
            return pattern.getShortName().equals(id.getShortName());
        }
        return pattern.getLongName().equals(id.getLongName());
    }

    public static boolean acceptClassifier(NutsIdLocation location, String classifier) {
        if (location == null) {
            return false;
        }
        String c0 = NutsUtilStrings.trim((String)classifier);
        String c1 = NutsUtilStrings.trim((String)location.getClassifier());
        return c0.equals(c1);
    }

    public static NutsEnvCondition blankCondition(NutsSession session) {
        return new DefaultNutsEnvCondition(session);
    }

    public static NutsEnvCondition trimToNull(NutsEnvCondition c, NutsSession session) {
        if (c == null || c.isBlank()) {
            return null;
        }
        return c;
    }

    public static NutsEnvCondition trimToBlank(NutsEnvCondition c, NutsSession session) {
        if (c == null) {
            return CoreFilterUtils.blankCondition(session);
        }
        return c;
    }

    public static Map<String, String> toMap(NutsEnvCondition condition) {
        LinkedHashMap<String, String> m = new LinkedHashMap<String, String>();
        String s = Arrays.stream(condition.getArch()).map(String::trim).filter(x -> !x.isEmpty()).collect(Collectors.joining(","));
        if (!NutsBlankable.isBlank((String)s)) {
            m.put("arch", s);
        }
        if (!NutsBlankable.isBlank((String)(s = Arrays.stream(condition.getOs()).map(String::trim).filter(x -> !x.isEmpty()).collect(Collectors.joining(","))))) {
            m.put("os", s);
        }
        if (!NutsBlankable.isBlank((String)(s = Arrays.stream(condition.getOsDist()).map(String::trim).filter(x -> !x.isEmpty()).collect(Collectors.joining(","))))) {
            m.put("osdist", s);
        }
        if (!NutsBlankable.isBlank((String)(s = Arrays.stream(condition.getPlatform()).map(String::trim).filter(x -> !x.isEmpty()).collect(Collectors.joining(","))))) {
            m.put("platform", s);
        }
        if (!NutsBlankable.isBlank((String)(s = Arrays.stream(condition.getDesktopEnvironment()).map(String::trim).filter(x -> !x.isEmpty()).collect(Collectors.joining(","))))) {
            m.put("desktop", s);
        }
        if (!NutsBlankable.isBlank((String)(s = Arrays.stream(condition.getProfile()).map(String::trim).filter(x -> !x.isEmpty()).collect(Collectors.joining(","))))) {
            m.put("profile", s);
        }
        return m;
    }

    public static <T extends NutsFilter> T simplifyFilterOr(NutsSession ws, Class<T> cls, T base, NutsFilter ... all) {
        if (all.length == 0) {
            return (T)NutsFilters.of((NutsSession)ws).always(cls);
        }
        if (all.length == 1) {
            return (T)all[0].simplify();
        }
        ArrayList<NutsFilter> all2 = new ArrayList<NutsFilter>();
        boolean updates = false;
        boolean someFalse = false;
        for (NutsFilter t : all) {
            NutsFilter t2;
            NutsFilter nutsFilter = t2 = t == null ? null : t.simplify();
            if (t2 != null) {
                switch (t2.getFilterOp()) {
                    case TRUE: {
                        return (T)NutsFilters.of((NutsSession)ws).always(cls);
                    }
                    case FALSE: {
                        someFalse = true;
                        break;
                    }
                    default: {
                        if (t2 != t) {
                            updates = true;
                        }
                        all2.add(t2);
                        break;
                    }
                }
                continue;
            }
            updates = true;
        }
        if (all2.isEmpty()) {
            if (someFalse) {
                return (T)NutsFilters.of((NutsSession)ws).never(cls);
            }
            return (T)NutsFilters.of((NutsSession)ws).always(cls);
        }
        if (all2.size() == 1) {
            return (T)((NutsFilter)all2.get(0));
        }
        if (!updates) {
            return base;
        }
        return (T)NutsFilters.of((NutsSession)ws).any(cls, all2.toArray((NutsFilter[])Array.newInstance(cls, 0)));
    }

    public static <T extends NutsFilter> T simplifyFilterAnd(NutsSession ws, Class<T> cls, T base, NutsFilter ... all) {
        if (all.length == 0) {
            return (T)NutsFilters.of((NutsSession)ws).always(cls);
        }
        if (all.length == 1) {
            return (T)all[0].simplify();
        }
        ArrayList<NutsFilter> all2 = new ArrayList<NutsFilter>();
        boolean updates = false;
        for (NutsFilter t : all) {
            NutsFilter t2;
            NutsFilter nutsFilter = t2 = t == null ? null : t.simplify();
            if (t2 != null) {
                switch (t2.getFilterOp()) {
                    case FALSE: {
                        return (T)NutsFilters.of((NutsSession)ws).never(cls);
                    }
                    case TRUE: {
                        updates = true;
                        break;
                    }
                    default: {
                        if (t2 != t) {
                            updates = true;
                        }
                        all2.add(t2);
                        break;
                    }
                }
                continue;
            }
            updates = true;
        }
        if (all2.size() == 0) {
            return (T)NutsFilters.of((NutsSession)ws).always(cls);
        }
        if (all2.size() == 1) {
            return (T)((NutsFilter)all2.get(0));
        }
        if (!updates) {
            return base;
        }
        return (T)NutsFilters.of((NutsSession)ws).all(cls, all2.toArray((NutsFilter[])Array.newInstance(cls, 0)));
    }

    public static <T extends NutsFilter> T simplifyFilterNone(NutsSession ws, Class<T> cls, T base, NutsFilter ... all) {
        if (all.length == 0) {
            return (T)NutsFilters.of((NutsSession)ws).always(cls);
        }
        ArrayList<NutsFilter> all2 = new ArrayList<NutsFilter>();
        boolean updates = false;
        for (NutsFilter t : all) {
            NutsFilter t2;
            NutsFilter nutsFilter = t2 = t == null ? null : t.simplify();
            if (t2 != null) {
                switch (t2.getFilterOp()) {
                    case TRUE: {
                        return (T)NutsFilters.of((NutsSession)ws).never(cls);
                    }
                    case FALSE: {
                        updates = true;
                        break;
                    }
                    default: {
                        if (t2 != t) {
                            updates = true;
                        }
                        all2.add(t2);
                        break;
                    }
                }
                continue;
            }
            updates = true;
        }
        if (all2.size() == 0) {
            return (T)NutsFilters.of((NutsSession)ws).always(cls);
        }
        if (!updates) {
            return base;
        }
        return (T)NutsFilters.of((NutsSession)ws).none(cls, all2.toArray((NutsFilter[])Array.newInstance(cls, 0)));
    }

    public static <T> T simplify(T any) {
        if (any == null) {
            return null;
        }
        if (any instanceof Simplifiable) {
            return ((Simplifiable)any).simplify();
        }
        return any;
    }

    public static <T> T[] simplifyAndShrink(Class<T> cls, T ... any) {
        ArrayList<T> all = new ArrayList<T>();
        boolean updates = false;
        for (T t : any) {
            T t2 = CoreFilterUtils.simplify(t);
            if (t2 != null) {
                if (t2 != t) {
                    updates = true;
                }
                all.add(t2);
                continue;
            }
            updates = true;
        }
        if (!updates) {
            return null;
        }
        return all.toArray((Object[])Array.newInstance(cls, 0));
    }

    public static <T extends NutsFilter> T[] simplifyAndShrinkFilters(Class<T> cls, Predicate<T> onRemove, T ... any) {
        ArrayList<NutsFilter> all = new ArrayList<NutsFilter>();
        boolean updates = false;
        for (T t : any) {
            NutsFilter t2;
            NutsFilter nutsFilter = t2 = t == null ? null : t.simplify();
            if (t2 != null) {
                if (onRemove != null && onRemove.test(t2)) {
                    updates = true;
                    continue;
                }
                if (t2 != t) {
                    updates = true;
                }
                all.add(t2);
                continue;
            }
            updates = true;
        }
        if (!updates) {
            return null;
        }
        return all.toArray((NutsFilter[])Array.newInstance(cls, 0));
    }

    private static class NutsIdFilterToPredicate
    extends NutsPredicates.BasePredicate<NutsId> {
        private final NutsIdFilter t;
        private final NutsSession session;

        public NutsIdFilterToPredicate(NutsIdFilter t, NutsSession session) {
            this.t = t;
            this.session = session;
        }

        public boolean test(NutsId value) {
            return this.t.acceptId(value, this.session);
        }

        public int hashCode() {
            return Objects.hash(this.t, this.session);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            NutsIdFilterToPredicate that = (NutsIdFilterToPredicate)((Object)o);
            return Objects.equals(this.t, that.t) && Objects.equals(this.session, that.session);
        }

        public String toString() {
            return this.t.toString();
        }
    }
}

