/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.util.filters;

import net.thevpc.nuts.NutsElement;
import net.thevpc.nuts.NutsElements;
import net.thevpc.nuts.NutsFilter;
import net.thevpc.nuts.NutsFilterOp;
import net.thevpc.nuts.NutsFilters;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsWorkspace;

public abstract class AbstractNutsFilter
implements NutsFilter {
    private NutsSession session;
    private NutsFilterOp op;

    public AbstractNutsFilter(NutsSession session, NutsFilterOp op) {
        this.session = session;
        if (session == null) {
            throw new NullPointerException();
        }
        this.op = op;
    }

    public NutsFilterOp getFilterOp() {
        return this.op;
    }

    public NutsWorkspace getWorkspace() {
        return this.session.getWorkspace();
    }

    public NutsSession getSession() {
        return this.session;
    }

    public NutsFilter[] getSubFilters() {
        return new NutsFilter[0];
    }

    public NutsFilter or(NutsFilter other) {
        return other == null ? this : NutsFilters.of((NutsSession)this.getSession()).any(new NutsFilter[]{this, other});
    }

    public NutsFilter and(NutsFilter other) {
        return other == null ? this : NutsFilters.of((NutsSession)this.getSession()).all(new NutsFilter[]{this, other});
    }

    public NutsFilter neg() {
        return NutsFilters.of((NutsSession)this.getSession()).not((NutsFilter)this);
    }

    public <T extends NutsFilter> T to(Class<T> type) {
        return (T)NutsFilters.of((NutsSession)this.getSession()).to(type, (NutsFilter)this);
    }

    public Class<? extends NutsFilter> getFilterType() {
        return NutsFilters.of((NutsSession)this.getSession()).detectType((NutsFilter)this);
    }

    public <T extends NutsFilter> NutsFilter simplify(Class<T> type) {
        return this.simplify().to(type);
    }

    public NutsElement describe(NutsElements elems) {
        return elems.ofString(this.toString());
    }
}

