/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.util.collections;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class MultiKeyMap<K, V> {
    private Map<K, Base<K, V>> keyMap = new LinkedHashMap<K, Base<K, V>>();

    public void clear() {
        this.keyMap.clear();
    }

    public Set<K> allKeys() {
        return new HashSet<K>(this.keyMap.keySet());
    }

    public Set<K> mainKeys() {
        LinkedHashSet k = new LinkedHashSet();
        for (Base<K, V> value : this.keyMap.values()) {
            k.add(value.main);
        }
        return k;
    }

    public int mainSize() {
        return this.mainKeys().size();
    }

    public int allSize() {
        return this.keyMap.size();
    }

    public V remove(K k) {
        Base<K, V> s = this.keyMap.get(k);
        V old = null;
        if (s != null) {
            s.all.remove(k);
            old = s.value;
            this.keyMap.remove(k);
        }
        return old;
    }

    public V putMulti(K[] k, V v) {
        V o = this.put(k[0], v);
        for (int i = 1; i < k.length; ++i) {
            this.mergeKeys(k[0], k[1]);
        }
        return o;
    }

    public V put(K k, V v) {
        Base<K, V> s = this.keyMap.get(k);
        if (s == null) {
            s = new Base(k);
            this.keyMap.put(k, s);
        }
        Object old = s.value;
        s.value = v;
        return old;
    }

    public V get(K k) {
        Base<K, V> m = this.keyMap.get(k);
        if (m != null) {
            return m.value;
        }
        return null;
    }

    public void mergeKeys(K k1, K k2) {
        Base<K, V> s1 = this.keyMap.get(k1);
        Base<K, V> s2 = this.keyMap.get(k2);
        if (s1 != null && s2 == null) {
            s1 = new Base(k1);
            s1.add(k1);
            s1.add(k2);
            this.keyMap.put(s1.main, s1);
        } else if (s1 != null) {
            s1.add(k2);
        } else if (s2 != null) {
            s2.add(k1);
        } else if (s1 != s2) {
            throw new UnsupportedOperationException("unexpected");
        }
    }

    private static class Base<K, V> {
        K main;
        V value;
        Set<K> all = new HashSet<K>();

        public Base(K main) {
            this.main = main;
            this.all.add(main);
        }

        void add(K k) {
            this.all.add(k);
        }
    }
}

