/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.util.collections;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ListMap<K, V> {
    private Map<K, List<V>> map = this.createMap();

    public ListMap(Map<K, List<V>> map) {
        if (map != null) {
            this.map.putAll(map);
        }
    }

    public ListMap() {
    }

    public V getOne(K a) {
        List<V> all = this.map.get(a);
        if (all == null) {
            return null;
        }
        if (all.size() > 0) {
            return all.get(0);
        }
        return null;
    }

    public boolean contains(K a, V value) {
        List<V> all = this.map.get(a);
        if (all != null) {
            return all.contains(value);
        }
        return false;
    }

    public void add(K k, V v) {
        this.get(k).add(v);
    }

    private List<V> get(K k) {
        List<V> list = this.map.get(k);
        if (list == null) {
            list = this.createList();
            this.map.put(k, list);
        }
        return list;
    }

    public boolean remove(K a, V value) {
        List<V> all = this.map.get(a);
        if (all != null) {
            return all.remove(value);
        }
        return false;
    }

    public int keySize() {
        return this.map.size();
    }

    public int valueSize() {
        int count = 0;
        for (Map.Entry<K, List<V>> entry : this.map.entrySet()) {
            count += entry.getValue().size();
        }
        return count;
    }

    public List<V> getAll(K a) {
        List<V> all = this.map.get(a);
        if (all == null) {
            return Collections.EMPTY_LIST;
        }
        if (all.size() > 0) {
            return Collections.unmodifiableList(all);
        }
        return Collections.EMPTY_LIST;
    }

    public Set<Map.Entry<K, List<V>>> entrySet() {
        return this.map.entrySet();
    }

    public Set<K> keySet() {
        return Collections.unmodifiableSet(this.map.keySet());
    }

    public boolean containsKey(K key) {
        return this.map.containsKey(key);
    }

    protected Map<K, List<V>> createMap() {
        return new HashMap();
    }

    protected List<V> createList() {
        return new ArrayList();
    }
}

