/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.util.collections;

import java.util.AbstractList;
import java.util.Arrays;

public class EvictingQueue<T>
extends AbstractList<T> {
    private int from = 0;
    private int len;
    private Object[] values;

    public EvictingQueue(int max) {
        this.values = new Object[max];
    }

    @Override
    public void clear() {
        this.from = 0;
        this.len = 0;
    }

    @Override
    public int size() {
        return this.len;
    }

    @Override
    public T get(int pos) {
        if (pos >= 0 && pos < this.len) {
            int i = (this.from + pos) % this.values.length;
            return (T)this.values[i];
        }
        throw new IllegalArgumentException("invalid index " + pos);
    }

    @Override
    public boolean add(T t) {
        int pos = (this.from + this.len) % this.values.length;
        this.values[pos] = t;
        if (this.len < this.values.length) {
            ++this.len;
        } else {
            this.from = (this.from + 1) % this.values.length;
        }
        return true;
    }

    public String dump() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.size(); ++i) {
            sb.append(this.get(i));
        }
        return "EvictingQueue{from=" + this.from + ", len=" + this.len + ", raw=" + Arrays.toString(this.values) + ", values='" + sb + "'" + '}';
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        for (int i = 0; i < this.size(); ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(this.get(i));
        }
        sb.append("}");
        return sb.toString();
    }
}

