/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.util.collections;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.thevpc.nuts.NutsMapListener;
import net.thevpc.nuts.runtime.standalone.util.collections.ObservableMap;

public class DefaultObservableMap<K, V>
extends AbstractMap<K, V>
implements ObservableMap<K, V> {
    private Map<K, V> base = new HashMap();
    private List<NutsMapListener<K, V>> listeners;

    @Override
    public void addListener(NutsMapListener<K, V> listener) {
        if (listener != null) {
            if (this.listeners == null) {
                this.listeners = new ArrayList<NutsMapListener<K, V>>();
            }
            this.listeners.add(listener);
        }
    }

    @Override
    public void removeListener(NutsMapListener<K, V> listener) {
        if (listener != null && this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    @Override
    public NutsMapListener<K, V>[] getListeners() {
        return this.listeners.toArray(new NutsMapListener[0]);
    }

    @Override
    public V put(K key, V value) {
        if (this.base.containsKey(key)) {
            V old = this.base.put(key, value);
            if (this.listeners != null) {
                for (NutsMapListener<K, V> listener : this.listeners) {
                    listener.entryUpdated(key, value, old);
                }
            }
            return old;
        }
        V old = this.base.put(key, value);
        if (this.listeners != null) {
            for (NutsMapListener<K, V> listener : this.listeners) {
                listener.entryAdded(key, value);
            }
        }
        return old;
    }

    @Override
    public V remove(Object key) {
        Object kkey = key;
        boolean found = this.base.containsKey(kkey);
        V r = this.base.remove(key);
        if (found && this.listeners != null) {
            for (NutsMapListener<K, V> listener : this.listeners) {
                listener.entryRemoved(kkey, r);
            }
        }
        return r;
    }

    @Override
    public int size() {
        return this.base.size();
    }

    @Override
    public boolean isEmpty() {
        return this.base.isEmpty();
    }

    @Override
    public boolean containsValue(Object value) {
        return this.base.containsValue(value);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.base.containsKey(key);
    }

    @Override
    public V get(Object key) {
        return this.base.get(key);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        final Set<Map.Entry<K, V>> baseEntries = this.base.entrySet();
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                final Iterator baseIterator = baseEntries.iterator();
                return new Iterator<Map.Entry<K, V>>(){
                    Map.Entry<K, V> curr;

                    @Override
                    public boolean hasNext() {
                        return baseIterator.hasNext();
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        this.curr = (Map.Entry)baseIterator.next();
                        return this.curr;
                    }

                    @Override
                    public void remove() {
                        baseIterator.remove();
                        for (NutsMapListener listener : DefaultObservableMap.this.listeners) {
                            listener.entryRemoved(this.curr.getKey(), this.curr.getValue());
                        }
                    }
                };
            }

            @Override
            public int size() {
                return baseEntries.size();
            }
        };
    }
}

