/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.util.collections;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class ClassMap<V> {
    private static final long serialVersionUID = 1L;
    private static final Comparator<Class> CLASS_HIERARCHY_COMPARATOR = new Comparator<Class>(){

        @Override
        public int compare(Class o1, Class o2) {
            if (o1.isAssignableFrom(o2)) {
                return 1;
            }
            if (o2.isAssignableFrom(o1)) {
                return -1;
            }
            if (o1.isInterface() && !o2.isInterface()) {
                return 1;
            }
            if (o2.isInterface() && !o1.isInterface()) {
                return -1;
            }
            return 0;
        }
    };
    protected HashMap<Class, V> values;
    protected HashMap<Class, V[]> cachedValues;
    private final Class keyType;
    private final Class<V> valueType;
    private final HashMap<Class, Class[]> cachedHierarchy;

    public ClassMap(Class keyType, Class<V> valueType) {
        this(keyType, valueType, 0);
    }

    public ClassMap(Class keyType, Class<V> valueType, int initialCapacity) {
        this.keyType = keyType;
        this.valueType = valueType;
        this.values = new HashMap(initialCapacity);
        this.cachedValues = new HashMap(initialCapacity * 2);
        this.cachedHierarchy = new HashMap(initialCapacity * 2);
    }

    public static Class[] findClassHierarchy(Class clazz, Class baseType) {
        HashSet<Class> seen = new HashSet<Class>();
        LinkedList queue = new LinkedList();
        LinkedList<Class> result = new LinkedList<Class>();
        queue.add(clazz);
        while (!queue.isEmpty()) {
            Class i = (Class)queue.remove();
            if (baseType != null && !baseType.isAssignableFrom(i) || seen.contains(i)) continue;
            seen.add(i);
            result.add(i);
            if (i.getSuperclass() != null) {
                queue.add(i.getSuperclass());
            }
            for (Class<?> ii : i.getInterfaces()) {
                queue.add(ii);
            }
        }
        Collections.sort(result, CLASS_HIERARCHY_COMPARATOR);
        return result.toArray(new Class[result.size()]);
    }

    public Set<V> keySet() {
        return new HashSet<Class>(this.values.keySet());
    }

    public Collection<V> values() {
        return this.values.values();
    }

    public V put(Class classKey, V value) {
        this.cachedValues.clear();
        return this.values.put(classKey, value);
    }

    public V remove(Class classKey) {
        this.cachedValues.clear();
        return this.values.remove(classKey);
    }

    public Class[] getKeys(Class classKey) {
        Class[] keis = this.cachedHierarchy.get(classKey);
        if (keis == null) {
            keis = ClassMap.findClassHierarchy(classKey, this.keyType);
            this.cachedHierarchy.put(classKey, keis);
        }
        return keis;
    }

    public V getRequired(Class key) {
        V[] found = this.getAllRequired(key);
        return found[0];
    }

    public boolean containsExactKey(Class key) {
        return this.values.containsKey(key);
    }

    public V getExact(Class key) {
        return this.values.get(key);
    }

    public V get(Class key) {
        V[] found = this.getAll(key);
        if (found.length > 0) {
            return found[0];
        }
        return null;
    }

    public V[] getAllRequired(Class key) {
        V[] found = this.getAll(key);
        if (found.length > 0) {
            return found;
        }
        throw new NoSuchElementException(key.getName());
    }

    protected V[] getAllImpl(Class key) {
        Class[] keis = this.getKeys(key);
        ArrayList<V> all = new ArrayList<V>(keis.length);
        for (Class c : keis) {
            V u = this.values.get(c);
            if (u == null) continue;
            all.add(u);
        }
        return all.toArray((Object[])Array.newInstance(this.valueType, 0));
    }

    public V[] getAll(Class key) {
        V[] found = this.cachedValues.get(key);
        if (found == null) {
            found = this.getAllImpl(key);
            this.cachedValues.put(key, found);
        }
        return found;
    }

    public int hashCode() {
        int result = 0;
        if (this.values != null) {
            int h = 0;
            for (Map.Entry<Class, V> next : this.values.entrySet()) {
                h += next.getKey().getName().hashCode() ^ (next.getValue() == null ? 0 : next.getValue().hashCode());
            }
            result = h;
        }
        result = 31 * result + (this.keyType != null ? this.keyType.getName().hashCode() : 0);
        result = 31 * result + (this.valueType != null ? this.valueType.getName().hashCode() : 0);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClassMap)) {
            return false;
        }
        ClassMap classMap = (ClassMap)o;
        if (this.keyType != null ? !this.keyType.equals(classMap.keyType) : classMap.keyType != null) {
            return false;
        }
        if (this.valueType != null ? !this.valueType.equals(classMap.valueType) : classMap.valueType != null) {
            return false;
        }
        return this.values != null ? this.values.equals(classMap.values) : classMap.values == null;
    }

    public void clear() {
        this.values.clear();
        this.cachedValues.clear();
        this.cachedHierarchy.clear();
    }

    public int size() {
        return this.values.size();
    }
}

