/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.util;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.thevpc.nuts.NutsLogVerb;
import net.thevpc.nuts.NutsLoggerOp;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.pom.PomXmlParser;

public class XmlEscaper {
    private static final Pattern ENTITY_PATTERN = Pattern.compile("&[a-zA-Z]+;");
    private static final Map<String, String> atToSharp = new HashMap<String, String>();
    private static final Map<String, String> atToUnicode = new HashMap<String, String>();

    private static void install(String at, String sharp, String unicode) {
    }

    public static String escapeToCode(String any, NutsSession session) {
        Matcher m = ENTITY_PATTERN.matcher(any);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String g = m.group();
            String z = atToSharp.get(g);
            if (z != null) {
                m.appendReplacement(sb, z);
                continue;
            }
            NutsLoggerOp.of(PomXmlParser.class, (NutsSession)session).verb(NutsLogVerb.WARNING).level(Level.FINEST).log(NutsMessage.cstyle((String)"unsupported  xml entity declaration : %s", (Object[])new Object[]{g}));
            m.appendReplacement(sb, g);
        }
        m.appendTail(sb);
        return sb.toString();
    }

    public static String escapeToUnicode(String any, NutsSession session) {
        Matcher m = ENTITY_PATTERN.matcher(any);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String g = m.group();
            String z = atToUnicode.get(g);
            if (z != null) {
                m.appendReplacement(sb, z);
                continue;
            }
            NutsLoggerOp.of(PomXmlParser.class, (NutsSession)session).verb(NutsLogVerb.WARNING).level(Level.FINEST).log(NutsMessage.cstyle((String)"unsupported  xml entity declaration : %s", (Object[])new Object[]{g}));
            m.appendReplacement(sb, g);
        }
        m.appendTail(sb);
        return sb.toString();
    }

    static {
        XmlEscaper.install("&Oslash;", "&#216;", "\u00d8");
        XmlEscaper.install("&oslash;", "&#248;", "\u00f8");
        XmlEscaper.install("&AElig;", "&#198;", "\u00c6");
        XmlEscaper.install("&aelig;", "&#230;", "\u00e6");
        XmlEscaper.install("&Auml;", "&#196;", "\u00c4");
        XmlEscaper.install("&auml;", "&#228;", "\u00e4");
        XmlEscaper.install("&OElig;", "&#338;", "\u0152");
        XmlEscaper.install("&oelig;", "&#339;", "\u0153");
        XmlEscaper.install("&lt;", "&#60;", "<");
        XmlEscaper.install("&gt;", "&#62;", ">");
        XmlEscaper.install("&amp;", "&#38;", "&");
        XmlEscaper.install("&quot;", "&#34;", "\"");
        XmlEscaper.install("&euro;", "&#8364;", "\t\u20ac");
        XmlEscaper.install("&circ;", "&#710;", "\u02c6");
        XmlEscaper.install("&tilde;", "&#732;", "\u223c");
        XmlEscaper.install("&ndash;", "&#45;", "\u2013");
        XmlEscaper.install("&copy;", "&#169;", "\u00a9");
        XmlEscaper.install("&nbsp;", "&#32;", " ");
        XmlEscaper.install("&apos;", "&#39;", "'");
    }
}

