/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.util;

import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.logging.Level;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsException;
import net.thevpc.nuts.NutsExecCommand;
import net.thevpc.nuts.NutsExecutionType;
import net.thevpc.nuts.NutsIOException;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIdBuilder;
import net.thevpc.nuts.NutsLogVerb;
import net.thevpc.nuts.NutsLogger;
import net.thevpc.nuts.NutsLoggerOp;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsOsFamily;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsPlatformFamily;
import net.thevpc.nuts.NutsPlatformLocation;
import net.thevpc.nuts.NutsScheduler;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsTexts;
import net.thevpc.nuts.NutsUtilPlatforms;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.NutsVersion;
import net.thevpc.nuts.NutsVersionFilter;
import net.thevpc.nuts.NutsVersionFilters;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceUtils;
import net.thevpc.nuts.runtime.standalone.workspace.config.NutsSdkLocationComparator;

public class NutsJavaSdkUtils {
    private final NutsWorkspace ws;
    private NutsLogger LOG;

    private NutsJavaSdkUtils(NutsWorkspace ws) {
        this.ws = ws;
    }

    public static NutsJavaSdkUtils of(NutsSession session) {
        return NutsJavaSdkUtils.of(session.getWorkspace());
    }

    public static NutsJavaSdkUtils of(NutsWorkspace ws) {
        return new NutsJavaSdkUtils(ws);
    }

    protected NutsLoggerOp _LOGOP(NutsSession session) {
        return this._LOG(session).with().session(session);
    }

    protected NutsLogger _LOG(NutsSession session) {
        if (this.LOG == null) {
            this.LOG = NutsLogger.of(NutsJavaSdkUtils.class, (NutsSession)session);
        }
        return this.LOG;
    }

    public NutsPlatformLocation resolveJdkLocation(String requestedJavaVersion, NutsSession session) {
        requestedJavaVersion = NutsUtilStrings.trim((String)requestedJavaVersion);
        NutsPlatformLocation bestJava = session.env().platforms().findPlatformByVersion(NutsPlatformFamily.JAVA, NutsVersionFilters.of((NutsSession)session).byValue(requestedJavaVersion));
        if (bestJava == null) {
            String appSuffix = session.env().getOsFamily() == NutsOsFamily.WINDOWS ? ".exe" : "";
            String packaging = "jre";
            if (new File(System.getProperty("java.home"), "bin" + File.separator + "javac" + appSuffix).isFile()) {
                packaging = "jdk";
            }
            String product = "JDK";
            NutsPlatformLocation current = new NutsPlatformLocation(session.env().getPlatform(), product, product + "-" + System.getProperty("java.version"), System.getProperty("java.home"), System.getProperty("java.version"), packaging, 0);
            current.setConfigVersion("0.8.0");
            NutsVersionFilter requestedJavaVersionFilter = NutsVersion.of((String)requestedJavaVersion, (NutsSession)session).filter();
            if (requestedJavaVersionFilter == null || requestedJavaVersionFilter.acceptVersion(NutsVersion.of((String)current.getVersion(), (NutsSession)session), session)) {
                bestJava = current;
            }
            if (bestJava == null) {
                if (!NutsBlankable.isBlank((String)requestedJavaVersion)) {
                    this._LOGOP(session).level(Level.FINE).verb(NutsLogVerb.WARNING).log(NutsMessage.jstyle((String)"no valid JRE found. recommended {0} . Using default java.home at {1}", (Object[])new Object[]{requestedJavaVersion, System.getProperty("java.home")}));
                } else {
                    this._LOGOP(session).level(Level.FINE).verb(NutsLogVerb.WARNING).log(NutsMessage.jstyle((String)"no valid JRE found. Using default java.home at {0}", (Object[])new Object[]{System.getProperty("java.home")}));
                }
                bestJava = current;
            }
        }
        return bestJava;
    }

    public NutsPlatformLocation[] searchJdkLocations(NutsSession session) {
        String[] conf = new String[]{};
        switch (session.env().getOsFamily()) {
            case LINUX: 
            case UNIX: 
            case UNKNOWN: {
                conf = new String[]{"/usr/java", "/usr/lib64/jvm", "/usr/lib/jvm"};
                break;
            }
            case WINDOWS: {
                conf = new String[]{NutsUtilPlatforms.getWindowsProgramFiles() + "\\Java", NutsUtilPlatforms.getWindowsProgramFilesX86() + "\\Java"};
                break;
            }
            case MACOS: {
                conf = new String[]{"/Library/Java/JavaVirtualMachines", "/System/Library/Frameworks/JavaVM.framework"};
            }
        }
        ArrayList<NutsPlatformLocation> all = new ArrayList<NutsPlatformLocation>();
        for (String s : conf) {
            all.addAll(Arrays.asList(this.searchJdkLocations(s, session)));
        }
        return all.toArray(new NutsPlatformLocation[0]);
    }

    public Future<NutsPlatformLocation[]> searchJdkLocationsFuture(NutsSession session) {
        LinkedHashSet<String> conf = new LinkedHashSet<String>();
        File file = new File(System.getProperty("java.home"));
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ArrayList<Future<NutsPlatformLocation[]>> all = new ArrayList<Future<NutsPlatformLocation[]>>();
        NutsPlatformLocation base = this.resolveJdkLocation(file.getPath(), null, session);
        if (base != null) {
            all.add(CompletableFuture.completedFuture(new NutsPlatformLocation[]{base}));
        }
        switch (session.env().getOsFamily()) {
            case LINUX: 
            case UNIX: 
            case UNKNOWN: {
                conf.addAll(Arrays.asList("/usr/java", "/usr/lib64/jvm", "/usr/lib/jvm"));
                break;
            }
            case WINDOWS: {
                conf.addAll(Arrays.asList(NutsUtilPlatforms.getWindowsProgramFiles() + "\\Java", NutsUtilPlatforms.getWindowsProgramFilesX86() + "\\Java"));
                break;
            }
            case MACOS: {
                conf.addAll(Arrays.asList("/Library/Java/JavaVirtualMachines", "/System/Library/Frameworks/JavaVM.framework"));
            }
        }
        for (String s : conf) {
            all.add(this.searchJdkLocationsFuture(Paths.get(s, new String[0]), session));
        }
        return NutsScheduler.of((NutsSession)session).executorService().submit(() -> {
            ArrayList<NutsPlatformLocation> locs = new ArrayList<NutsPlatformLocation>();
            for (Future nutsSdkLocationFuture : all) {
                NutsPlatformLocation[] e = (NutsPlatformLocation[])nutsSdkLocationFuture.get();
                if (e == null) continue;
                locs.addAll(Arrays.asList(e));
            }
            locs.sort(new NutsSdkLocationComparator(session));
            return locs.toArray(new NutsPlatformLocation[0]);
        });
    }

    public NutsPlatformLocation[] searchJdkLocations(String loc, NutsSession session) {
        Path s = Paths.get(loc, new String[0]);
        ArrayList<NutsPlatformLocation> all = new ArrayList<NutsPlatformLocation>();
        if (Files.isDirectory(s, new LinkOption[0])) {
            try (DirectoryStream<Path> it = Files.newDirectoryStream(s);){
                for (Path d : it) {
                    NutsPlatformLocation r = this.resolveJdkLocation(d.toString(), null, session);
                    if (r == null) continue;
                    all.add(r);
                    if (session == null || !session.isPlainTrace()) continue;
                    NutsTexts factory = NutsTexts.of((NutsSession)session);
                    session.out().printf("detected java %s %s at %s%n", new Object[]{r.getPackaging(), factory.ofStyled(r.getVersion(), NutsTextStyle.version()), factory.ofStyled(r.getPath(), NutsTextStyle.path())});
                }
            }
            catch (IOException ex) {
                throw new NutsIOException(session, (Throwable)ex);
            }
        }
        all.sort(new NutsSdkLocationComparator(session));
        return all.toArray(new NutsPlatformLocation[0]);
    }

    public Future<NutsPlatformLocation[]> searchJdkLocationsFuture(Path s, NutsSession session) {
        ArrayList<Future<NutsPlatformLocation>> all = new ArrayList<Future<NutsPlatformLocation>>();
        if (s == null) {
            return CompletableFuture.completedFuture(new NutsPlatformLocation[0]);
        }
        if (Files.isDirectory(s, new LinkOption[0])) {
            try (DirectoryStream<Path> it = Files.newDirectoryStream(s);){
                for (Path d : it) {
                    all.add(NutsScheduler.of((NutsSession)session).executorService().submit(() -> {
                        NutsPlatformLocation r;
                        block5: {
                            r = null;
                            try {
                                r = this.resolveJdkLocation(d.toString(), null, session);
                                if (r == null || !session.isPlainTrace()) break block5;
                                NutsWorkspace nutsWorkspace = session.getWorkspace();
                                synchronized (nutsWorkspace) {
                                    NutsTexts factory = NutsTexts.of((NutsSession)session);
                                    session.out().printf("detected java %s %s at %s%n", new Object[]{r.getPackaging(), factory.ofStyled(r.getVersion(), NutsTextStyle.version()), factory.ofStyled(r.getPath(), NutsTextStyle.path())});
                                }
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        }
                        return r;
                    }));
                }
            }
            catch (IOException ex) {
                throw new NutsIOException(session, (Throwable)ex);
            }
        }
        return NutsScheduler.of((NutsSession)session).executorService().submit(() -> {
            ArrayList<NutsPlatformLocation> locs = new ArrayList<NutsPlatformLocation>();
            for (Future nutsSdkLocationFuture : all) {
                NutsPlatformLocation e = (NutsPlatformLocation)nutsSdkLocationFuture.get();
                if (e == null) continue;
                locs.add(e);
            }
            return locs.toArray(new NutsPlatformLocation[0]);
        });
    }

    public NutsPlatformLocation resolveJdkLocation(String path, String preferredName, NutsSession session) {
        NutsWorkspaceUtils.checkSession(this.ws, session);
        if (path == null) {
            throw new NutsException(session, NutsMessage.formatted((String)"missing path"));
        }
        String appSuffix = session.env().getOsFamily() == NutsOsFamily.WINDOWS ? ".exe" : "";
        Path bin = Paths.get(path, new String[0]).resolve("bin");
        Path javaExePath = bin.resolve("java" + appSuffix);
        if (!Files.isRegularFile(javaExePath, new LinkOption[0])) {
            return null;
        }
        String product = null;
        String jdkVersion = null;
        String cmdOutputString = null;
        int cmdRresult = 0;
        boolean loggedError = false;
        try {
            int MAX_ITER = 5;
            for (int i = 0; i < 5; ++i) {
                NutsExecCommand cmd = session.exec().setSession(session).setExecutionType(NutsExecutionType.SYSTEM).addCommand(new String[]{javaExePath.toString(), "-version"}).setRedirectErrorStream(true).grabOutputString().setFailFast(true).run();
                cmdRresult = cmd.getResult();
                cmdOutputString = cmd.getOutputString();
                if (cmdOutputString.length() > 0) break;
                this._LOGOP(session).level(i == 4 ? Level.WARNING : Level.FINER).verb(NutsLogVerb.WARNING).log(NutsMessage.jstyle((String)"unable to execute {0}. returned empty string ({1}/{2})", (Object[])new Object[]{javaExePath, i + 1, 5}));
            }
            if (cmdOutputString.length() > 0) {
                int j;
                String prefix = "java version \"";
                int i = cmdOutputString.indexOf(prefix);
                if (i >= 0) {
                    j = cmdOutputString.indexOf("\"", i += prefix.length());
                    if (i >= 0) {
                        jdkVersion = cmdOutputString.substring(i, j);
                        product = "JDK";
                    }
                }
                if (jdkVersion == null && (i = cmdOutputString.indexOf(prefix = "openjdk version \"")) >= 0) {
                    j = cmdOutputString.indexOf("\"", i += prefix.length());
                    if (i > 0) {
                        jdkVersion = cmdOutputString.substring(i, j);
                        product = "OpenJDK";
                    }
                }
            }
        }
        catch (Exception ex) {
            loggedError = true;
            this._LOGOP(session).error((Throwable)ex).level(Level.SEVERE).verb(NutsLogVerb.WARNING).log(NutsMessage.jstyle((String)"unable to execute {0}. JDK Home ignored", (Object[])new Object[]{javaExePath}));
        }
        if (jdkVersion == null) {
            if (!loggedError) {
                this._LOGOP(session).level(Level.SEVERE).verb(NutsLogVerb.WARNING).log(NutsMessage.jstyle((String)"execute {0} failed with result code {1} and result string \"{2}\". JDK Home ignored", (Object[])new Object[]{javaExePath.toString(), cmdRresult, cmdOutputString}));
            }
            return null;
        }
        String packaging = "jre";
        if (Files.isRegularFile(bin.resolve("javac" + appSuffix), new LinkOption[0]) && Files.isRegularFile(bin.resolve("jps" + appSuffix), new LinkOption[0])) {
            packaging = "jdk";
        }
        preferredName = NutsBlankable.isBlank((String)preferredName) ? product + "-" + jdkVersion : NutsUtilStrings.trim((String)preferredName);
        NutsPlatformLocation r = new NutsPlatformLocation(NutsWorkspaceUtils.of(session).createSdkId("java", jdkVersion), product, preferredName, path, jdkVersion, packaging, 0);
        r.setConfigVersion("0.8.0");
        return r;
    }

    public NutsId createJdkId(String version, NutsSession session) {
        if (NutsBlankable.isBlank((String)version)) {
            throw new NutsException(session, NutsMessage.formatted((String)"missing version"));
        }
        NutsVersion jv = NutsVersion.of((String)version, (NutsSession)session);
        long n1 = jv.getNumber(0, BigInteger.ZERO).longValue();
        long n2 = jv.getNumber(1, BigInteger.ZERO).longValue();
        long classFileId = 0L;
        String standard = n1 + "." + n2;
        if (n1 == 1L) {
            classFileId = 44L + n2;
        }
        if (classFileId == 0L) {
            classFileId = 52L;
        }
        return NutsIdBuilder.of((NutsSession)session).setArtifactId("java").setProperty("s", standard).setProperty("c", String.valueOf(classFileId)).setVersion(version).build();
    }

    public String resolveJavaCommandByVersion(String requestedJavaVersion, boolean javaw, NutsSession session) {
        boolean winOs;
        String bestJavaPath = this.resolveJdkLocation(requestedJavaVersion, session).getPath();
        NutsPath file = NutsPath.of((String)bestJavaPath, (NutsSession)session).toAbsolute(session.locations().getWorkspaceLocation());
        boolean bl = winOs = session.env().getOsFamily() == NutsOsFamily.WINDOWS;
        bestJavaPath = winOs ? (javaw ? file.resolve("bin").resolve("javaw.exe").toString() : file.resolve("bin").resolve("java.exe").toString()) : file.resolve("bin").resolve("java").toString();
        return bestJavaPath;
    }

    public String resolveJavaCommandByHome(String javaHome, NutsSession session) {
        String appSuffix = session.env().getOsFamily() == NutsOsFamily.WINDOWS ? ".exe" : "";
        String exe = "java" + appSuffix;
        if ((javaHome == null || javaHome.isEmpty()) && (NutsBlankable.isBlank((String)(javaHome = System.getProperty("java.home"))) || "null".equals(javaHome))) {
            return exe;
        }
        return javaHome + File.separator + "bin" + File.separator + exe;
    }
}

