/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsSession;

public class NutsDebugString {
    private boolean all;
    private boolean enabled;
    private int port;
    private int maxPort;
    private boolean tcp;
    private boolean suspend;
    private final List<NutsArgument> options = new ArrayList<NutsArgument>();

    public static NutsDebugString of(String str, NutsSession session) {
        NutsDebugString d = new NutsDebugString();
        if (str == null) {
            d.setEnabled(false);
        } else {
            d.setEnabled(true);
            d.setSuspend(true);
            block14: for (String a : str.split("[ ,;]")) {
                NutsArgument na = NutsArgument.of((String)a, (NutsSession)session);
                switch (na.getKey().getString("")) {
                    case "s": 
                    case "suspend": {
                        d.setSuspend(!na.isNegated());
                        continue block14;
                    }
                    case "a": 
                    case "all": {
                        d.setAll(!na.isNegated());
                        continue block14;
                    }
                    case "tcp": {
                        d.setTcp(!na.isNegated());
                        continue block14;
                    }
                    case "port": {
                        String s = na.getValue().getString("").trim();
                        if (s.matches("[0-9]+-[0-9]+")) {
                            int sep = s.indexOf(45);
                            d.setPort(Integer.parseInt(s.substring(0, sep)));
                            d.setMaxPort(Integer.parseInt(s.substring(sep + 1)));
                            continue block14;
                        }
                        d.setPort(na.getValue().getInt());
                        continue block14;
                    }
                    default: {
                        if (na.getValue().isNull()) {
                            if (na.getKey().isBoolean()) {
                                boolean v = na.getKey().getBoolean();
                                d.setEnabled(na.isNegated() != v);
                                continue block14;
                            }
                            if (na.getKey().isInt()) {
                                d.setPort(na.getKey().getInt());
                                continue block14;
                            }
                            d.options.add(na);
                            continue block14;
                        }
                        d.options.add(na);
                    }
                }
            }
        }
        return d;
    }

    public List<NutsArgument> getOptions() {
        return this.options;
    }

    public NutsArgument getOption(String key) {
        for (NutsArgument option : this.options) {
            if (!Objects.equals(option.getKey().getString(), key)) continue;
            return option;
        }
        return null;
    }

    public boolean isAll() {
        return this.all;
    }

    public NutsDebugString setAll(boolean all) {
        this.all = all;
        return this;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public NutsDebugString setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public int getPort() {
        return this.port;
    }

    public NutsDebugString setPort(int port) {
        this.port = port;
        return this;
    }

    public boolean isTcp() {
        return this.tcp;
    }

    public NutsDebugString setTcp(boolean tcp) {
        this.tcp = tcp;
        return this;
    }

    public boolean isSuspend() {
        return this.suspend;
    }

    public NutsDebugString setSuspend(boolean suspend) {
        this.suspend = suspend;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NutsDebugString that = (NutsDebugString)o;
        return this.all == that.all && this.enabled == that.enabled && this.port == that.port && this.maxPort == that.maxPort && this.tcp == that.tcp && this.suspend == that.suspend && Objects.equals(this.options, that.options);
    }

    public int hashCode() {
        return Objects.hash(this.all, this.enabled, this.port, this.maxPort, this.tcp, this.suspend, this.options);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.isEnabled() ? "enabled" : "disabled");
        if (this.all) {
            sb.append(",all");
        }
        if (this.port > 0) {
            sb.append(",").append(this.port);
        }
        if (this.maxPort > 0) {
            sb.append(",max-port=").append(this.maxPort);
        }
        if (this.isSuspend()) {
            sb.append(",suspend");
        }
        for (NutsArgument option : this.options) {
            sb.append(",").append(option);
        }
        return sb.toString();
    }

    public int getMaxPort() {
        return this.maxPort;
    }

    public NutsDebugString setMaxPort(int maxPort) {
        this.maxPort = maxPort;
        return this;
    }
}

