/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.util;

import java.util.Arrays;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsCommandLineConfigurable;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsSession;

public class NutsConfigurableHelper {
    public static <T> T configure(NutsCommandLineConfigurable c, NutsSession session, boolean skipUnsupported, String[] args, String commandName) {
        c.configure(skipUnsupported, NutsCommandLine.of((String[])args, (NutsSession)session).setCommandName(commandName));
        return (T)c;
    }

    public static boolean configure(NutsCommandLineConfigurable c, NutsSession session, boolean skipUnsupported, NutsCommandLine commandLine) {
        boolean conf = false;
        int maxLoops = 1000;
        boolean robustMode = false;
        while (commandLine.hasNext()) {
            if (robustMode) {
                Object[] before = commandLine.toStringArray();
                if (!c.configureFirst(commandLine)) {
                    if (skipUnsupported) {
                        commandLine.skip();
                    } else {
                        commandLine.unexpectedArgument();
                    }
                } else {
                    conf = true;
                }
                Object[] after = commandLine.toStringArray();
                if (Arrays.equals(before, after)) {
                    throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"bad implementation of configureFirst in class %s. commandline is not consumed; perhaps missing skip() class. args = %s", (Object[])new Object[]{c.getClass().getName(), Arrays.toString(after)}));
                }
            } else if (!c.configureFirst(commandLine)) {
                if (skipUnsupported) {
                    commandLine.skip();
                } else {
                    commandLine.unexpectedArgument();
                }
            } else {
                conf = true;
            }
            if (--maxLoops >= 0) continue;
            robustMode = true;
        }
        return conf;
    }
}

