/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.util;

import java.util.function.Function;
import net.thevpc.nuts.NutsSession;

public class NutsCachedValue<T> {
    private final Function<NutsSession, T> supplier;
    private T lastValue;
    private long lastDate;
    private long timeoutMilliSeconds;
    private boolean updating = false;

    public NutsCachedValue(Function<NutsSession, T> callable, long timeoutMilliSeconds) {
        this.supplier = callable;
        this.timeoutMilliSeconds = timeoutMilliSeconds;
    }

    public long getTimeoutMilliSeconds() {
        return this.timeoutMilliSeconds;
    }

    public void setTimeoutMilliSeconds(long timeoutMilliSeconds) {
        this.timeoutMilliSeconds = timeoutMilliSeconds;
    }

    public boolean isValid() {
        return !this.isInvalid();
    }

    public boolean isInvalid() {
        long x;
        if (this.lastDate == 0L || this.timeoutMilliSeconds == 0L) {
            return true;
        }
        if (this.timeoutMilliSeconds < 0L) {
            this.timeoutMilliSeconds = 1000L;
        }
        return (x = System.currentTimeMillis() - this.lastDate) < 0L || x > this.timeoutMilliSeconds;
    }

    public void updateAsync(final NutsSession session) {
        if (!this.updating) {
            new Thread(){

                @Override
                public void run() {
                    NutsCachedValue.this.update(session);
                }
            }.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T update(NutsSession session) {
        this.updating = true;
        try {
            long now = System.currentTimeMillis();
            try {
                this.lastValue = this.supplier.apply(session);
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            if (this.lastValue != null) {
                this.lastDate = now;
            }
        }
        finally {
            this.updating = false;
        }
        return this.lastValue;
    }

    public boolean tryUpdate(NutsSession session) {
        if (this.isInvalid()) {
            this.update(session);
            return true;
        }
        return false;
    }

    public T getValue(NutsSession session) {
        this.tryUpdate(session);
        return this.lastValue;
    }

    public T getLastValue() {
        return this.lastValue;
    }

    public long getLastDate() {
        return this.lastDate;
    }
}

