/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.util;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.logging.Level;
import net.thevpc.nuts.NutsContent;
import net.thevpc.nuts.NutsDefaultContent;
import net.thevpc.nuts.NutsDefinition;
import net.thevpc.nuts.NutsDescriptor;
import net.thevpc.nuts.NutsDescriptorParser;
import net.thevpc.nuts.NutsIOException;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsLogger;
import net.thevpc.nuts.NutsLoggerOp;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsNotFoundException;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsUnsupportedOperationException;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.NutsVersion;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.standalone.definition.DefaultNutsDefinition;
import net.thevpc.nuts.runtime.standalone.io.util.CoreIOUtils;
import net.thevpc.nuts.runtime.standalone.io.util.UnzipOptions;
import net.thevpc.nuts.runtime.standalone.io.util.ZipUtils;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceUtils;

public class DefaultSourceControlHelper {
    private NutsLogger LOG;
    private NutsWorkspace ws;

    public DefaultSourceControlHelper(NutsWorkspace ws) {
        this.ws = ws;
    }

    protected NutsLoggerOp _LOGOP(NutsSession session) {
        return this._LOG(session).with().session(session);
    }

    protected NutsLogger _LOG(NutsSession session) {
        if (this.LOG == null) {
            this.LOG = NutsLogger.of(DefaultSourceControlHelper.class, (NutsSession)session);
        }
        return this.LOG;
    }

    public NutsId commit(Path folder, NutsSession session) {
        NutsWorkspaceUtils.checkSession(this.ws, session);
        session.security().setSession(session).checkAllowed("deploy", "commit");
        if (folder == null || !Files.isDirectory(folder, new LinkOption[0])) {
            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"not a directory %s", (Object[])new Object[]{folder}));
        }
        Path file = folder.resolve("nuts.json");
        NutsDescriptor d = NutsDescriptorParser.of((NutsSession)session).parse(file);
        String oldVersion = NutsUtilStrings.trim((String)d.getId().getVersion().getValue());
        if (oldVersion.endsWith("-CHECKED-OUT")) {
            oldVersion = oldVersion.substring(0, oldVersion.length() - "-CHECKED-OUT".length());
            String newVersion = NutsVersion.of((String)oldVersion, (NutsSession)session).inc().getValue();
            NutsDefinition newVersionFound = null;
            try {
                newVersionFound = session.fetch().setId(d.getId().builder().setVersion(newVersion).build()).setSession(session).getResultDefinition();
            }
            catch (NutsNotFoundException ex) {
                this._LOGOP(session).level(Level.FINE).error((Throwable)ex).log(NutsMessage.jstyle((String)"failed to fetch {0}", (Object[])new Object[]{d.getId().builder().setVersion(newVersion).build()}));
            }
            d = newVersionFound == null ? d.builder().setId(d.getId().builder().setVersion(newVersion).build()).build() : d.builder().setId(d.getId().builder().setVersion(oldVersion + ".1").build()).build();
            NutsId newId = session.deploy().setContent(folder).setDescriptor(d).setSession(session).getResult()[0];
            d.formatter().setSession(session).print(file);
            CoreIOUtils.delete(session, folder);
            return newId;
        }
        throw new NutsUnsupportedOperationException(session, NutsMessage.cstyle((String)"commit not supported", (Object[])new Object[0]));
    }

    public NutsDefinition checkout(String id, Path folder, NutsSession session) {
        return this.checkout(NutsId.of((String)id, (NutsSession)session), folder, session);
    }

    public NutsDefinition checkout(NutsId id, Path folder, NutsSession session) {
        NutsWorkspaceUtils.checkSession(this.ws, session);
        session.security().checkAllowed("install", "checkout");
        NutsDefinition nutToInstall = session.fetch().setId(id).setSession(session).setOptional(Boolean.valueOf(false)).setDependencies(true).getResultDefinition();
        if ("zip".equals(nutToInstall.getDescriptor().getPackaging())) {
            try {
                ZipUtils.unzip(session, nutToInstall.getFile().toString(), NutsPath.of((Path)folder, (NutsSession)session).toAbsolute().toString(), new UnzipOptions().setSkipRoot(false));
            }
            catch (IOException ex) {
                throw new NutsIOException(session, (Throwable)ex);
            }
            Path file = folder.resolve("nuts.json");
            NutsDescriptor d = NutsDescriptorParser.of((NutsSession)session).parse(file);
            NutsVersion oldVersion = d.getId().getVersion();
            NutsId newId = d.getId().builder().setVersion(oldVersion + "-CHECKED-OUT").build();
            d = d.builder().setId(newId).build();
            d.formatter().setSession(session).print(file);
            return new DefaultNutsDefinition(nutToInstall.getRepositoryUuid(), nutToInstall.getRepositoryName(), newId.getLongId(), d, (NutsContent)new NutsDefaultContent(NutsPath.of((Path)folder, (NutsSession)session), false, false), null, null, session);
        }
        throw new NutsUnsupportedOperationException(session, NutsMessage.cstyle((String)"checkout not supported", (Object[])new Object[0]));
    }
}

