/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.lang.reflect.Array;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.thevpc.nuts.NutsException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsNotFoundException;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsTextBuilder;
import net.thevpc.nuts.NutsTexts;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.runtime.standalone.util.CoreEnumUtils;
import net.thevpc.nuts.runtime.standalone.util.CoreNutsUtils;

public final class CoreStringUtils {
    private static final Pattern PATTERN_ALL = Pattern.compile(".*");

    public static String escapeQuoteStrings(String s) {
        StringBuilder sb = new StringBuilder(s.length());
        block3: for (char c : s.toCharArray()) {
            switch (c) {
                case '\'': 
                case '\\': {
                    sb.append("\\");
                    sb.append(c);
                    continue block3;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static String escapeReplacementStrings(String s) {
        StringBuilder sb = new StringBuilder(s.length());
        block3: for (char c : s.toCharArray()) {
            switch (c) {
                case '$': 
                case '\\': 
                case '{': 
                case '}': {
                    sb.append("\\");
                    sb.append(c);
                    continue block3;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static String simpleQuote(String text) {
        return CoreStringUtils.simpleQuote(text, false, null);
    }

    public static String simpleQuote(String text, boolean compact, String escapedChars) {
        StringBuilder sb = new StringBuilder();
        boolean q = !compact;
        block6: for (char c : text.toCharArray()) {
            switch (c) {
                case '\n': {
                    q = true;
                    sb.append("\\n");
                    continue block6;
                }
                case '\f': {
                    q = true;
                    sb.append("\\f");
                    continue block6;
                }
                case '\r': {
                    q = true;
                    sb.append("\\r");
                    continue block6;
                }
                case '\"': 
                case '\'': {
                    q = true;
                    sb.append("\\").append(c);
                    continue block6;
                }
                default: {
                    if (escapedChars != null && escapedChars.indexOf(c) >= 0) {
                        q = true;
                        sb.append("\\").append(c);
                        continue block6;
                    }
                    sb.append(c);
                }
            }
        }
        if (q) {
            sb.insert(0, '\'');
            sb.append('\'');
        }
        return sb.toString();
    }

    public static String dblQuote(String text) {
        return CoreStringUtils.dblQuote(text, false, null);
    }

    public static String dblQuote(String text, boolean compact, String entrySeparators) {
        StringBuilder sb = new StringBuilder();
        boolean q = !compact;
        block6: for (char c : text.toCharArray()) {
            switch (c) {
                case '\n': {
                    q = true;
                    sb.append("\\n");
                    continue block6;
                }
                case '\f': {
                    q = true;
                    sb.append("\\f");
                    continue block6;
                }
                case '\r': {
                    q = true;
                    sb.append("\\r");
                    continue block6;
                }
                case '\"': {
                    q = true;
                    sb.append("\\").append(c);
                    continue block6;
                }
                default: {
                    if (entrySeparators != null && entrySeparators.indexOf(c) >= 0) {
                        q = true;
                        sb.append("\\").append(c);
                        continue block6;
                    }
                    sb.append(c);
                }
            }
        }
        if (q) {
            sb.insert(0, '\"');
            sb.append('\"');
        }
        return sb.toString();
    }

    public static boolean containsVars(String value) {
        return value != null && value.contains("${");
    }

    public static boolean containsTopWord(String word, String line) {
        StreamTokenizer tokenizer = new StreamTokenizer(new StringReader(line));
        int last_ttype = -1;
        try {
            while (tokenizer.nextToken() != -1) {
                switch (tokenizer.ttype) {
                    case -3: {
                        if (!word.equals(tokenizer.sval) || last_ttype == 46) break;
                        return true;
                    }
                }
                last_ttype = tokenizer.ttype;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public static char[] strToChr(String s) {
        if (s == null) {
            return null;
        }
        return s.toCharArray();
    }

    public static String chrToStr(char[] s) {
        if (s == null) {
            return null;
        }
        return new String(s);
    }

    public static String enforceDoubleQuote(String s) {
        if (s.isEmpty() || s.contains(" ") || s.contains("\"")) {
            s = "\"" + s.replace("\"", "\\\"") + "\"";
        }
        return s;
    }

    public static String enforceDoubleQuote(String s, NutsSession session) {
        s = NutsTexts.of((NutsSession)session).builder().append((Object)s).toString();
        if (s.isEmpty() || s.contains(" ") || s.contains("\"") || s.contains("'")) {
            s = "\"" + s + "\"";
        }
        return s;
    }

    public static StringBuilder clear(StringBuilder c) {
        return c.delete(0, c.length());
    }

    public static String exceptionToString(Throwable ex) {
        return CoreStringUtils.exceptionToString(ex, false);
    }

    public static int firstIndexOf(String string, char[] chars) {
        char[] value = string.toCharArray();
        for (int i = 0; i < value.length; ++i) {
            for (int j = 0; j < chars.length; ++j) {
                if (value[i] != chars[j]) continue;
                return i;
            }
        }
        return -1;
    }

    public static String exceptionToString(Throwable ex, boolean inner) {
        String msg = null;
        if (ex instanceof NutsNotFoundException || ex instanceof UncheckedIOException) {
            if (ex.getCause() != null) {
                Throwable ex2 = ex.getCause();
                if (ex2 instanceof UncheckedIOException) {
                    ex2 = ex.getCause();
                }
                msg = CoreStringUtils.exceptionToString(ex2, true);
            } else {
                msg = ex.getMessage();
            }
        } else {
            String msg2 = ex.toString();
            if (msg2.startsWith(ex.getClass().getName() + ":")) {
                msg = inner ? msg2.substring(ex.getClass().getName().length() + 1).trim() : ex.getClass().getSimpleName() + ": " + msg2.substring(ex.getClass().getName().length() + 1).trim();
            } else {
                for (Class aClass : new Class[]{NullPointerException.class, ArrayIndexOutOfBoundsException.class, ClassCastException.class, UnsupportedOperationException.class, ReflectiveOperationException.class, Error.class}) {
                    if (!aClass.isInstance(ex)) continue;
                    return ex.toString();
                }
                msg = ex.getMessage();
                if (msg == null) {
                    msg = ex.toString();
                }
            }
        }
        return msg;
    }

    public static NutsMessage exceptionToMessage(Throwable ex) {
        return CoreStringUtils.exceptionToMessage(ex, false);
    }

    public static NutsMessage exceptionToMessage(Throwable ex, boolean inner) {
        NutsMessage msg = null;
        if (ex instanceof UncheckedIOException) {
            if (ex.getCause() != null) {
                Throwable ex2 = ex.getCause();
                if (ex2 instanceof UncheckedIOException) {
                    ex2 = ex.getCause();
                }
                msg = CoreStringUtils.exceptionToMessage(ex2, true);
            } else {
                msg = NutsMessage.plain((String)ex.getMessage());
            }
        } else if (ex instanceof NutsNotFoundException) {
            if (ex.getCause() != null) {
                Throwable ex2 = ex.getCause();
                if (ex2 instanceof UncheckedIOException) {
                    ex2 = ex.getCause();
                }
                msg = CoreStringUtils.exceptionToMessage(ex2, true);
            } else {
                msg = NutsMessage.formatted((String)((NutsNotFoundException)ex).getFormattedString().toString());
            }
        } else if (ex instanceof NutsException) {
            msg = NutsMessage.formatted((String)((NutsException)ex).getFormattedString().toString());
        } else {
            String msg2 = ex.toString();
            if (msg2.startsWith(ex.getClass().getName() + ":")) {
                msg = inner ? NutsMessage.plain((String)msg2.substring(ex.getClass().getName().length() + 1).trim()) : NutsMessage.plain((String)(ex.getClass().getSimpleName() + ": " + msg2.substring(ex.getClass().getName().length() + 1).trim()));
            } else {
                for (Class aClass : new Class[]{NullPointerException.class, ArrayIndexOutOfBoundsException.class, ClassCastException.class, UnsupportedOperationException.class, ReflectiveOperationException.class, Error.class}) {
                    if (!aClass.isInstance(ex)) continue;
                    return NutsMessage.plain((String)ex.toString());
                }
                NutsMessage nutsMessage = msg = ex.getMessage() == null ? null : NutsMessage.plain((String)ex.getMessage());
                if (msg == null) {
                    msg = NutsMessage.plain((String)ex.toString());
                }
            }
        }
        return msg;
    }

    public static String fillString(char x, int width) {
        if (width <= 0) {
            return "";
        }
        char[] cc = new char[width];
        Arrays.fill(cc, x);
        return new String(cc);
    }

    public static String fillString(String x, int width) {
        if (width <= 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        CoreStringUtils.fillString(x, width, sb);
        return sb.toString();
    }

    public static void fillString(char x, int width, StringBuilder sb) {
        if (width <= 0) {
            return;
        }
        sb.ensureCapacity(sb.length() + width);
        for (int i = 0; i < width; ++i) {
            sb.append(x);
        }
    }

    public static void fillString(char x, int width, NutsTextBuilder sb) {
        if (width <= 0) {
            return;
        }
        for (int i = 0; i < width; ++i) {
            sb.append((Object)Character.valueOf(x));
        }
    }

    public static void fillString(String x, int width, StringBuilder sb) {
        if (width <= 0) {
            return;
        }
        sb.ensureCapacity(sb.length() + width * x.length());
        for (int i = 0; i < width; ++i) {
            sb.append(x);
        }
    }

    public static void fillString(String x, int width, NutsTextBuilder sb) {
        if (width <= 0) {
            return;
        }
        for (int i = 0; i < width; ++i) {
            sb.append((Object)x);
        }
    }

    public static String alignLeft(String s, int width) {
        StringBuilder sb = new StringBuilder();
        if (s != null) {
            sb.append(s);
            int x = width - sb.length();
            if (x > 0) {
                sb.append(CoreStringUtils.fillString(' ', x));
            }
        }
        return sb.toString();
    }

    public static String alignRight(String s, int width) {
        StringBuilder sb = new StringBuilder();
        if (s != null) {
            sb.append(s);
            int x = width - sb.length();
            if (x > 0) {
                sb.insert(0, CoreStringUtils.fillString(' ', x));
            }
        }
        return sb.toString();
    }

    public static String indexToString(int x) {
        if (x < 0) {
            return "-" + CoreStringUtils.indexToString(-x);
        }
        StringBuilder sb = new StringBuilder();
        while (x > 0) {
            int y = x % 10;
            if (y == 0) {
                sb.insert(0, '0');
            } else {
                sb.insert(0, (char)(65 + (y - 1)));
            }
            x /= 10;
        }
        if (sb.length() == 0) {
            return "A";
        }
        return sb.toString();
    }

    public static String[] parseAndTrimToDistinctArray(String s) {
        if (s == null) {
            return new String[0];
        }
        return (String[])Arrays.stream(s.split("[,;| \t]")).map(String::trim).filter(x -> x.length() > 0).distinct().toArray(String[]::new);
    }

    public static String joinAndTrimToNull(String[] args) {
        return NutsUtilStrings.trimToNull((String)String.join((CharSequence)",", args));
    }

    public static String prefixLinesPortableNL(String str, String prefix) {
        return CoreStringUtils.prefixLines(str, prefix, "\n");
    }

    public static String prefixLinesOsNL(String str, String prefix) {
        return CoreStringUtils.prefixLines(str, prefix, System.getProperty("line.separator"));
    }

    public static String prefixLines(String str, String prefix, String nl) {
        BufferedReader br = new BufferedReader(new StringReader(str == null ? "" : str));
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        if (nl == null && (nl = System.getProperty("line.separator")) == null) {
            nl = "\n";
        }
        while (true) {
            String line;
            try {
                line = br.readLine();
                if (line == null) {
                }
            }
            catch (IOException e) {}
            break;
            if (first) {
                first = false;
            } else {
                sb.append(nl);
            }
            sb.append(prefix);
            sb.append(line);
        }
        return sb.toString();
    }

    public static String coalesce(String a, String b) {
        return a == null ? b : a;
    }

    public static List<String> splitOn(String line, char sep) {
        StringTokenizer st = new StringTokenizer(line, "" + sep, true);
        ArrayList<String> ret = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            ret.add(st.nextToken());
        }
        return ret;
    }

    public static List<String> splitOnNewlines(String line) {
        char[] text = line.toCharArray();
        StringBuilder sb = new StringBuilder();
        ArrayList<String> tb = new ArrayList<String>();
        block4: for (int i = 0; i < text.length; ++i) {
            switch (text[i]) {
                case '\r': {
                    if (sb.length() > 0) {
                        tb.add(sb.toString());
                        sb.setLength(0);
                    }
                    if (i + 1 < text.length && text[i + 1] == '\n') {
                        tb.add("\r\n");
                        ++i;
                        continue block4;
                    }
                    tb.add("\r");
                    continue block4;
                }
                case '\n': {
                    if (sb.length() > 0) {
                        tb.add(sb.toString());
                        sb.setLength(0);
                    }
                    tb.add("\n");
                    continue block4;
                }
                default: {
                    sb.append(text[i]);
                }
            }
        }
        if (sb.length() > 0) {
            tb.add(sb.toString());
            sb.setLength(0);
        }
        return tb;
    }

    public static String stringValue(Object o) {
        if (o == null) {
            return "";
        }
        if (o.getClass().isEnum()) {
            return CoreEnumUtils.getEnumString((Enum)o);
        }
        if (o instanceof Instant) {
            return CoreNutsUtils.DEFAULT_DATE_TIME_FORMATTER.format((Instant)o);
        }
        if (o instanceof Date) {
            return CoreNutsUtils.DEFAULT_DATE_TIME_FORMATTER.format(((Date)o).toInstant());
        }
        if (o instanceof Collection) {
            Collection c = (Collection)o;
            Object[] a = c.toArray();
            if (a.length == 0) {
                return "";
            }
            if (a.length == 1) {
                return CoreStringUtils.stringValue(a[0]);
            }
            return "[" + String.join((CharSequence)", ", c.stream().map(x -> CoreStringUtils.stringValue(x)).collect(Collectors.toList())) + "]";
        }
        if (o.getClass().isArray()) {
            int len = Array.getLength(o);
            if (len == 0) {
                return "";
            }
            if (len == 1) {
                return CoreStringUtils.stringValue(Array.get(o, 0));
            }
            ArrayList<String> all = new ArrayList<String>(len);
            for (int i = 0; i < len; ++i) {
                all.add(CoreStringUtils.stringValue(Array.get(o, i)).toString());
            }
            return "[" + String.join((CharSequence)", ", all) + "]";
        }
        return o.toString();
    }
}

