/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsEnvCondition;
import net.thevpc.nuts.NutsException;
import net.thevpc.nuts.NutsExecutionType;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsOsFamily;
import net.thevpc.nuts.NutsRef;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsSessionTerminal;
import net.thevpc.nuts.runtime.standalone.util.CoreStringUtils;
import net.thevpc.nuts.runtime.standalone.util.filters.CoreFilterUtils;

public class CorePlatformUtils {
    public static final boolean SUPPORTS_UTF_ENCODING;
    public static boolean IS_CYGWIN;
    public static boolean IS_MINGW_XTERM;
    private static Map<String, String> LOADED_OS_DIST_MAP;

    private static String buildUnixOsNameAndVersion(String name, NutsSession session) {
        Map<String, String> m = CorePlatformUtils.getOsDistMap(session);
        String v = m.get("osVersion");
        if (NutsBlankable.isBlank((String)v)) {
            return name;
        }
        return name + "#" + v;
    }

    public static Map<String, String> getOsDistMap(NutsSession session) {
        String property = System.getProperty("os.name").toLowerCase();
        if (property.startsWith("linux")) {
            if (LOADED_OS_DIST_MAP == null) {
                LOADED_OS_DIST_MAP = CorePlatformUtils.getOsDistMapLinux(session);
            }
            return Collections.unmodifiableMap(LOADED_OS_DIST_MAP);
        }
        if (property.startsWith("mac")) {
            if (LOADED_OS_DIST_MAP == null) {
                LOADED_OS_DIST_MAP = CorePlatformUtils.getOsDistMapLinux(session);
            }
            return Collections.unmodifiableMap(LOADED_OS_DIST_MAP);
        }
        if (property.startsWith("sunos")) {
            if (LOADED_OS_DIST_MAP == null) {
                LOADED_OS_DIST_MAP = CorePlatformUtils.getOsDistMapLinux(session);
            }
            return Collections.unmodifiableMap(LOADED_OS_DIST_MAP);
        }
        if (property.startsWith("freebsd")) {
            if (LOADED_OS_DIST_MAP == null) {
                LOADED_OS_DIST_MAP = CorePlatformUtils.getOsDistMapLinux(session);
            }
            return Collections.unmodifiableMap(LOADED_OS_DIST_MAP);
        }
        return new HashMap<String, String>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> getOsDistMapLinux(NutsSession session) {
        File fileVersion;
        File[] a;
        File dir = new File("/etc/");
        ArrayList<File> fileList = new ArrayList<File>();
        if (dir.exists() && (a = dir.listFiles((dir1, filename) -> filename.endsWith("-release"))) != null) {
            fileList.addAll(Arrays.asList(a));
        }
        if ((fileVersion = new File("/proc/version")).exists()) {
            fileList.add(fileVersion);
        }
        String disId = null;
        String disName = null;
        String disVersion = null;
        File linuxOsrelease = new File("/proc/sys/kernel/osrelease");
        StringBuilder osVersion = new StringBuilder();
        if (linuxOsrelease.isFile()) {
            BufferedReader myReader = null;
            String strLine = null;
            try {
                try {
                    myReader = new BufferedReader(new FileReader(linuxOsrelease));
                    while ((strLine = myReader.readLine()) != null) {
                        osVersion.append(strLine).append("\n");
                    }
                }
                finally {
                    if (myReader != null) {
                        myReader.close();
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (osVersion.toString().trim().isEmpty()) {
            CoreStringUtils.clear(osVersion);
            try {
                osVersion.append(session.exec().setExecutionType(NutsExecutionType.SYSTEM).setCommand(new String[]{"uname", "-r"}).setRedirectErrorStream(true).grabOutputString().setSleepMillis(50).getOutputString());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        block31: for (File f : fileList) {
            try {
                BufferedReader myReader = new BufferedReader(new FileReader(f));
                Throwable throwable = null;
                try {
                    String strLine = null;
                    while ((strLine = myReader.readLine()) != null) {
                        if ((strLine = strLine.trim()).startsWith("#") || !strLine.contains("=")) continue;
                        int i = strLine.indexOf(61);
                        String n = strLine.substring(0, i);
                        String v = strLine.substring(i + 1);
                        switch (n) {
                            case "ID": 
                            case "DISTRIB_ID": {
                                if (v.startsWith("\"")) {
                                    v = v.substring(1, v.length() - 1);
                                }
                                disId = v;
                                break;
                            }
                            case "VERSION_ID": 
                            case "DISTRIB_RELEASE": {
                                if (v.startsWith("\"")) {
                                    v = v.substring(1, v.length() - 1);
                                }
                                disVersion = v;
                                break;
                            }
                            case "PRETTY_NAME": {
                                if (v.startsWith("\"")) {
                                    v = v.substring(1, v.length() - 1);
                                }
                                disName = v;
                            }
                        }
                        if (NutsBlankable.isBlank(disVersion) || NutsBlankable.isBlank(disName) || NutsBlankable.isBlank((String)disId)) continue;
                        continue block31;
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (myReader == null) continue;
                    if (throwable != null) {
                        try {
                            myReader.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    myReader.close();
                }
            }
            catch (Exception e) {
                session.err().printf("error: %s%n", new Object[]{CoreStringUtils.exceptionToMessage(e)});
            }
        }
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("distId", disId);
        m.put("distName", disName);
        m.put("distVersion", disVersion);
        m.put("osVersion", osVersion.toString().trim());
        return m;
    }

    public static String getPlatformOsDist(NutsSession session) {
        String osInfo = CorePlatformUtils.getPlatformOs(session);
        if (osInfo.startsWith("linux")) {
            Map<String, String> m = CorePlatformUtils.getOsDistMap(session);
            String distId = m.get("distId");
            String distVersion = m.get("distVersion");
            if (!NutsBlankable.isBlank((String)distId)) {
                if (!NutsBlankable.isBlank((String)distId)) {
                    return distId + "#" + distVersion;
                }
                return distId;
            }
        }
        return null;
    }

    public static String getPlatformOs(NutsSession ws) {
        String property = System.getProperty("os.name").toLowerCase();
        if (property.startsWith("linux")) {
            return CorePlatformUtils.buildUnixOsNameAndVersion("linux", ws);
        }
        if (property.startsWith("win")) {
            if (property.startsWith("windows 10")) {
                return "windows#10";
            }
            if (property.startsWith("windows 8.1")) {
                return "windows#6.3";
            }
            if (property.startsWith("windows 8")) {
                return "windows#6.2";
            }
            if (property.startsWith("windows 7")) {
                return "windows#6.1";
            }
            if (property.startsWith("windows vista")) {
                return "windows#6";
            }
            if (property.startsWith("windows xp pro")) {
                return "windows#5.2";
            }
            if (property.startsWith("windows xp")) {
                return "windows#5.1";
            }
            return "windows";
        }
        if (property.startsWith("mac")) {
            if (property.startsWith("mac os x") || property.startsWith("macosx")) {
                return "macos#10";
            }
            return CorePlatformUtils.buildUnixOsNameAndVersion("macos", ws);
        }
        if (property.startsWith("sunos") || property.startsWith("solaris")) {
            return CorePlatformUtils.buildUnixOsNameAndVersion("sunos", ws);
        }
        if (property.startsWith("zos")) {
            return CorePlatformUtils.buildUnixOsNameAndVersion("zos", ws);
        }
        if (property.startsWith("freebsd")) {
            return CorePlatformUtils.buildUnixOsNameAndVersion("freebsd", ws);
        }
        if (property.startsWith("openbsd")) {
            return CorePlatformUtils.buildUnixOsNameAndVersion("openbsd", ws);
        }
        if (property.startsWith("netbsd")) {
            return CorePlatformUtils.buildUnixOsNameAndVersion("netbsd", ws);
        }
        if (property.startsWith("aix")) {
            return CorePlatformUtils.buildUnixOsNameAndVersion("aix", ws);
        }
        if (property.startsWith("hpux")) {
            return CorePlatformUtils.buildUnixOsNameAndVersion("hpux", ws);
        }
        if (property.startsWith("os400") && property.length() <= 5 || !Character.isDigit(property.charAt(5))) {
            return CorePlatformUtils.buildUnixOsNameAndVersion("os400", ws);
        }
        return "unknown";
    }

    public static boolean checkAcceptCondition(NutsEnvCondition condition, boolean currentVM, NutsSession session) {
        if (!CoreFilterUtils.acceptCondition(condition, currentVM, session)) {
            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"unsupported environment", (Object[])new Object[0]));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public static boolean isLoadedClassPath(File file, ClassLoader classLoader, NutsSessionTerminal terminal) {
        block20: {
            try {
                if (file == null) break block20;
                ZipFile zipFile = null;
                try {
                    zipFile = new ZipFile(file);
                    Enumeration<? extends ZipEntry> entries = zipFile.entries();
                    while (true) {
                        if (!entries.hasMoreElements()) break block20;
                        ZipEntry zipEntry = entries.nextElement();
                        String zname = zipEntry.getName();
                        if (zname.endsWith("/") || !zname.endsWith(".class") || zname.contains("$")) continue;
                        String clz = zname.substring(0, zname.length() - 6).replace('/', '.');
                        try {
                            Class<?> aClass = (classLoader == null ? Thread.currentThread().getContextClassLoader() : classLoader).loadClass(clz);
                            if (terminal != null) {
                                terminal.out().printf("loaded %s from %s%n", new Object[]{aClass, file});
                            }
                            boolean bl = true;
                            return bl;
                        }
                        catch (ClassNotFoundException e) {
                            boolean bl;
                            block21: {
                                bl = false;
                                if (zipFile == null) break block21;
                                try {
                                    zipFile.close();
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                            return bl;
                        }
                    }
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    if (zipFile != null) {
                        try {
                            zipFile.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            catch (IOException e) {
                return false;
            }
        }
        return false;
    }

    public static <T> T runWithinLoader(Callable<T> callable, ClassLoader loader, NutsSession session) {
        NutsRef ref = new NutsRef();
        Thread thread = new Thread(() -> {
            try {
                ref.set(callable.call());
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new NutsException(session, NutsMessage.plain((String)"run with loader failed"), (Throwable)ex);
            }
        }, "RunWithinLoader");
        thread.setContextClassLoader(loader);
        thread.start();
        try {
            thread.join();
        }
        catch (InterruptedException ex) {
            throw new NutsException(session, NutsMessage.plain((String)"run with loader failed"), (Throwable)ex);
        }
        return (T)ref.get();
    }

    public static String getPackageName(String cn) {
        int i = cn.lastIndexOf(46);
        if (i >= 0) {
            return cn.substring(0, i);
        }
        return "";
    }

    public static String getSimpleClassName(String cn) {
        int i = cn.lastIndexOf(46);
        if (i >= 0) {
            return cn.substring(i + 1);
        }
        return cn;
    }

    static {
        IS_CYGWIN = System.getenv("PWD") != null && System.getenv("PWD").startsWith("/") && !"cygwin".equals(System.getenv("TERM"));
        IS_MINGW_XTERM = System.getenv("MSYSTEM") != null && System.getenv("MSYSTEM").startsWith("MINGW") && "xterm".equals(System.getenv("TERM"));
        LOADED_OS_DIST_MAP = null;
        boolean _e = new String("\u00f8".getBytes()).equals("\u00f8");
        if (_e) {
            switch (NutsOsFamily.getCurrent()) {
                case LINUX: 
                case MACOS: {
                    break;
                }
                case WINDOWS: {
                    if (!IS_CYGWIN && !IS_MINGW_XTERM) {
                        _e = false;
                    }
                }
                default: {
                    _e = false;
                }
            }
        }
        SUPPORTS_UTF_ENCODING = _e;
    }
}

