/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.util;

import java.io.File;
import java.io.IOException;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsClassLoaderNode;
import net.thevpc.nuts.NutsDefinition;
import net.thevpc.nuts.NutsDependencies;
import net.thevpc.nuts.NutsDependency;
import net.thevpc.nuts.NutsFetchModeNotSupportedException;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIdBuilder;
import net.thevpc.nuts.NutsIdType;
import net.thevpc.nuts.NutsNotFoundException;
import net.thevpc.nuts.NutsOsFamily;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsStoreLocation;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.NutsVersion;
import net.thevpc.nuts.runtime.standalone.util.CoreNumberUtils;
import net.thevpc.nuts.runtime.standalone.util.CoreStringUtils;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceUtils;
import net.thevpc.nuts.runtime.standalone.xtra.expr.StringPlaceHolderParser;

public class CoreNutsUtils {
    public static final String LOCAL_NUTS_FOLDER = "${home.config}/.vpc-public-nuts";
    public static final int DEFAULT_UUID_LENGTH = 25;
    public static final int DEFAULT_DATE_TIME_FORMATTER_LENGTH = 23;
    public static final DateTimeFormatter DEFAULT_DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS").withZone(ZoneId.systemDefault());
    public static final String[] COLOR_NAMES = new TreeSet<String>(Arrays.asList("Maroon", "Brown", "Olive", "Teal", "Navy", "Black", "Red", "Orange", "Yellow", "Lime", "Green", "Cyan", "Blue", "Purple", "Magenta", "Grey", "Pink", "Apricot", "Beige", "Mint", "Lavender", "White", "Turquoise", "Aqua", "Aquamarine", "Gold", "Coral", "Tomato", "Firebrick", "Crimson", "Salmon", "Moccasin", "PeachPuff", "Khaki", "Cornsilk", "Bisque", "Wheat", "Tan", "Peru", "Chocolate", "Sienna", "Snow", "Azure", "Ivory", "Linen", "Silver", "Gray")).toArray(new String[0]);
    public static final int LOCK_TIME = 3;
    public static final TimeUnit LOCK_TIME_UNIT = TimeUnit.SECONDS;
    public static final NutsDefaultThreadFactory nutsDefaultThreadFactory = new NutsDefaultThreadFactory("nuts-pool", true);
    private static final Map<String, String> _QUERY_EMPTY_ENV = new HashMap<String, String>();
    public static final Map<String, String> QUERY_EMPTY_ENV = Collections.unmodifiableMap(_QUERY_EMPTY_ENV);
    public static Comparator<NutsId> NUTS_ID_COMPARATOR = new Comparator<NutsId>(){

        @Override
        public int compare(NutsId o1, NutsId o2) {
            if (o1 == null || o2 == null) {
                if (o1 == o2) {
                    return 0;
                }
                if (o1 == null) {
                    return -1;
                }
                return 1;
            }
            return o1.toString().compareTo(o2.toString());
        }
    };
    public static Comparator<NutsDefinition> NUTS_FILE_COMPARATOR = new Comparator<NutsDefinition>(){

        @Override
        public int compare(NutsDefinition o1, NutsDefinition o2) {
            if (o1 == null || o2 == null) {
                if (o1 == o2) {
                    return 0;
                }
                if (o1 == null) {
                    return -1;
                }
                return 1;
            }
            return NUTS_ID_COMPARATOR.compare(o1.getId(), o2.getId());
        }
    };

    public static String randomColorName() {
        return COLOR_NAMES[(int)(Math.random() * (double)COLOR_NAMES.length)];
    }

    public static String repeat(char txt, int count) {
        StringBuilder sb = new StringBuilder(count);
        for (int i = 0; i < count; ++i) {
            sb.append(txt);
        }
        return sb.toString();
    }

    public static NutsId findNutsIdBySimpleName(NutsId id, Collection<NutsId> all) {
        if (all != null) {
            for (NutsId nutsId : all) {
                if (nutsId == null || !nutsId.equalsShortId(id)) continue;
                return nutsId;
            }
        }
        return null;
    }

    public static String formatImport(List<String> imports) {
        LinkedHashSet<String> all = new LinkedHashSet<String>();
        StringBuilder sb = new StringBuilder();
        for (String s : imports) {
            if ((s = s.trim()).length() <= 0 || all.contains(s)) continue;
            all.add(s);
            if (sb.length() > 0) {
                sb.append(":");
            }
            sb.append(s);
        }
        return sb.toString();
    }

    public static boolean isEffectiveValue(String value) {
        return !NutsBlankable.isBlank((String)value) && !CoreStringUtils.containsVars(value);
    }

    public static boolean isEffectiveId(NutsId id) {
        return CoreNutsUtils.isEffectiveValue(id.getGroupId()) && CoreNutsUtils.isEffectiveValue(id.getArtifactId()) && CoreNutsUtils.isEffectiveValue(id.getVersion().getValue());
    }

    public static boolean containsVars(NutsId id) {
        return CoreStringUtils.containsVars(id.getGroupId()) && CoreStringUtils.containsVars(id.getArtifactId()) && CoreStringUtils.containsVars(id.getVersion().getValue());
    }

    public static String[] applyStringProperties(String[] child, Function<String, String> properties) {
        String[] vals = new String[child.length];
        for (int i = 0; i < vals.length; ++i) {
            vals[i] = CoreNutsUtils.applyStringProperties(child[i], properties);
        }
        return vals;
    }

    public static Map<String, String> applyMapProperties(Map<String, String> child, Function<String, String> properties) {
        LinkedHashMap<String, String> m2 = new LinkedHashMap<String, String>();
        for (Map.Entry<String, String> entry : child.entrySet()) {
            m2.put(CoreNutsUtils.applyStringProperties(entry.getKey(), properties), CoreNutsUtils.applyStringProperties(entry.getValue(), properties));
        }
        return m2;
    }

    public static NutsVersion applyStringProperties(NutsVersion child, Function<String, String> properties, NutsSession ws) {
        if (child == null) {
            return child;
        }
        String s = child.getValue();
        if (NutsBlankable.isBlank((String)s)) {
            return NutsVersion.of((String)"", (NutsSession)ws);
        }
        String s2 = CoreNutsUtils.applyStringProperties(s, properties);
        if (!NutsUtilStrings.trim((String)s2).equals(s)) {
            return NutsVersion.of((String)s2, (NutsSession)ws);
        }
        return child;
    }

    public static String applyStringProperties(String child, Function<String, String> properties) {
        if (NutsBlankable.isBlank((String)child)) {
            return null;
        }
        return StringPlaceHolderParser.replaceDollarPlaceHolders(child, properties);
    }

    public static String applyStringInheritance(String child, String parent) {
        child = NutsUtilStrings.trimToNull((String)child);
        parent = NutsUtilStrings.trimToNull((String)parent);
        if (child == null) {
            return parent;
        }
        return child;
    }

    public static NutsId applyNutsIdInheritance(NutsId child, NutsId parent, NutsSession ws) {
        if (parent != null) {
            Map parentFaceMap;
            boolean modified = false;
            String repository = child.getRepository();
            String group = child.getGroupId();
            String name = child.getArtifactId();
            String version = child.getVersion().getValue();
            Map props = child.getProperties();
            if (NutsBlankable.isBlank((String)repository)) {
                modified = true;
                repository = parent.getRepository();
            }
            if (NutsBlankable.isBlank((String)group)) {
                modified = true;
                group = parent.getGroupId();
            }
            if (NutsBlankable.isBlank((String)name)) {
                modified = true;
                name = parent.getArtifactId();
            }
            if (NutsBlankable.isBlank((String)version)) {
                modified = true;
                version = parent.getVersion().getValue();
            }
            if (!(parentFaceMap = parent.getProperties()).isEmpty()) {
                modified = true;
                props.putAll(parentFaceMap);
            }
            if (modified) {
                return NutsIdBuilder.of((NutsSession)ws).setRepository(repository).setGroupId(group).setArtifactId(name).setVersion(version).setProperties(props).build();
            }
        }
        return child;
    }

    public static boolean isValidIdentifier(String s) {
        if (s == null || s.length() == 0) {
            return false;
        }
        char[] c = s.toCharArray();
        if (!Character.isJavaIdentifierStart(c[0])) {
            return false;
        }
        for (int i = 1; i < c.length; ++i) {
            if (Character.isJavaIdentifierPart(c[i]) || c[i] == '-') continue;
            return false;
        }
        return true;
    }

    public static Map<String, Object> traceJsonNutsDefinition(NutsSession session, NutsDefinition def) {
        LinkedHashMap<String, Object> x = new LinkedHashMap<String, Object>();
        x.put("id", def.getId());
        if (def.getContent() != null) {
            if (def.getContent().getPath() != null) {
                x.put("path", def.getContent().getPath().toString());
            }
            x.put("cached", def.getContent().isCached());
            x.put("temporary", def.getContent().isTemporary());
        }
        if (def.getInstallInformation() != null) {
            if (def.getInstallInformation().getInstallFolder() != null) {
                x.put("install-folder", def.getInstallInformation().getInstallFolder());
            }
            x.put("install-status", def.getInstallInformation().getInstallStatus().toString());
            x.put("was-installed", def.getInstallInformation().isWasInstalled());
            x.put("was-required", def.getInstallInformation().isWasRequired());
        }
        if (def.getRepositoryName() != null) {
            x.put("repository-name", def.getRepositoryName());
        }
        if (def.getRepositoryUuid() != null) {
            x.put("repository-uuid", def.getRepositoryUuid());
        }
        if (def.getDescriptor() != null) {
            x.put("descriptor", def.getDescriptor().formatter().setSession(session).format());
            x.put("effective-descriptor", NutsWorkspaceUtils.of(session).getEffectiveDescriptor(def).formatter().setSession(session).format());
        }
        return x;
    }

    public static String[] nullArray_Locations(String[] a) {
        return CoreNutsUtils.nullArray(a, NutsStoreLocation.values().length);
    }

    public static String[] nullArray_LocationsAndOses(String[] a) {
        return CoreNutsUtils.nullArray(a, NutsStoreLocation.values().length * NutsOsFamily.values().length);
    }

    public static String[] nullArray(String[] a, int size) {
        if (a == null) {
            return null;
        }
        boolean ok = false;
        for (String string : a) {
            if (string == null) continue;
            ok = true;
            break;
        }
        if (ok) {
            if (a.length == size) {
                return a;
            }
            String[] aa = new String[size];
            System.arraycopy(a, 0, aa, 0, size);
            return aa;
        }
        return null;
    }

    public static String getArrItem(String[] a, int index) {
        return a == null || a.length <= index ? null : a[index];
    }

    public static String[] nonNullArray_Locations(String[] a) {
        return CoreNutsUtils.nonNullArray(a, NutsStoreLocation.values().length);
    }

    public static String[] nonNullArray_LocationsAndOses(String[] a) {
        return CoreNutsUtils.nonNullArray(a, NutsStoreLocation.values().length * NutsOsFamily.values().length);
    }

    public static String[] nonNullArray(String[] a, int size) {
        if (a == null) {
            return new String[size];
        }
        if (a.length == size) {
            return a;
        }
        String[] aa = new String[size];
        System.arraycopy(a, 0, aa, 0, size);
        return aa;
    }

    public static int getApiVersionOrdinalNumber(String s) {
        try {
            int qualifierIndex = s.indexOf(45);
            if (qualifierIndex >= 0) {
                s = s.substring(0, qualifierIndex);
            }
            int a = 0;
            for (String part : s.split("\\.")) {
                a = a * 100 + CoreNumberUtils.convertToInteger(part, 0);
            }
            return a;
        }
        catch (Exception ex) {
            return -1;
        }
    }

    public static boolean isValidWorkspaceName(String workspace) {
        if (NutsBlankable.isBlank((String)workspace)) {
            return true;
        }
        String workspaceName = workspace.trim();
        return workspaceName.matches("[^/\\\\]+") && !workspaceName.equals(".") && !workspaceName.equals("..");
    }

    public static String resolveValidWorkspaceName(String workspace) {
        if (NutsBlankable.isBlank((String)workspace)) {
            return "default-workspace";
        }
        String workspaceName = workspace.trim();
        if (workspaceName.matches("[^/\\\\]+") && !workspaceName.equals(".") && !workspaceName.equals("..")) {
            return workspaceName;
        }
        String p = null;
        try {
            p = new File(workspaceName).getCanonicalFile().getName();
        }
        catch (IOException ex) {
            p = new File(workspaceName).getAbsoluteFile().getName();
        }
        if (p.isEmpty() || p.equals(".") || p.equals("..")) {
            return "unknown";
        }
        return p;
    }

    public static String idToPath(NutsId id) {
        return id.getGroupId().replace('.', '/') + "/" + id.getArtifactId() + "/" + id.getVersion();
    }

    public static Properties copyOfNonNull(Properties p) {
        if (p == null) {
            return new Properties();
        }
        Properties p2 = new Properties();
        p2.putAll((Map<?, ?>)p);
        return p2;
    }

    public static Properties copyOfOrNull(Properties p) {
        if (p == null) {
            return null;
        }
        Properties p2 = new Properties();
        p2.putAll((Map<?, ?>)p);
        return p2;
    }

    public static boolean isUnsupportedFetchModeException(Throwable ex) {
        Object msg = null;
        if (ex instanceof NutsFetchModeNotSupportedException) {
            return true;
        }
        if (ex instanceof NutsNotFoundException && ex.getCause() != null) {
            Throwable ex2 = ex.getCause();
            return ex2 instanceof NutsFetchModeNotSupportedException;
        }
        return false;
    }

    public static NutsIdType detectIdType(NutsId depId, NutsSession session) {
        switch (depId.getShortName()) {
            case "net.thevpc.nuts:nuts": {
                return NutsIdType.API;
            }
            case "net.thevpc.nuts:nuts-runtime": {
                return NutsIdType.RUNTIME;
            }
        }
        String rt = session.getWorkspace().getRuntimeId().getShortName();
        if (rt.equals(depId.getShortName())) {
            return NutsIdType.RUNTIME;
        }
        for (NutsClassLoaderNode n : session.boot().getBootExtensionClassLoaderNode()) {
            if (!NutsId.of((String)n.getId(), (NutsSession)session).equalsShortId(depId)) continue;
            return NutsIdType.EXTENSION;
        }
        return NutsIdType.REGULAR;
    }

    public static List<NutsId> resolveNutsApiIds(NutsId id, NutsSession session) {
        List deps = session.fetch().setId(id).setDependencies(true).getResultDefinition().getDependencies().transitive().toList();
        return CoreNutsUtils.resolveNutsApiIds(deps.toArray(new NutsDependency[0]), session);
    }

    public static List<NutsId> resolveNutsApiIds(NutsDefinition def, NutsSession session) {
        return CoreNutsUtils.resolveNutsApiIds(def.getDependencies(), session);
    }

    public static List<NutsId> resolveNutsApiIds(NutsDependencies deps, NutsSession session) {
        return CoreNutsUtils.resolveNutsApiIds((NutsDependency[])deps.transitiveWithSource().toArray(NutsDependency[]::new), session);
    }

    public static List<NutsId> resolveNutsApiIds(NutsDependency[] deps, NutsSession session) {
        return Arrays.stream(deps).map(NutsDependency::toId).filter(x -> x.getShortName().equals("net.thevpc.nuts:nuts")).distinct().collect(Collectors.toList());
    }

    public static List<NutsId> resolveNutsApiIds(NutsId[] deps, NutsSession session) {
        return Arrays.stream(deps).filter(x -> x.getShortName().equals("net.thevpc.nuts:nuts")).distinct().collect(Collectors.toList());
    }

    static {
        _QUERY_EMPTY_ENV.put("arch", null);
        _QUERY_EMPTY_ENV.put("os", null);
        _QUERY_EMPTY_ENV.put("osdist", null);
        _QUERY_EMPTY_ENV.put("platform", null);
    }

    public static class NutsDefaultThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger poolNumber = new AtomicInteger(1);
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix;
        private final boolean daemon;

        NutsDefaultThreadFactory(String namePattern, boolean daemon) {
            this.daemon = daemon;
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = namePattern + "-" + CoreStringUtils.indexToString(poolNumber.getAndIncrement()) + "-";
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            t.setDaemon(this.daemon);
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }
}

