/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.util;

import java.math.BigInteger;
import net.thevpc.nuts.NutsBlankable;

public class CoreNumberUtils {
    public static Integer convertToInteger(String value, Integer defaultValue) {
        if (NutsBlankable.isBlank((String)value)) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (Exception ex) {
            return defaultValue;
        }
    }

    public static Long convertToLong(String value, Long defaultValue) {
        if (NutsBlankable.isBlank((String)value)) {
            return defaultValue;
        }
        try {
            return Long.parseLong(value);
        }
        catch (Exception ex) {
            return defaultValue;
        }
    }

    public static BigInteger convertToBigInteger(String value, BigInteger defaultValue) {
        if (NutsBlankable.isBlank((String)value)) {
            return defaultValue;
        }
        try {
            return new BigInteger(value);
        }
        catch (Exception ex) {
            return defaultValue;
        }
    }

    public static BigInteger getStartingBigInteger(String v1) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < v1.length(); ++i) {
            char c = v1.charAt(i);
            if (c < '0' || c > '9') continue;
            sb.append(c);
        }
        if (sb.length() > 0) {
            return new BigInteger(sb.toString());
        }
        return null;
    }

    public static int getStartingInt(String v1) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < v1.length(); ++i) {
            char c = v1.charAt(i);
            if (c < '0' || c > '9') continue;
            sb.append(c);
        }
        if (sb.length() > 0) {
            return Integer.parseInt(sb.toString());
        }
        return -1;
    }

    public static long getStartingLong(String v1) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < v1.length(); ++i) {
            char c = v1.charAt(i);
            if (c < '0' || c > '9') continue;
            sb.append(c);
        }
        if (sb.length() > 0) {
            return Long.parseLong(sb.toString());
        }
        return -1L;
    }

    public static boolean isInt(String s) {
        try {
            Integer.parseInt(s);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }
}

