/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.util;

import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.runtime.standalone.util.CoreStringUtils;

public class BytesSizeFormat {
    public static final long BYTE = 1L;
    public static final int KiBYTE = 1024;
    public static final int MiBYTE = 0x100000;
    public static final long GiBYTE = 0x40000000L;
    public static final long TiBYTE = 0x10000000000L;
    public static final long PiBYTE = 0x4000000000000L;
    public static final long EiBYTE = 0x1000000000000000L;
    public static final int DECA = 10;
    public static final int HECTO = 100;
    public static final int KILO = 1000;
    public static final int MEGA = 1000000;
    public static final long GIGA = 1000000000L;
    public static final long TERA = 1000000000000L;
    public static final long PETA = 1000000000000000L;
    public static final long EXA = 1000000000000000000L;
    public static final long ZETTA = 3875820019684212736L;
    public static final long YOTTA = 2003764205206896640L;
    boolean leadingZeros = false;
    boolean intermediateZeros = true;
    boolean trailingZeros = false;
    private boolean fixedLength = false;
    private boolean binaryPrefix = false;
    private long high = 1000000000000L;
    private long low = 1L;
    private int depth = Integer.MAX_VALUE;
    private NutsSession session;

    public BytesSizeFormat(boolean leadingZeros, boolean intermediateZeros, boolean fixedLength, boolean binaryPrefix, long high, long low, int depth, NutsSession session) {
        this.leadingZeros = leadingZeros;
        this.intermediateZeros = intermediateZeros;
        this.fixedLength = fixedLength;
        this.binaryPrefix = binaryPrefix;
        this.high = high;
        this.low = low;
        this.depth = depth <= 0 ? Integer.MAX_VALUE : depth;
        this.session = session;
    }

    public BytesSizeFormat(String format, NutsSession session) {
        this.session = session;
        this.leadingZeros = false;
        this.intermediateZeros = false;
        this.trailingZeros = false;
        char low = '\u0000';
        char high = '\u0000';
        if (format != null) {
            boolean startInterval = true;
            char[] charArray = format.toCharArray();
            block7: for (int i = 0; i < charArray.length; ++i) {
                char c = Character.toUpperCase(charArray[i]);
                switch (c) {
                    case 'B': 
                    case 'E': 
                    case 'G': 
                    case 'K': 
                    case 'M': 
                    case 'P': 
                    case 'T': 
                    case 'Y': 
                    case 'Z': {
                        if (startInterval) {
                            startInterval = false;
                            low = c;
                            continue block7;
                        }
                        high = c;
                        continue block7;
                    }
                    case 'I': {
                        this.binaryPrefix = true;
                        continue block7;
                    }
                    case 'D': {
                        this.depth = Character.isDigit(charArray[++i]) ? charArray[i] - 48 : -1;
                        if (this.depth <= 0 || this.depth > 9) {
                            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"invalid depth %s", (Object[])new Object[]{this.depth}));
                        }
                    }
                    case 'F': {
                        this.fixedLength = true;
                        continue block7;
                    }
                    case '0': {
                        if (i == 0) {
                            this.leadingZeros = true;
                            continue block7;
                        }
                        if (i == charArray.length - 1) {
                            this.trailingZeros = true;
                            continue block7;
                        }
                        this.intermediateZeros = true;
                        continue block7;
                    }
                    default: {
                        throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"unsupported %s", (Object[])new Object[]{Character.valueOf(c)}));
                    }
                }
            }
        }
        if (low == '\u0000') {
            low = 'B';
        }
        if (high == '\u0000') {
            high = 'T';
        }
        this.low = this.eval(low);
        this.high = this.eval(high);
        if (this.high < this.low) {
            long t = this.low;
            this.low = this.high;
            this.high = t;
        }
    }

    public String formatDouble(double value) {
        return this.format((long)value);
    }

    private long eval(char c) {
        switch (c) {
            case 'B': {
                return this.binaryPrefix ? 1L : 1L;
            }
            case 'K': {
                return this.binaryPrefix ? 1024L : 1000L;
            }
            case 'M': {
                return this.binaryPrefix ? 0x100000L : 1000000L;
            }
            case 'G': {
                return this.binaryPrefix ? 0x40000000L : 1000000000L;
            }
            case 'T': {
                return this.binaryPrefix ? 0x10000000000L : 1000000000000L;
            }
            case 'P': {
                return this.binaryPrefix ? 0x4000000000000L : 1000000000000000L;
            }
            case 'E': {
                return this.binaryPrefix ? 0x1000000000000000L : 1000000000000000000L;
            }
        }
        throw new IllegalArgumentException("Unsupported");
    }

    private String formatLeft(Object number, int size) {
        if (this.fixedLength) {
            return CoreStringUtils.alignLeft(String.valueOf(number == null ? "" : number), size);
        }
        return String.valueOf(number);
    }

    public String format(long bytes) {
        long v;
        StringBuilder sb = new StringBuilder();
        boolean neg = bytes < 0L;
        long r = v = bytes < 0L ? -bytes : bytes;
        int currDepth = -1;
        boolean empty = true;
        boolean leading = true;
        long K = this.eval('K');
        long M = this.eval('M');
        long G = this.eval('G');
        long T = this.eval('T');
        long P = this.eval('P');
        long E = this.eval('E');
        if (this.low <= E) {
            if (this.high >= E) {
                r = v / T;
                if (this.leadingZeros && leading || r > 0L || !empty && this.intermediateZeros && v % E > 0L || v == 0L && this.trailingZeros) {
                    currDepth = currDepth < 0 ? 1 : ++currDepth;
                    if (currDepth <= this.depth) {
                        if (sb.length() > 0) {
                            sb.append(" ");
                        }
                        sb.append(this.formatLeft(r, 3)).append(this.binaryPrefix ? "Ei" : "E");
                        if (r != 0L) {
                            leading = false;
                        }
                        v %= E;
                        empty = false;
                    }
                }
            }
            if (this.high >= P) {
                r = v / T;
                if (this.leadingZeros && leading || r > 0L || !empty && this.intermediateZeros && v % P > 0L || v == 0L && this.trailingZeros) {
                    currDepth = currDepth < 0 ? 1 : ++currDepth;
                    if (currDepth <= this.depth) {
                        if (sb.length() > 0) {
                            sb.append(" ");
                        }
                        sb.append(this.formatLeft(r, 3)).append(this.binaryPrefix ? "Pi" : "P");
                        if (r != 0L) {
                            leading = false;
                        }
                        v %= P;
                        empty = false;
                    }
                }
            }
            if (this.high >= T) {
                r = v / T;
                if (this.leadingZeros && leading || r > 0L || !empty && this.intermediateZeros && v % T > 0L || v == 0L && this.trailingZeros) {
                    currDepth = currDepth < 0 ? 1 : ++currDepth;
                    if (currDepth <= this.depth) {
                        if (sb.length() > 0) {
                            sb.append(" ");
                        }
                        sb.append(this.formatLeft(r, 3)).append(this.binaryPrefix ? "Ti" : "T");
                        if (r != 0L) {
                            leading = false;
                        }
                        v %= T;
                        empty = false;
                    }
                }
            }
            if (this.low <= G) {
                if (this.high >= G) {
                    r = v / G;
                }
                if (this.leadingZeros && leading || r > 0L || !empty && this.intermediateZeros && v % G > 0L || v == 0L && this.trailingZeros) {
                    currDepth = currDepth < 0 ? 1 : ++currDepth;
                    if (currDepth <= this.depth) {
                        if (sb.length() > 0) {
                            sb.append(" ");
                        }
                        if (r != 0L) {
                            leading = false;
                        }
                        sb.append(this.formatLeft(r, 3)).append(this.binaryPrefix ? "Gi" : "G");
                        v %= G;
                        empty = false;
                    }
                }
                if (this.low <= M) {
                    if (this.high >= M) {
                        r = v / M;
                        if (this.leadingZeros && leading || r > 0L || !empty && this.intermediateZeros && v % M > 0L || v == 0L && this.trailingZeros) {
                            currDepth = currDepth < 0 ? 1 : ++currDepth;
                            if (currDepth <= this.depth) {
                                if (sb.length() > 0) {
                                    sb.append(" ");
                                }
                                if (r != 0L) {
                                    leading = false;
                                }
                                sb.append(this.formatLeft(r, 3)).append(this.binaryPrefix ? "Mi" : "M");
                                v %= M;
                                empty = false;
                            }
                        }
                    }
                    if (this.low <= K) {
                        if (this.high >= K) {
                            r = v / K;
                            if (this.leadingZeros && leading || r > 0L || !empty && this.intermediateZeros && v % K > 0L || v == 0L && this.trailingZeros) {
                                currDepth = currDepth < 0 ? 1 : ++currDepth;
                                if (currDepth <= this.depth) {
                                    if (sb.length() > 0) {
                                        sb.append(" ");
                                    }
                                    if (r != 0L) {
                                        leading = false;
                                    }
                                    sb.append(this.formatLeft(r, 3)).append("K").append(this.binaryPrefix ? "i" : "");
                                    v %= K;
                                    empty = false;
                                }
                            }
                        }
                        if (this.low <= 1L && (this.leadingZeros && leading || v > 0L || sb.length() == 0)) {
                            currDepth = currDepth < 0 ? 1 : ++currDepth;
                            if (currDepth <= this.depth) {
                                if (sb.length() > 0) {
                                    sb.append(" ");
                                }
                                if (r != 0L) {
                                    leading = false;
                                }
                                sb.append(this.formatLeft(v, 3)).append(this.binaryPrefix ? "B " : "B");
                                empty = false;
                            }
                        }
                    }
                }
            }
        }
        if (sb.length() == 0) {
            if (neg) {
                sb.insert(0, "-");
            }
            if (this.low >= T) {
                sb.append(this.formatLeft(0, 3)).append(this.binaryPrefix ? "Ti" : "T");
            } else if (this.low >= G) {
                sb.append(this.formatLeft(0, 3)).append(this.binaryPrefix ? "Gi" : "G");
            } else if (this.low >= M) {
                sb.append(this.formatLeft(0, 3)).append(this.binaryPrefix ? "Mi" : "M");
            } else if (this.low >= K) {
                sb.append(this.formatLeft(0, 3)).append(this.binaryPrefix ? "Ki" : "K");
                sb.append(this.formatLeft(0, 3)).append(this.binaryPrefix ? "B " : "B");
            }
        } else if (neg) {
            sb.insert(0, "-");
        }
        return sb.toString();
    }
}

