/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.text.util;

import java.lang.reflect.Array;
import java.time.Instant;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.thevpc.nuts.NutsArrayElement;
import net.thevpc.nuts.NutsElement;
import net.thevpc.nuts.NutsElementEntry;
import net.thevpc.nuts.NutsElementType;
import net.thevpc.nuts.NutsFormattable;
import net.thevpc.nuts.NutsObjectElement;
import net.thevpc.nuts.NutsPrimitiveElement;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsString;
import net.thevpc.nuts.NutsTextBuilder;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsTexts;
import net.thevpc.nuts.runtime.standalone.util.CoreNutsUtils;
import net.thevpc.nuts.runtime.standalone.util.CoreStringUtils;

public class NutsTextUtils {
    public static NutsString stringValueFormatted(Object o, boolean escapeString, NutsSession session) {
        ArrayList<Object> all;
        Object[] a;
        Object c;
        NutsTexts txt = NutsTexts.of((NutsSession)session);
        if (o == null) {
            return txt.ofBlank();
        }
        if (o instanceof NutsFormattable) {
            return txt.toText(o);
        }
        if (o instanceof NutsPrimitiveElement) {
            o = ((NutsPrimitiveElement)o).getValue();
        } else if (o instanceof NutsArrayElement) {
            o = ((NutsArrayElement)o).children();
        } else {
            if (o instanceof NutsObjectElement) {
                Collection c2 = ((NutsObjectElement)o).children();
                Object[] a2 = c2.toArray();
                if (a2.length == 0) {
                    return txt.ofBlank();
                }
                if (a2.length == 1) {
                    return txt.ofPlain(CoreStringUtils.stringValue(a2[0]));
                }
                return txt.builder().append((Object)"{").appendJoined((Object)txt.ofPlain(", "), (Collection)c2.stream().map(x -> NutsTextUtils.stringValueFormatted(x, escapeString, session)).collect(Collectors.toList())).append((Object)"}");
            }
            if (o instanceof NutsElementEntry) {
                NutsElementEntry ne = (NutsElementEntry)o;
                NutsTextBuilder sb = NutsTexts.of((NutsSession)session).builder();
                sb.append((Object)NutsTextUtils.stringValueFormatted(ne.getKey(), escapeString, session));
                sb.append((Object)"=");
                if (ne.getValue().type() == NutsElementType.STRING) {
                    sb.append(txt.toText((Object)CoreStringUtils.dblQuote(NutsTextUtils.stringValueFormatted(ne.getValue(), escapeString, session).toString())));
                } else {
                    sb.append((Object)NutsTextUtils.stringValueFormatted(ne.getValue(), escapeString, session));
                }
                o = sb.toString();
            } else {
                if (o instanceof Map.Entry) {
                    Map.Entry ne = (Map.Entry)o;
                    NutsTextBuilder sb = NutsTexts.of((NutsSession)session).builder();
                    sb.append((Object)NutsTextUtils.stringValueFormatted(ne.getKey(), escapeString, session));
                    sb.append((Object)"=");
                    if (ne.getValue() instanceof String || ne.getValue() instanceof NutsElement && ((NutsElement)ne.getValue()).isString()) {
                        sb.append(txt.toText((Object)CoreStringUtils.dblQuote(NutsTextUtils.stringValueFormatted(ne.getValue(), escapeString, session).toString())));
                    } else {
                        sb.append((Object)NutsTextUtils.stringValueFormatted(ne.getValue(), escapeString, session));
                    }
                    return sb.immutable();
                }
                if (o instanceof Map) {
                    o = ((Map)o).entrySet();
                }
            }
        }
        if (o == null) {
            return txt.ofBlank();
        }
        if (o instanceof Instant) {
            return txt.ofPlain(CoreNutsUtils.DEFAULT_DATE_TIME_FORMATTER.format((Instant)o));
        }
        if (o instanceof Temporal) {
            return txt.ofPlain(CoreNutsUtils.DEFAULT_DATE_TIME_FORMATTER.format((Temporal)o));
        }
        if (o instanceof Date) {
            return txt.ofPlain(CoreNutsUtils.DEFAULT_DATE_TIME_FORMATTER.format(((Date)o).toInstant()));
        }
        if (o instanceof Collection) {
            c = (Collection)o;
            a = c.toArray();
            if (a.length == 0) {
                return txt.ofBlank();
            }
            if (a.length == 1) {
                return txt.ofPlain(CoreStringUtils.stringValue(a[0]));
            }
            List ll = c.stream().map(x -> NutsTextUtils.stringValueFormatted(x, escapeString, session)).collect(Collectors.toList());
            return txt.builder().append((Object)"[").appendJoined((Object)txt.ofPlain(", "), ll).append((Object)"]");
        }
        if (o instanceof Map) {
            c = (Map)o;
            a = c.entrySet().toArray(new Map.Entry[0]);
            if (a.length == 0) {
                return txt.ofBlank();
            }
            if (a.length == 1) {
                return txt.ofPlain(CoreStringUtils.stringValue(a[0]));
            }
            List ll = Arrays.stream(a).map(x -> NutsTextUtils.stringValueFormatted(x, escapeString, session)).collect(Collectors.toList());
            return txt.builder().append((Object)"{").appendJoined((Object)txt.ofPlain(", "), ll).append((Object)"}");
        }
        if (o.getClass().isArray()) {
            int len = Array.getLength(o);
            if (len == 0) {
                return txt.ofBlank();
            }
            if (len == 1) {
                return NutsTextUtils.stringValueFormatted(Array.get(o, 0), escapeString, session);
            }
            all = new ArrayList(len);
            for (int i = 0; i < len; ++i) {
                all.add(NutsTextUtils.stringValueFormatted(Array.get(o, i), escapeString, session));
            }
            return txt.builder().append((Object)"[").appendJoined((Object)txt.ofPlain(", "), all).append((Object)"]");
        }
        if (o instanceof Iterator) {
            Iterator x2 = (Iterator)o;
            all = new ArrayList<Object>();
            while (x2.hasNext()) {
                all.add(NutsTextUtils.stringValueFormatted(x2.next(), escapeString, session).toString());
            }
            return NutsTextUtils.stringValueFormatted(all, escapeString, session);
        }
        return txt.toText(o);
    }

    public static NutsString formatLogValue(NutsTexts text, Object unresolved, Object resolved) {
        NutsString b;
        NutsString a = NutsTextUtils.desc(unresolved, text);
        if (a.equals(b = NutsTextUtils.desc(resolved, text))) {
            return a;
        }
        return text.builder().append((Object)a).append((Object)" => ").append((Object)b);
    }

    public static NutsString desc(Object s, NutsTexts text) {
        if (s == null || s instanceof String && ((String)s).isEmpty()) {
            return text.ofStyled("<EMPTY>", NutsTextStyle.option());
        }
        return text.toText(s);
    }
}

