/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.text.theme;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import java.util.UUID;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsIOException;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsStoreLocation;
import net.thevpc.nuts.NutsTextFormatTheme;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsTextStyleType;
import net.thevpc.nuts.NutsTextStyles;
import net.thevpc.nuts.runtime.standalone.util.CoreNumberUtils;
import net.thevpc.nuts.runtime.standalone.xtra.expr.StringReaderExt;

public class NutsTextFormatPropertiesTheme
implements NutsTextFormatTheme {
    private final Properties props;
    private final NutsSession session;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NutsTextFormatPropertiesTheme(String name, ClassLoader cls, NutsSession session) {
        block38: {
            URL u;
            this.props = new Properties();
            this.session = session;
            if (name.indexOf(47) >= 0 || name.indexOf(92) >= 0) {
                try (InputStream is = NutsPath.of((String)name, (NutsSession)session).getInputStream();){
                    this.props.load(is);
                    break block38;
                }
                catch (IOException e) {
                    throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"invalid theme: %s", (Object[])new Object[]{name}), (Throwable)e);
                }
            }
            if (cls == null) {
                cls = this.getClass().getClassLoader();
            }
            if ((u = cls.getResource("META-INF/ntf-themes/" + name + ".ntf-theme")) != null) {
                try {
                    InputStream inStream = null;
                    inStream = u.openStream();
                    if (inStream == null) {
                        throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"invalid theme: %s", (Object[])new Object[]{name}));
                    }
                    try {
                        this.props.load(inStream);
                        break block38;
                    }
                    finally {
                        inStream.close();
                    }
                }
                catch (IOException e) {
                    throw new NutsIOException(session, (Throwable)e);
                }
            }
            NutsPath themeFile = session.locations().getStoreLocation(NutsId.of((String)"net.thevpc.nuts:nuts-runtime#SHARED", (NutsSession)session), NutsStoreLocation.CONFIG).resolve("themes").resolve(name);
            if (themeFile.isRegularFile()) {
                try (InputStream inStream = themeFile.getInputStream();){
                    this.props.load(inStream);
                    break block38;
                }
                catch (IOException e) {
                    throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"invalid theme: %s", (Object[])new Object[]{name}), (Throwable)e);
                }
            }
            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"invalid theme: %s", (Object[])new Object[]{name}));
        }
    }

    public String getName() {
        String themeName = this.props.getProperty("theme-name");
        if (NutsBlankable.isBlank((String)themeName)) {
            themeName = UUID.randomUUID().toString();
            this.props.put("theme-name", themeName);
        }
        return themeName;
    }

    public NutsTextStyles toBasicStyles(NutsTextStyles styles, NutsSession session) {
        NutsTextStyles ret = NutsTextStyles.PLAIN;
        if (styles != null) {
            for (NutsTextStyle style : styles) {
                ret = ret.append(this.toBasicStyles(style, session));
            }
        }
        return ret;
    }

    private String getProp(NutsTextStyleType t, int variant) {
        String v = this.getProp(t, "" + variant);
        if (v != null) {
            return v;
        }
        v = this.getProp(t, "*");
        if (v != null) {
            StringReaderExt r = new StringReaderExt(v);
            StringBuilder sb = new StringBuilder();
            while (r.hasNext()) {
                if (r.peekChar() == '*') {
                    if (r.hasNext(1) && r.peekChar(1) == '%') {
                        r.nextChar();
                        r.nextChar();
                        StringBuilder mod = new StringBuilder();
                        while (r.hasNext() && r.peekChar() >= '0' && r.peekChar() <= '9') {
                            mod.append(r.nextChar());
                        }
                        sb.append(variant % CoreNumberUtils.convertToInteger(mod.toString(), 1));
                        continue;
                    }
                    r.nextChar();
                    sb.append(variant);
                    continue;
                }
                sb.append(r.nextChar());
            }
            return sb.toString();
        }
        return v;
    }

    private int getVarValAsInt(String n) {
        return CoreNumberUtils.convertToInteger(this.props.getProperty(n), 0);
    }

    private String getProp(NutsTextStyleType t, String variant) {
        String name = t.name();
        String s = this.props.getProperty(name + "(" + variant + ")");
        if (s == null) {
            s = this.props.getProperty(name.toLowerCase() + "(" + variant + ")");
        }
        return s;
    }

    public NutsTextStyles toBasicStyles(NutsTextStyle style, NutsSession session) {
        return this.toBasicStyles(style, session, 20);
    }

    public NutsTextStyles toBasicStyles(NutsTextStyle style, NutsSession session, int maxLoop) {
        if (maxLoop <= 0) {
            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"invalid ntf theme for %s(%s). infinite loop", (Object[])new Object[]{style.getType(), style.getVariant()}));
        }
        if (style.getType().basic()) {
            return NutsTextStyles.of((NutsTextStyle)style);
        }
        String s = this.getProp(style.getType(), style.getVariant());
        if (s == null) {
            return NutsTextStyles.PLAIN;
        }
        NutsTextStyles ret = NutsTextStyles.PLAIN;
        for (String v : s.split(",")) {
            NutsTextStyles ss = this.toBasicStyles(v, style.getVariant(), session, maxLoop - 1);
            ret = ret.append(ss);
        }
        return ret;
    }

    public NutsTextStyles toBasicStyles(String v, int defaultVariant, NutsSession session, int maxLoop) {
        NutsTextStyleType st;
        int b;
        v = v.trim();
        int a = v.indexOf(40);
        String n = "";
        String k = v;
        if (a > 0 && (b = v.indexOf(41, a)) > 0) {
            n = v.substring(a + 1, b);
            k = v.substring(0, a);
        }
        n = n.trim();
        k = k.trim();
        if (n.equals("*") || n.isEmpty()) {
            n = "" + defaultVariant;
        }
        if ((st = NutsTextStyleType.parseLenient((String)k, null)) == null) {
            if (NutsBlankable.isBlank((String)n)) {
                return NutsTextStyles.PLAIN;
            }
            String z = this.props.getProperty(n);
            if (z != null) {
                if (maxLoop < 0) {
                    return null;
                }
                return this.toBasicStyles(z, defaultVariant, session, maxLoop - 1);
            }
            return NutsTextStyles.PLAIN;
        }
        switch (st) {
            case PLAIN: {
                return NutsTextStyles.of((NutsTextStyle)NutsTextStyle.of((NutsTextStyleType)st, (int)0));
            }
            case FORE_COLOR: 
            case FORE_TRUE_COLOR: 
            case BACK_COLOR: 
            case BACK_TRUE_COLOR: {
                Integer ii = CoreNumberUtils.convertToInteger(n, null);
                if (ii == null) {
                    ii = this.getVarValAsInt(n);
                }
                return NutsTextStyles.of((NutsTextStyle)NutsTextStyle.of((NutsTextStyleType)st, (int)ii));
            }
        }
        Integer ii = CoreNumberUtils.convertToInteger(n, null);
        if (ii == null) {
            ii = this.getVarValAsInt(n);
        }
        return this.toBasicStyles(NutsTextStyle.of((NutsTextStyleType)st, (int)ii), session, maxLoop);
    }
}

