/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.text.parser.steps;

import java.util.ArrayList;
import java.util.List;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsText;
import net.thevpc.nuts.NutsTexts;
import net.thevpc.nuts.runtime.standalone.text.DefaultNutsTexts;
import net.thevpc.nuts.runtime.standalone.text.parser.DefaultNutsTextNodeParser;
import net.thevpc.nuts.runtime.standalone.text.parser.steps.ParserStep;
import net.thevpc.nuts.runtime.standalone.util.CoreStringUtils;

public class TitleParserStep
extends ParserStep {
    StringBuilder start = new StringBuilder();
    List<ParserStep> children = new ArrayList<ParserStep>();
    private NutsSession session;

    public TitleParserStep(String c, NutsSession session) {
        this.start.append(c);
        this.session = session;
    }

    @Override
    public void consume(char c, DefaultNutsTextNodeParser.State p, boolean wasNewLine) {
        if (c == ' ' && this.children.isEmpty()) {
            this.start.append(c);
        } else if (c == '\n' || c == '\r') {
            p.applyPopReplay(c);
        } else {
            p.applyPush(c, false, false, false);
        }
    }

    @Override
    public void appendChild(ParserStep tt) {
        this.children.add(tt);
    }

    @Override
    public NutsText toText() {
        String s = this.start.toString();
        DefaultNutsTexts factory0 = (DefaultNutsTexts)NutsTexts.of((NutsSession)this.session);
        String s0 = s.trim();
        NutsText child = null;
        if (this.children.size() == 1) {
            child = this.children.get(0).toText();
        } else {
            ArrayList<NutsText> all = new ArrayList<NutsText>();
            for (ParserStep a : this.children) {
                all.add(a.toText());
            }
            child = NutsTexts.of((NutsSession)this.session).ofList(all).simplify();
        }
        return factory0.createTitle(s, s0.length() - 1, child, this.isComplete());
    }

    @Override
    public void end(DefaultNutsTextNodeParser.State p) {
        p.applyPop();
    }

    @Override
    public boolean isComplete() {
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Title(" + CoreStringUtils.dblQuote(this.start.toString()));
        for (ParserStep parserStep : this.children) {
            sb.append(",");
            sb.append(parserStep.toString());
        }
        return sb.append(")").toString();
    }
}

