/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.text.parser.steps;

import java.util.ArrayList;
import java.util.List;
import java.util.function.IntPredicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsText;
import net.thevpc.nuts.NutsTextPlain;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsTextStyles;
import net.thevpc.nuts.NutsTexts;
import net.thevpc.nuts.NutsUnsupportedEnumException;
import net.thevpc.nuts.runtime.standalone.text.parser.DefaultNutsTextNodeParser;
import net.thevpc.nuts.runtime.standalone.text.parser.DefaultNutsTextPlain;
import net.thevpc.nuts.runtime.standalone.text.parser.steps.ParserStep;
import net.thevpc.nuts.runtime.standalone.text.parser.steps.StyledParserStepCommandParser;
import net.thevpc.nuts.runtime.standalone.text.parser.steps.TitleParserStep;
import net.thevpc.nuts.runtime.standalone.util.CoreStringUtils;
import net.thevpc.nuts.runtime.standalone.util.NutsDebugString;
import net.thevpc.nuts.runtime.standalone.util.StringBuilder2;
import net.thevpc.nuts.runtime.standalone.util.collections.EvictingCharQueue;

public class StyledParserStep
extends ParserStep {
    public static final IntPredicate EXIT_ON_CLOSE_ACCOLADES = cc -> cc == 125 || cc == 35;
    private static Pattern NAME_AND_NUMBER = Pattern.compile("^(?<n>[a-zA-Z_-]+)(?<d>[0-9]*)$");
    int sharpsStartCount = 0;
    int sharpsEndCount = 0;
    CurState curState = CurState.EMPTY;
    List<NutsText> children = new ArrayList<NutsText>();
    StringBuilder2 name = new StringBuilder2();
    StringBuilder2 content = new StringBuilder2();
    boolean lineStart;
    int maxSize = 10;
    private NutsSession session;
    private EvictingCharQueue charQueue = new EvictingCharQueue(5);
    private DefaultNutsTextNodeParser.State state;
    private StyledParserStepCommandParser parseHelper = new StyledParserStepCommandParser();
    private boolean wasEscape;
    private boolean exitOnBrace;

    public StyledParserStep(char c, boolean lineStart, NutsSession session, DefaultNutsTextNodeParser.State state, boolean exitOnBrace) {
        switch (c) {
            case '#': {
                this.curState = CurState.SHARP;
                this.sharpsStartCount = 1;
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid");
            }
        }
        this.lineStart = lineStart;
        this.session = session;
        this.state = state;
        this.exitOnBrace = exitOnBrace;
    }

    public StyledParserStep(String c, boolean lineStart, NutsSession session, DefaultNutsTextNodeParser.State state, boolean exitOnBrace) {
        this.session = session;
        if (c.charAt(0) == '#') {
            this.curState = CurState.SHARP;
            this.sharpsStartCount = 1;
            for (int i = 1; i < c.length(); ++i) {
                this.consume(c.charAt(i), state, false);
            }
        } else {
            throw new IllegalArgumentException("unsupported");
        }
        this.lineStart = lineStart;
        this.state = state;
        this.exitOnBrace = exitOnBrace;
    }

    @Override
    public void consume(char c, DefaultNutsTextNodeParser.State state, boolean wasNewLine) {
        this.charQueue.add(c);
        NutsTexts text = NutsTexts.of((NutsSession)this.session);
        block0 : switch (this.curState) {
            case EMPTY: {
                throw new IllegalArgumentException("unexpected");
            }
            case SHARP: {
                switch (c) {
                    case '\\': {
                        this.wasEscape = true;
                        if (this.sharpsStartCount == 1) {
                            this.beforeChangingStep();
                            state.applyDropReplacePreParsedPlain("#", this.exitOnBrace);
                            break block0;
                        }
                        this.curState = CurState.SHARP_CONTENT;
                        break block0;
                    }
                    case '#': {
                        ++this.sharpsStartCount;
                        break block0;
                    }
                    case ')': {
                        this.beforeChangingStep();
                        state.applyDropReplace(new TitleParserStep(CoreStringUtils.fillString("#", this.sharpsStartCount) + ")", this.session));
                        break block0;
                    }
                    case '\u001e': {
                        this.beforeChangingStep();
                        state.applyDropReplacePreParsedPlain(CoreStringUtils.fillString("#", this.sharpsStartCount), this.exitOnBrace);
                        break block0;
                    }
                    case ':': {
                        if (this.sharpsStartCount == 2) {
                            this.curState = CurState.SHARP2_COL_NAME;
                            break block0;
                        }
                        this.content.append(c);
                        this.curState = CurState.SHARP_CONTENT;
                        break block0;
                    }
                    case '{': {
                        if (this.sharpsStartCount == 2) {
                            this.curState = CurState.SHARP2_OBRACE_NAME;
                            break block0;
                        }
                        this.content.append(c);
                        this.curState = CurState.SHARP_CONTENT;
                        break block0;
                    }
                }
                if (c == '}' && this.exitOnBrace) {
                    state.applyDropReplacePreParsedPlain(CoreStringUtils.fillString("#", this.sharpsStartCount), false);
                    state.applyPop();
                    state.applyNextChar(c);
                    break;
                }
                if (this.sharpsStartCount == 1) {
                    this.beforeChangingStep();
                    state.applyDropReplacePreParsedPlain(CoreStringUtils.fillString("#", this.sharpsStartCount), this.exitOnBrace);
                    state.applyNextChar(c);
                    break;
                }
                this.content.append(c);
                this.curState = CurState.SHARP_CONTENT;
                break;
            }
            case SHARP2_COL_NAME_CONTENT: 
            case SHARP_CONTENT: {
                switch (c) {
                    case '\\': {
                        if (this.wasEscape) {
                            this.wasEscape = false;
                            this.content.append(c);
                            break;
                        }
                        this.wasEscape = true;
                        break;
                    }
                    case '#': {
                        if (this.wasEscape) {
                            this.wasEscape = false;
                            this.content.append(c);
                            break;
                        }
                        if (!this.content.isEmpty()) {
                            this.children.add((NutsText)text.ofPlain(this.content.readAll()));
                        }
                        if (this.curState == CurState.SHARP_CONTENT) {
                            this.curState = CurState.SHARP_CONTENT_SHARP;
                        } else if (this.curState == CurState.SHARP2_COL_NAME_CONTENT) {
                            this.curState = CurState.SHARP2_COL_NAME_CONTENT_SHARP;
                        } else {
                            throw new IllegalArgumentException("unexpected");
                        }
                        this.sharpsEndCount = 1;
                        break;
                    }
                    case '`': {
                        if (this.wasEscape) {
                            this.wasEscape = false;
                            this.content.append(c);
                            break;
                        }
                        if (!this.content.isEmpty()) {
                            this.children.add((NutsText)text.ofPlain(this.content.readAll()));
                        }
                        this.beforeChangingStep();
                        state.applyPush(c, true, false, this.exitOnBrace);
                        break;
                    }
                    case '\u001e': {
                        if (!this.wasEscape) break block0;
                        this.wasEscape = false;
                        this.content.append(c);
                        break;
                    }
                    default: {
                        if (this.wasEscape) {
                            this.wasEscape = false;
                            this.content.append('\\');
                            this.content.append(c);
                            break;
                        }
                        this.content.append(c);
                        break;
                    }
                }
                break;
            }
            case SHARP_CONTENT_SHARP: 
            case SHARP2_COL_NAME_CONTENT_SHARP: {
                switch (c) {
                    case '\\': {
                        if (this.sharpsStartCount == this.sharpsEndCount) {
                            if (this.curState == CurState.SHARP_CONTENT_SHARP) {
                                this.curState = CurState.SHARP_CONTENT_SHARP_END;
                            } else if (this.curState == CurState.SHARP2_COL_NAME_CONTENT_SHARP) {
                                this.curState = CurState.SHARP2_COL_NAME_CONTENT_SHARP_END;
                            }
                            state.applyPopReplay(c);
                        } else {
                            this.content.append(CoreStringUtils.fillString("#", this.sharpsEndCount));
                            this.sharpsEndCount = 0;
                            if (this.curState == CurState.SHARP_CONTENT_SHARP) {
                                this.curState = CurState.SHARP_CONTENT;
                            } else if (this.curState == CurState.SHARP2_COL_NAME_CONTENT_SHARP) {
                                this.curState = CurState.SHARP2_COL_NAME_CONTENT;
                            }
                            this.wasEscape = true;
                        }
                    }
                    case '#': {
                        ++this.sharpsEndCount;
                        break;
                    }
                    case '\u001e': {
                        if (this.sharpsStartCount == this.sharpsEndCount) {
                            if (this.curState == CurState.SHARP_CONTENT_SHARP) {
                                this.curState = CurState.SHARP_CONTENT_SHARP_END;
                            } else if (this.curState == CurState.SHARP2_COL_NAME_CONTENT_SHARP) {
                                this.curState = CurState.SHARP2_COL_NAME_CONTENT_SHARP_END;
                            }
                            state.applyPop();
                            break;
                        }
                        this.logErr("expected " + CoreStringUtils.fillString("#", this.sharpsStartCount) + "<END>");
                        this.sharpsEndCount = 0;
                        this.children.add((NutsText)text.ofPlain(CoreStringUtils.fillString("#", this.sharpsStartCount)));
                        if (this.curState == CurState.SHARP_CONTENT_SHARP) {
                            this.curState = CurState.SHARP_CONTENT_SHARP_END;
                            break;
                        }
                        if (this.curState != CurState.SHARP2_COL_NAME_CONTENT_SHARP) break block0;
                        this.curState = CurState.SHARP2_COL_NAME_CONTENT_SHARP_END;
                        break;
                    }
                    default: {
                        if (this.sharpsStartCount == this.sharpsEndCount) {
                            if (this.curState == CurState.SHARP_CONTENT_SHARP) {
                                this.curState = CurState.SHARP_CONTENT_SHARP_END;
                            } else if (this.curState == CurState.SHARP2_COL_NAME_CONTENT_SHARP) {
                                this.curState = CurState.SHARP2_COL_NAME_CONTENT_SHARP_END;
                            }
                            state.applyPopReplay(c);
                            break;
                        }
                        if (this.curState == CurState.SHARP_CONTENT_SHARP) {
                            this.curState = CurState.SHARP_CONTENT;
                        } else if (this.curState == CurState.SHARP2_COL_NAME_CONTENT_SHARP) {
                            this.curState = CurState.SHARP2_COL_NAME_CONTENT;
                        }
                        this.sharpsEndCount = 0;
                        this.beforeChangingStep();
                        state.applyPush(new StyledParserStep("#", false, this.session, state, false));
                        for (int i = 0; i < this.sharpsEndCount - 1; ++i) {
                            state.applyNextChar('#');
                        }
                        state.applyNextChar(c);
                        break;
                    }
                }
                break;
            }
            case SHARP2_OBRACE_NAME: 
            case SHARP2_COL_NAME: {
                switch (c) {
                    case '\\': {
                        if (this.wasEscape) {
                            this.wasEscape = false;
                            this.name.append(c);
                            break block0;
                        }
                        this.wasEscape = true;
                        break block0;
                    }
                    case ':': {
                        if (this.wasEscape) {
                            this.wasEscape = false;
                            this.name.append(c);
                            break block0;
                        }
                        if (this.curState == CurState.SHARP2_COL_NAME) {
                            this.curState = CurState.SHARP2_COL_NAME_CONTENT;
                            break block0;
                        }
                        this.curState = CurState.SHARP2_OBRACE_NAME_COL_CONTENT;
                        break block0;
                    }
                    case '\u001e': 
                    case '#': 
                    case '(': 
                    case ')': 
                    case '[': 
                    case ']': 
                    case '{': 
                    case '}': {
                        if (this.wasEscape) {
                            this.wasEscape = false;
                            if (c == '\u001e') {
                                this.name.append(c);
                                break block0;
                            }
                            this.name.append('\\');
                            this.name.append(c);
                            break block0;
                        }
                        this.logErr("expected ':'");
                        if (this.curState == CurState.SHARP2_COL_NAME) {
                            this.curState = CurState.SHARP2_COL_NAME_CONTENT;
                            break block0;
                        }
                        this.curState = CurState.SHARP2_OBRACE_NAME_COL_CONTENT;
                        break block0;
                    }
                }
                if (this.wasEscape) {
                    if (c <= ' ' || c == ':' || c == '#') {
                        this.name.append(c);
                    } else {
                        this.name.append('\\');
                        this.name.append(c);
                    }
                    this.wasEscape = false;
                    break;
                }
                if (c <= ' ') {
                    if (this.name.isEmpty()) break;
                    if (this.curState == CurState.SHARP2_COL_NAME) {
                        this.curState = CurState.SHARP2_COL_NAME_CONTENT;
                        break;
                    }
                    this.curState = CurState.SHARP2_OBRACE_NAME_COL_CONTENT;
                    break;
                }
                this.name.append(c);
                break;
            }
            case SHARP2_OBRACE_NAME_COL_CONTENT: {
                switch (c) {
                    case '#': {
                        if (this.wasEscape) {
                            this.wasEscape = false;
                            this.content.append(c);
                            break;
                        }
                        if (!this.content.isEmpty()) {
                            this.children.add((NutsText)text.ofPlain(this.content.readAll()));
                        }
                        this.beforeChangingStep();
                        state.applyPush(new StyledParserStep("#", false, this.session, state, true));
                        break;
                    }
                    case '}': {
                        if (this.wasEscape) {
                            this.wasEscape = false;
                            this.content.append(c);
                            break;
                        }
                        if (!this.content.isEmpty()) {
                            this.children.add((NutsText)text.ofPlain(this.content.readAll()));
                        }
                        this.curState = CurState.SHARP2_OBRACE_NAME_COL_CONTENT_CBRACE;
                        break;
                    }
                    case '\u001e': {
                        if (this.wasEscape) {
                            this.wasEscape = false;
                            this.content.append(c);
                            break;
                        }
                        if (this.content.isEmpty()) break block0;
                        this.children.add((NutsText)text.ofPlain(this.content.readAll()));
                        break;
                    }
                    case '`': {
                        if (this.wasEscape) {
                            this.wasEscape = false;
                            this.content.append(c);
                            break;
                        }
                        if (!this.content.isEmpty()) {
                            this.children.add((NutsText)text.ofPlain(this.content.readAll()));
                        }
                        this.beforeChangingStep();
                        state.applyPush(c, true, false, this.exitOnBrace);
                        break;
                    }
                    default: {
                        if (this.wasEscape) {
                            this.wasEscape = false;
                            this.content.append('\\');
                            this.content.append(c);
                            break;
                        }
                        this.content.append(c);
                        break;
                    }
                }
                break;
            }
            case SHARP2_OBRACE_NAME_COL_CONTENT_CBRACE: {
                switch (c) {
                    case '\\': {
                        this.content.append('{');
                        this.curState = CurState.SHARP2_OBRACE_NAME_COL_CONTENT;
                        this.wasEscape = true;
                        break block0;
                    }
                    case '#': {
                        ++this.sharpsEndCount;
                        this.curState = CurState.SHARP2_OBRACE_NAME_COL_CONTENT_CBRACE_SHARP;
                        break block0;
                    }
                    case '`': {
                        this.children.add((NutsText)text.ofPlain("}"));
                        this.curState = CurState.SHARP2_OBRACE_NAME_COL_CONTENT;
                        this.beforeChangingStep();
                        state.applyPush(c, true, false, this.exitOnBrace);
                        break block0;
                    }
                    case '\u001e': {
                        this.children.add((NutsText)text.ofPlain("}"));
                        this.curState = CurState.SHARP2_OBRACE_NAME_COL_CONTENT;
                        break block0;
                    }
                }
                this.content.append(c);
                break;
            }
            case SHARP2_OBRACE_NAME_COL_CONTENT_CBRACE_SHARP: {
                switch (c) {
                    case '\\': {
                        this.sharpsEndCount = 0;
                        this.content.append('{');
                        this.content.append('#');
                        this.curState = CurState.SHARP2_OBRACE_NAME_COL_CONTENT;
                        this.wasEscape = true;
                        break block0;
                    }
                    case '#': {
                        ++this.sharpsEndCount;
                        this.curState = CurState.SHARP2_OBRACE_NAME_COL_CONTENT_CBRACE_SHARP2_END;
                        state.applyPop();
                        break block0;
                    }
                    case '`': {
                        this.sharpsEndCount = 0;
                        this.children.add((NutsText)text.ofPlain("}#"));
                        this.curState = CurState.SHARP2_OBRACE_NAME_COL_CONTENT;
                        this.beforeChangingStep();
                        state.applyPush(c, true, false, this.exitOnBrace);
                        break block0;
                    }
                    case '\u001e': {
                        this.sharpsEndCount = 0;
                        this.children.add((NutsText)text.ofPlain("}#"));
                        this.curState = CurState.SHARP2_OBRACE_NAME_COL_CONTENT;
                        break block0;
                    }
                }
                this.sharpsEndCount = 0;
                this.children.add((NutsText)text.ofPlain("}#"));
                this.curState = CurState.SHARP2_OBRACE_NAME_COL_CONTENT;
                this.content.append(c);
                break;
            }
            case SHARP_CONTENT_SHARP_END: {
                switch (c) {
                    case '#': {
                        this.curState = CurState.SHARP_CONTENT;
                        int _sharpsEndCount = this.sharpsEndCount;
                        this.sharpsEndCount = 0;
                        this.beforeChangingStep();
                        state.applyPush(new StyledParserStep("#", false, this.session, state, false));
                        for (int i = 0; i < _sharpsEndCount - 1; ++i) {
                            state.applyNextChar('#');
                        }
                        state.applyPopReplay(c);
                        break block0;
                    }
                }
                if (!this.content.isEmpty()) {
                    this.children.add((NutsText)text.ofPlain(this.content.readAll()));
                }
                state.applyPopReplay(c);
                break;
            }
            case SHARP2_COL_NAME_CONTENT_SHARP_END: {
                switch (c) {
                    case '#': {
                        this.curState = CurState.SHARP2_COL_NAME_CONTENT;
                        int _sharpsEndCount = this.sharpsEndCount;
                        this.sharpsEndCount = 0;
                        this.beforeChangingStep();
                        state.applyPush(new StyledParserStep("#", false, this.session, state, false));
                        for (int i = 0; i < _sharpsEndCount - 1; ++i) {
                            state.applyNextChar('#');
                        }
                        state.applyPopReplay(c);
                        break block0;
                    }
                }
                if (!this.content.isEmpty()) {
                    this.children.add((NutsText)text.ofPlain(this.content.readAll()));
                }
                state.applyPopReplay(c);
                break;
            }
            case SHARP2_OBRACE_NAME_COL_CONTENT_CBRACE_SHARP2_END: {
                if (!this.content.isEmpty()) {
                    this.children.add((NutsText)text.ofPlain(this.content.readAll()));
                }
                state.applyPopReplay(c);
                break;
            }
            default: {
                throw new IllegalArgumentException("unexpected " + (Object)((Object)this.curState));
            }
        }
    }

    private void beforeChangingStep() {
        this.charQueue.clear();
    }

    @Override
    public void appendChild(ParserStep tt) {
        NutsText n = tt.toText();
        if (n instanceof NutsTextPlain && !this.children.isEmpty() && this.children.get(this.children.size() - 1) instanceof NutsTextPlain) {
            NutsTextPlain p1 = (NutsTextPlain)this.children.remove(this.children.size() - 1);
            NutsTextPlain p2 = (NutsTextPlain)n;
            this.children.add(new DefaultNutsTextPlain(this.session, p1.getText() + p2.getText()));
        } else {
            this.children.add(n);
        }
    }

    @Override
    public NutsText toText() {
        NutsText a;
        ArrayList<NutsText> childrenTextNodes2 = new ArrayList<NutsText>(this.children);
        NutsTexts text = NutsTexts.of((NutsSession)this.session);
        if (!this.content.isEmpty()) {
            childrenTextNodes2.add((NutsText)text.ofPlain(this.content.toString()));
        }
        if ((a = text.ofList(childrenTextNodes2.toArray(new NutsText[0])).simplify()) == null) {
            return text.ofPlain("");
        }
        switch (this.curState) {
            case SHARP: {
                return text.ofPlain("#");
            }
            case EMPTY: {
                return text.ofPlain("");
            }
            case SHARP_CONTENT: 
            case SHARP_CONTENT_SHARP: 
            case SHARP_CONTENT_SHARP_END: {
                return text.applyStyles(a, new NutsTextStyle[]{NutsTextStyle.primary((int)this.sharpsStartCount)});
            }
            case SHARP2_OBRACE_NAME: {
                return text.ofPlain("##{" + this.name.toString());
            }
            case SHARP2_COL_NAME_CONTENT: 
            case SHARP2_COL_NAME_CONTENT_SHARP: 
            case SHARP2_COL_NAME: 
            case SHARP2_OBRACE_NAME_COL_CONTENT: 
            case SHARP2_OBRACE_NAME_COL_CONTENT_CBRACE: 
            case SHARP2_OBRACE_NAME_COL_CONTENT_CBRACE_SHARP: 
            case SHARP2_COL_NAME_CONTENT_SHARP_END: 
            case SHARP2_OBRACE_NAME_COL_CONTENT_CBRACE_SHARP2_END: 
            case SHARP2_COL_NAME_SHARP1: 
            case SHARP2_COL_NAME_SHARP2: {
                NutsTextStyles s = this.parseHelper.parseSimpleNutsTextStyles(this.name.toString());
                if (s != null) {
                    return text.applyStyles(a, s);
                }
                throw new NutsIllegalArgumentException(this.session, NutsMessage.cstyle((String)"unable to resolve style from %s", (Object[])new Object[]{this.name.toString()}));
            }
        }
        throw new NutsUnsupportedEnumException(this.session, (Enum)this.curState);
    }

    @Override
    public void end(DefaultNutsTextNodeParser.State p) {
        p.applyPop();
    }

    @Override
    public boolean isComplete() {
        switch (this.curState) {
            case SHARP_CONTENT_SHARP_END: 
            case SHARP2_COL_NAME_CONTENT_SHARP_END: 
            case SHARP2_OBRACE_NAME_COL_CONTENT_CBRACE_SHARP2_END: {
                return true;
            }
        }
        return false;
    }

    private void logErr(String s) {
        if (NutsDebugString.of(this.session.boot().getBootOptions().getDebug(), this.session).isEnabled()) {
            this.session.err().println(s);
        }
    }

    public String toString() {
        String contentString = this.children.stream().map(Object::toString).collect(Collectors.joining()) + this.content;
        switch (this.curState) {
            case EMPTY: {
                return "";
            }
            case SHARP: {
                return CoreStringUtils.fillString("#", this.sharpsStartCount);
            }
            case SHARP_CONTENT: {
                return CoreStringUtils.fillString("#", this.sharpsStartCount) + contentString;
            }
            case SHARP_CONTENT_SHARP: 
            case SHARP_CONTENT_SHARP_END: {
                return CoreStringUtils.fillString("#", this.sharpsStartCount) + contentString + CoreStringUtils.fillString("#", this.sharpsEndCount);
            }
            case SHARP2_COL_NAME: {
                return CoreStringUtils.fillString("#", this.sharpsStartCount) + ":" + this.name;
            }
            case SHARP2_COL_NAME_SHARP1: {
                return CoreStringUtils.fillString("#", this.sharpsStartCount) + ":" + this.name + "#";
            }
            case SHARP2_COL_NAME_SHARP2: {
                return CoreStringUtils.fillString("#", this.sharpsStartCount) + ":" + this.name + "##";
            }
            case SHARP2_COL_NAME_CONTENT: {
                return CoreStringUtils.fillString("#", this.sharpsStartCount) + ":" + this.name + ":" + contentString;
            }
            case SHARP2_COL_NAME_CONTENT_SHARP: 
            case SHARP2_COL_NAME_CONTENT_SHARP_END: {
                return CoreStringUtils.fillString("#", this.sharpsStartCount) + ":" + this.name + ":" + contentString + CoreStringUtils.fillString("#", this.sharpsEndCount);
            }
            case SHARP2_OBRACE_NAME: {
                return CoreStringUtils.fillString("#", this.sharpsStartCount) + "{" + this.name;
            }
            case SHARP2_OBRACE_NAME_COL_CONTENT: {
                return CoreStringUtils.fillString("#", this.sharpsStartCount) + "{" + this.name + ":" + contentString;
            }
            case SHARP2_OBRACE_NAME_COL_CONTENT_CBRACE: {
                return CoreStringUtils.fillString("#", this.sharpsStartCount) + "{" + this.name + ":" + this.content + "}";
            }
            case SHARP2_OBRACE_NAME_COL_CONTENT_CBRACE_SHARP: 
            case SHARP2_OBRACE_NAME_COL_CONTENT_CBRACE_SHARP2_END: {
                return CoreStringUtils.fillString("#", this.sharpsStartCount) + "{" + this.name + ":" + contentString + "}" + CoreStringUtils.fillString("#", this.sharpsEndCount);
            }
        }
        return "<unexpected>";
    }

    static enum StyleMode {
        SIMPLE,
        COLON,
        EMBEDDED;

    }

    static enum CurState {
        EMPTY,
        SHARP,
        SHARP_CONTENT,
        SHARP_CONTENT_SHARP,
        SHARP_CONTENT_SHARP_END,
        SHARP2_COL_NAME,
        SHARP2_COL_NAME_CONTENT,
        SHARP2_COL_NAME_CONTENT_SHARP,
        SHARP2_COL_NAME_CONTENT_SHARP_END,
        SHARP2_COL_NAME_SHARP1,
        SHARP2_COL_NAME_SHARP2,
        SHARP2_OBRACE_NAME,
        SHARP2_OBRACE_NAME_COL_CONTENT,
        SHARP2_OBRACE_NAME_COL_CONTENT_CBRACE,
        SHARP2_OBRACE_NAME_COL_CONTENT_CBRACE_SHARP,
        SHARP2_OBRACE_NAME_COL_CONTENT_CBRACE_SHARP2_END;

    }
}

