/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.text.parser.steps;

import java.util.ArrayList;
import java.util.LinkedList;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsText;
import net.thevpc.nuts.NutsTextPlain;
import net.thevpc.nuts.NutsTexts;
import net.thevpc.nuts.runtime.standalone.text.parser.DefaultNutsTextNodeParser;
import net.thevpc.nuts.runtime.standalone.text.parser.DefaultNutsTextPlain;
import net.thevpc.nuts.runtime.standalone.text.parser.steps.ParserStep;

public class RootParserStep
extends ParserStep {
    boolean spreadLines;
    LinkedList<ParserStep> available = new LinkedList();
    private NutsSession session;

    public RootParserStep(boolean spreadLines, NutsSession session) {
        this.spreadLines = spreadLines;
        this.session = session;
    }

    @Override
    public void consume(char c, DefaultNutsTextNodeParser.State p, boolean wasNewLine) {
        p.applyPush(c, this.spreadLines, wasNewLine, false);
    }

    public ParserStep pop() {
        return this.available.pop();
    }

    public ParserStep poll() {
        return this.available.poll();
    }

    public ParserStep peek() {
        return this.available.peek();
    }

    public boolean isEmpty() {
        return this.available.isEmpty();
    }

    public int size() {
        return this.available.size();
    }

    @Override
    public void appendChild(ParserStep n) {
        this.available.add(n);
    }

    @Override
    public NutsText toText() {
        if (this.available.size() == 1) {
            return this.available.get(0).toText();
        }
        ArrayList<NutsText> all = new ArrayList<NutsText>();
        boolean partial = false;
        for (ParserStep a : this.available) {
            NutsText n;
            if (!partial && !a.isComplete()) {
                partial = true;
            }
            if ((n = a.toText()) instanceof DefaultNutsTextPlain && !all.isEmpty() && all.get(all.size() - 1) instanceof DefaultNutsTextPlain) {
                NutsTextPlain p1 = (NutsTextPlain)n;
                NutsTextPlain p2 = (NutsTextPlain)all.remove(all.size() - 1);
                all.add(new DefaultNutsTextPlain(this.session, p1.getText() + p2.getText()));
                continue;
            }
            all.add(n);
        }
        return NutsTexts.of((NutsSession)this.session).ofList(all).simplify();
    }

    @Override
    public void end(DefaultNutsTextNodeParser.State p) {
    }

    @Override
    public boolean isComplete() {
        return true;
    }

    public String toString() {
        return "Root(" + this.available + ')';
    }
}

