/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.text.parser.steps;

import java.util.function.IntPredicate;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsText;
import net.thevpc.nuts.NutsTexts;
import net.thevpc.nuts.runtime.standalone.text.parser.DefaultNutsTextNodeParser;
import net.thevpc.nuts.runtime.standalone.text.parser.steps.ParserStep;
import net.thevpc.nuts.runtime.standalone.text.parser.steps.StyledParserStep;
import net.thevpc.nuts.runtime.standalone.util.StringBuilder2;

public class PlainParserStep
extends ParserStep {
    char last = '\u0000';
    private StringBuilder escape;
    private boolean lineStart;
    private StringBuilder2 value = new StringBuilder2();
    private NutsSession session;
    private DefaultNutsTextNodeParser.State state;
    private IntPredicate exitCondition;
    private boolean exitOnBrace;

    public PlainParserStep(char c, boolean lineStart, NutsSession session, DefaultNutsTextNodeParser.State state, IntPredicate exitCondition, boolean exitOnBrace) {
        this.state = state;
        this.exitCondition = exitCondition;
        this.session = session;
        this.lineStart = state.isLineStart();
        if (c == '\\') {
            this.escape = new StringBuilder("\\");
        } else {
            this.value.append(c);
        }
        this.last = c;
        state.setLineStart(c == '\n');
        this.exitOnBrace = exitOnBrace;
    }

    public PlainParserStep(String s, boolean spreadLines, boolean lineStart, NutsSession session, DefaultNutsTextNodeParser.State state, IntPredicate exitCondition, boolean preParsed, boolean exitOnBrace) {
        this.state = state;
        this.exitCondition = exitCondition;
        this.exitOnBrace = exitOnBrace;
        this.session = session;
        this.lineStart = state.isLineStart();
        if (preParsed) {
            this.value.append(s);
            this.last = this.value.last();
            state.setLineStart(s.indexOf(10) >= 0);
        } else {
            char c = s.charAt(0);
            if (c == '\\') {
                this.escape = new StringBuilder("\\");
            } else {
                this.value.append(c);
            }
            this.last = c;
            state.setLineStart(c == '\n');
            for (int i = 1; i < s.length(); ++i) {
                char c2 = s.charAt(i);
                this.consume(c2, state, false);
            }
        }
    }

    @Override
    public void consume(char c, DefaultNutsTextNodeParser.State p, boolean wasNewLine) {
        char oldLast = this.last;
        this.state.setLineStart(c == '\n');
        this.last = c;
        switch (c) {
            case '#': {
                if (this.escape != null) {
                    if (!this.escape.toString().equals("\\")) {
                        this.value.append(this.escape);
                    }
                    this.escape = null;
                    this.value.append(c);
                    this.last = '\u0000';
                    return;
                }
                if (this.exitCondition != null && this.exitCondition.test(c)) {
                    p.applyPopReplay(c);
                    return;
                }
                if (oldLast == c) {
                    this.value.readLast();
                    if (this.value.length() == 0) {
                        p.applyDropReplace(new StyledParserStep(c + "" + c, this.lineStart, this.session, this.state, this.exitOnBrace));
                        return;
                    }
                    p.applyPopReplace(new StyledParserStep(c + "" + c, this.lineStart, this.session, this.state, this.exitOnBrace));
                    return;
                }
                p.applyPopReplay(c);
                return;
            }
            case '\u001e': {
                if (this.escape != null) {
                    if (!this.escape.toString().equals("\\")) {
                        this.value.append(this.escape);
                    }
                    this.escape = null;
                    this.value.append(c);
                    this.last = '\u0000';
                    return;
                }
                if (this.exitCondition != null && this.exitCondition.test(c)) {
                    p.applyPopReplay(c);
                    return;
                }
                p.applyPop();
                return;
            }
            case '`': {
                if (this.escape != null) {
                    if (!this.escape.toString().equals("\\")) {
                        this.value.append(this.escape);
                    }
                    this.escape = null;
                    this.value.append(c);
                    return;
                }
                if (this.exitCondition != null && this.exitCondition.test(c)) {
                    p.applyPopReplay(c);
                    return;
                }
                p.applyPopReplay(c);
                return;
            }
            case '\n': 
            case '\r': {
                if (this.escape != null) {
                    if (!this.escape.toString().equals("\\")) {
                        this.value.append(this.escape);
                    }
                    this.escape = null;
                    this.value.append(c);
                    p.applyPop();
                    p.forceEnding();
                } else {
                    p.applyPopReplay(c);
                }
                return;
            }
            case '\\': {
                if (this.escape != null) {
                    if (this.escape.toString().equals("\\")) {
                        this.value.append(c);
                    } else {
                        this.value.append(this.escape);
                        this.value.append(c);
                    }
                    this.escape = null;
                } else {
                    this.escape = new StringBuilder("\\");
                }
                return;
            }
        }
        if (this.escape != null) {
            if (this.escape.length() == 1 && c == 'u' || this.escape.length() >= 2 && this.escape.length() <= 5 && (c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F')) {
                this.escape.append(c);
                if (this.escape.length() == 6) {
                    this.value.append(this.escape);
                    int cval = 0;
                    block12: for (int i = 0; i < 4; ++i) {
                        char aChar = this.escape.charAt(i + 2);
                        switch (aChar) {
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': {
                                cval = (cval << 4) + aChar - 48;
                                continue block12;
                            }
                            case 'a': 
                            case 'b': 
                            case 'c': 
                            case 'd': 
                            case 'e': 
                            case 'f': {
                                cval = (cval << 4) + 10 + aChar - 97;
                                continue block12;
                            }
                            case 'A': 
                            case 'B': 
                            case 'C': 
                            case 'D': 
                            case 'E': 
                            case 'F': {
                                cval = (cval << 4) + 10 + aChar - 65;
                            }
                        }
                    }
                    char cc = (char)cval;
                    this.escape = null;
                    this.consume(cc, p, false);
                    return;
                }
            } else {
                this.value.append(this.escape);
                this.value.append(c);
                this.escape = null;
            }
            return;
        }
        if (c == '}' && this.exitOnBrace || this.exitCondition != null && this.exitCondition.test(c)) {
            p.applyPopReplay(c);
        } else {
            this.value.append(c);
        }
    }

    @Override
    public void appendChild(ParserStep tt) {
        throw new UnsupportedOperationException("unsupported operation: appendChild");
    }

    @Override
    public NutsText toText() {
        String t = this.value.toString();
        return NutsTexts.of((NutsSession)this.session).ofPlain(t);
    }

    @Override
    public void end(DefaultNutsTextNodeParser.State p) {
        p.applyPop();
    }

    @Override
    public boolean isComplete() {
        return true;
    }

    public String toString() {
        return this.value.toString();
    }
}

